package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20170404
  */
case class PartyRoleField(override val value: Int) extends SfFieldInt(452, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(452)PartyRole=(").append(value).append(")").append(PartyRoleField.fixDescriptionByValue.getOrElse(value,""))
}

object PartyRoleField {
  val TagId = 452 
  val ExecutingFirm=1
  val BrokerOfCredit=2
  val ClientId=3
  val ClearingFirm=4
  val InvestorId=5
  val IntroducingFirm=6
  val EnteringFirm=7
  val LocateLendingFirm=8
  val FundManagerClientId=9
  val SettlementLocation=10
  val OrderOriginationTrader=11
  val ExecutingTrader=12
  val OrderOriginationFirm=13
  val GiveupClearingFirm=14
  val CorrespondantClearingFirm=15
  val ExecutingSystem=16
  val ContraFirm=17
  val ContraClearingFirm=18
  val SponsoringFirm=19
  val UnderlyingContraFirm=20
  val ClearingOrganization=21
  val Exchange=22
  val CustomerAccount=24
  val CorrespondentClearingOrganization=25
  val CorrespondentBroker=26
  val BuyerSeller=27
  val Custodian=28
  val Intermediary=29
  val Agent=30
  val SubCustodian=31
  val Beneficiary=32
  val InterestedParty=33
  val RegulatoryBody=34
  val LiquidityProvider=35
  val EnteringTrader=36
  val ContraTrader=37
  val PositionAccount=38
  val ContraInvestorId=39
  val TransferToFirm=40
  val ContraPositionAccount=41
  val ContraExchange=42
  val InternalCarryAccount=43
  val OrderEntryOperatorId=44
  val SecondaryAccountNumber=45
  val ForiegnFirm=46
  val ThirdPartyAllocationFirm=47
  val ClaimingAccount=48
  val AssetManager=49
  val PledgorAccount=50
  val PledgeeAccount=51
  val LargeTraderReportableAccount=52
  val TraderMnemonic=53
  val SenderLocation=54
  val SessionId=55
  val AcceptableCounterparty=56
  val UnacceptableCounterparty=57
  val EnteringUnit=58
  val ExecutingUnit=59
  val IntroducingBroker=60
  val QuoteOriginator=61
  val ReportOriginator=62
  val SystematicInternaliser=63
  val MultilateralTradingFacility=64
  val RegulatedMarket=65
  val MarketMaker=66
  val InvestmentFirm=67
  val HostCompetentAuthority=68
  val HomeCompetentAuthority=69
  val CompetentAuthorityOfTheMostRelevantMarketInTermsOfLiquidity=70
  val CompetentAuthorityOfTheTransaction=71
  val ReportingIntermediary=72
  val ExecutionVenue=73
  val MarketDataEntryOriginator=74
  val LocationId=75
  val DeskId=76
  val MarketDataMarket=77
  val AllocationEntity=78
  lazy val fixDescriptionByValue = Map(1->"EXECUTING_FIRM",2->"BROKER_OF_CREDIT",
    3->"CLIENT_ID",4->"CLEARING_FIRM",5->"INVESTOR_ID",
    6->"INTRODUCING_FIRM",7->"ENTERING_FIRM",8->"LOCATE_LENDING_FIRM",
    9->"FUND_MANAGER_CLIENT_ID",10->"SETTLEMENT_LOCATION",11->"ORDER_ORIGINATION_TRADER",
    12->"EXECUTING_TRADER",13->"ORDER_ORIGINATION_FIRM",14->"GIVEUP_CLEARING_FIRM",
    15->"CORRESPONDANT_CLEARING_FIRM",16->"EXECUTING_SYSTEM",17->"CONTRA_FIRM",
    18->"CONTRA_CLEARING_FIRM",19->"SPONSORING_FIRM",20->"UNDERLYING_CONTRA_FIRM",
    21->"CLEARING_ORGANIZATION",22->"EXCHANGE",24->"CUSTOMER_ACCOUNT",
    25->"CORRESPONDENT_CLEARING_ORGANIZATION",26->"CORRESPONDENT_BROKER",27->"BUYER_SELLER",
    28->"CUSTODIAN",29->"INTERMEDIARY",30->"AGENT",
    31->"SUB_CUSTODIAN",32->"BENEFICIARY",33->"INTERESTED_PARTY",
    34->"REGULATORY_BODY",35->"LIQUIDITY_PROVIDER",36->"ENTERING_TRADER",
    37->"CONTRA_TRADER",38->"POSITION_ACCOUNT",39->"CONTRA_INVESTOR_ID",
    40->"TRANSFER_TO_FIRM",41->"CONTRA_POSITION_ACCOUNT",42->"CONTRA_EXCHANGE",
    43->"INTERNAL_CARRY_ACCOUNT",44->"ORDER_ENTRY_OPERATOR_ID",45->"SECONDARY_ACCOUNT_NUMBER",
    46->"FORIEGN_FIRM",47->"THIRD_PARTY_ALLOCATION_FIRM",48->"CLAIMING_ACCOUNT",
    49->"ASSET_MANAGER",50->"PLEDGOR_ACCOUNT",51->"PLEDGEE_ACCOUNT",
    52->"LARGE_TRADER_REPORTABLE_ACCOUNT",53->"TRADER_MNEMONIC",54->"SENDER_LOCATION",
    55->"SESSION_ID",56->"ACCEPTABLE_COUNTERPARTY",57->"UNACCEPTABLE_COUNTERPARTY",
    58->"ENTERING_UNIT",59->"EXECUTING_UNIT",60->"INTRODUCING_BROKER",
    61->"QUOTE_ORIGINATOR",62->"REPORT_ORIGINATOR",63->"SYSTEMATIC_INTERNALISER",
    64->"MULTILATERAL_TRADING_FACILITY",65->"REGULATED_MARKET",66->"MARKET_MAKER",
    67->"INVESTMENT_FIRM",68->"HOST_COMPETENT_AUTHORITY",69->"HOME_COMPETENT_AUTHORITY",
    70->"COMPETENT_AUTHORITY_OF_THE_MOST_RELEVANT_MARKET_IN_TERMS_OF_LIQUIDITY",71->"COMPETENT_AUTHORITY_OF_THE_TRANSACTION",72->"REPORTING_INTERMEDIARY",
    73->"EXECUTION_VENUE",74->"MARKET_DATA_ENTRY_ORIGINATOR",75->"LOCATION_ID",
    76->"DESK_ID",77->"MARKET_DATA_MARKET",78->"ALLOCATION_ENTITY")
 
  def apply(value: String) = try {
    new PartyRoleField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new PartyRole("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[PartyRoleField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[PartyRoleField]
  }

  def decode(a: Any) : Option[PartyRoleField] = a match {
    case v: String => Some(PartyRoleField(v))
    case v: Int => Some(PartyRoleField(v))
    case v: PartyRoleField => Some(v)
    case _ => scala.Option.empty[PartyRoleField]
  } 
}
