package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldString

/**
  * Generated by SackFix code generator on 20170404
  */
case class QuoteConditionField(override val value: String) extends SfFieldString(276, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(276)QuoteCondition=(").append(value).append(")").append(QuoteConditionField.fixDescriptionByValue.getOrElse(value,""))
}

object QuoteConditionField {
  val TagId = 276 
  val OpenActive="A"
  val ClosedInactive="B"
  val ExchangeBest="C"
  val ConsolidatedBest="D"
  val Locked="E"
  val Crossed="F"
  val Depth="G"
  val FastTrading="H"
  val NonFirm="I"
  val ManualSlowQuote="L"
  val OutrightPrice="J"
  val ImpliedPrice="K"
  val DepthOnOffer="M"
  val DepthOnBid="N"
  val Closing="O"
  val NewsDissemination="P"
  val TradingRange="Q"
  val OrderInflux="R"
  val DueToRelated="S"
  val NewsPending="T"
  val AdditionalInfo="U"
  val AdditionalInfoDueToRelated="V"
  val Resume="W"
  val ViewOfCommon="X"
  val VolumeAlert="Y"
  val OrderImbalance="Z"
  val EquipmentChangeover="a"
  val NoOpen="b"
  val RegularEth="c"
  val AutomaticExecution="d"
  val AutomaticExecutionEth="e"
  val FastMarketEth="f"
  val InactiveEth="g"
  val Rotation="h"
  val RotationEth="i"
  val Halt="j"
  val HaltEth="k"
  val DueToNewsDissemination="l"
  val DueToNewsPending="m"
  val TradingResume="n"
  val OutOfSequence="o"
  val BidSpecialist="p"
  val OfferSpecialist="q"
  val BidOfferSpecialist="r"
  val EndOfDaySam="s"
  val ForbiddenSam="t"
  val FrozenSam="u"
  val PreopeningSam="v"
  val OpeningSam="w"
  val OpenSam="x"
  val SurveillanceSam="y"
  val SuspendedSam="z"
  val ReservedSam="0"
  val NoActiveSam="1"
  val Restricted="2"
  val NoMarketActivity="1000"
  val NoDataAvailable="1001"
  val NotApplicable="1002"
  val AmountThresholdExceeded="1003"
  lazy val fixDescriptionByValue = Map("A"->"OPEN_ACTIVE","B"->"CLOSED_INACTIVE",
    "C"->"EXCHANGE_BEST","D"->"CONSOLIDATED_BEST","E"->"LOCKED",
    "F"->"CROSSED","G"->"DEPTH","H"->"FAST_TRADING",
    "I"->"NON_FIRM","L"->"MANUAL_SLOW_QUOTE","J"->"OUTRIGHT_PRICE",
    "K"->"IMPLIED_PRICE","M"->"DEPTH_ON_OFFER","N"->"DEPTH_ON_BID",
    "O"->"CLOSING","P"->"NEWS_DISSEMINATION","Q"->"TRADING_RANGE",
    "R"->"ORDER_INFLUX","S"->"DUE_TO_RELATED","T"->"NEWS_PENDING",
    "U"->"ADDITIONAL_INFO","V"->"ADDITIONAL_INFO_DUE_TO_RELATED","W"->"RESUME",
    "X"->"VIEW_OF_COMMON","Y"->"VOLUME_ALERT","Z"->"ORDER_IMBALANCE",
    "a"->"EQUIPMENT_CHANGEOVER","b"->"NO_OPEN","c"->"REGULAR_ETH",
    "d"->"AUTOMATIC_EXECUTION","e"->"AUTOMATIC_EXECUTION_ETH","f"->"FAST_MARKET_ETH",
    "g"->"INACTIVE_ETH","h"->"ROTATION","i"->"ROTATION_ETH",
    "j"->"HALT","k"->"HALT_ETH","l"->"DUE_TO_NEWS_DISSEMINATION",
    "m"->"DUE_TO_NEWS_PENDING","n"->"TRADING_RESUME","o"->"OUT_OF_SEQUENCE",
    "p"->"BID_SPECIALIST","q"->"OFFER_SPECIALIST","r"->"BID_OFFER_SPECIALIST",
    "s"->"END_OF_DAY_SAM","t"->"FORBIDDEN_SAM","u"->"FROZEN_SAM",
    "v"->"PREOPENING_SAM","w"->"OPENING_SAM","x"->"OPEN_SAM",
    "y"->"SURVEILLANCE_SAM","z"->"SUSPENDED_SAM","0"->"RESERVED_SAM",
    "1"->"NO_ACTIVE_SAM","2"->"RESTRICTED","1000"->"NO_MARKET_ACTIVITY",
    "1001"->"NO_DATA_AVAILABLE","1002"->"NOT_APPLICABLE","1003"->"AMOUNT_THRESHOLD_EXCEEDED")
 
  def decode(a: Option[Any]) : Option[QuoteConditionField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[QuoteConditionField]
  }

  def decode(a: Any) : Option[QuoteConditionField] = a match {
    case v: String => Some(QuoteConditionField(v))
    case v: QuoteConditionField => Some(v)
    case _ => scala.Option.empty[QuoteConditionField]
  } 
}
