package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldUtcTimeStamp
import java.time.LocalDateTime
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20170404
  */
case class SimulatedTimeField(override val value: LocalDateTime) extends SfFieldUtcTimeStamp(8000, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(8000)SimulatedTime=(").append(value).append(")")
}

object SimulatedTimeField {
  val TagId = 8000  
  def apply(value: String) = try {
    new SimulatedTimeField(LocalDateTime.from(SfFixDateFormats.utcTimeStamp.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new SimulatedTime("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[SimulatedTimeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[SimulatedTimeField]
  }

  def decode(a: Any) : Option[SimulatedTimeField] = a match {
    case v: String => Some(SimulatedTimeField(v))
    case v: LocalDateTime => Some(SimulatedTimeField(v))
    case v: SimulatedTimeField => Some(v)
    case _ => scala.Option.empty[SimulatedTimeField]
  } 
}
