package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldTzTimeStamp
import java.time.OffsetDateTime
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20170404
  */
case class TZTransactTimeField(override val value: OffsetDateTime) extends SfFieldTzTimeStamp(1132, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(1132)TZTransactTime=(").append(value).append(")")
}

object TZTransactTimeField {
  val TagId = 1132  
  def apply(value: String) = try {
    new TZTransactTimeField(OffsetDateTime.from(SfFixDateFormats.tzTimeStamp.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new TZTransactTime("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[TZTransactTimeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[TZTransactTimeField]
  }

  def decode(a: Any) : Option[TZTransactTimeField] = a match {
    case v: String => Some(TZTransactTimeField(v))
    case v: OffsetDateTime => Some(TZTransactTimeField(v))
    case v: TZTransactTimeField => Some(v)
    case _ => scala.Option.empty[TZTransactTimeField]
  } 
}
