package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldLocalMktDate
import java.time.LocalDate
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20170404
  */
case class TradeDateField(override val value: LocalDate) extends SfFieldLocalMktDate(75, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(75)TradeDate=(").append(value).append(")")
}

object TradeDateField {
  val TagId = 75  
  def apply(value: String) = try {
    new TradeDateField(LocalDate.from(SfFixDateFormats.localMktDate.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new TradeDate("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[TradeDateField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[TradeDateField]
  }

  def decode(a: Any) : Option[TradeDateField] = a match {
    case v: String => Some(TradeDateField(v))
    case v: LocalDate => Some(TradeDateField(v))
    case v: TradeDateField => Some(v)
    case _ => scala.Option.empty[TradeDateField]
  } 
}
