package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldUtcTimeStamp
import java.time.LocalDateTime
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20170404
  */
case class TransactTimeField(override val value: LocalDateTime) extends SfFieldUtcTimeStamp(60, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(60)TransactTime=(").append(value).append(")")
}

object TransactTimeField {
  val TagId = 60  
  def apply(value: String) = try {
    new TransactTimeField(LocalDateTime.from(SfFixDateFormats.utcTimeStamp.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new TransactTime("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[TransactTimeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[TransactTimeField]
  }

  def decode(a: Any) : Option[TransactTimeField] = a match {
    case v: String => Some(TransactTimeField(v))
    case v: LocalDateTime => Some(TransactTimeField(v))
    case v: TransactTimeField => Some(v)
    case _ => scala.Option.empty[TransactTimeField]
  } 
}
