package org.sackfix.common.objectpool

import scala.collection.mutable
import scala.collection.mutable.ArrayBuffer

/**
  * While Tuple2 seems obvious for holding Int,String pairs it creates loads of temp
  * objects.  So this pool serves out reusable objects.
  *
  * Because it is used by an Actor, it is NOT with Synchronized.
  */
class MutableFixTagValuePool(val maxSize :Int = 200) {
  private var pool = mutable.Queue.empty[SfTagValue]

  def alloc(tag:Int, value:String) : SfTagValue = {
    if (pool.isEmpty) SfTagValue(tag, value)
    else {
      val tv = pool.dequeue()
      tv.tag = tag
      tv.value = value
      tv.isAllocated = true
      tv
    }
  }

  def free(tv:SfTagValue): Unit = {
    // isAllocated is a very simple guard to stop multiple puts of the same object back to
    // the pool, which would be a disaster
    if (tv.isAllocated) {
      if (pool.size < maxSize) pool += tv
      tv.isAllocated = false
    }
  }

  def free(pairs : ArrayBuffer[SfTagValue]): Unit = {
    pairs.foreach(free(_))
  }

  def size():Int = pool.size
}

case class SfTagValue(var tag:Int, var value:String) {
  private[objectpool] var isAllocated = true
}
