package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20210314
  */
case class CollInquiryResultField(override val value: Int) extends SfFieldInt(946, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(946)CollInquiryResult=(").append(value).append(")").append(CollInquiryResultField.fixDescriptionByValue.getOrElse(value,""))
}

object CollInquiryResultField {
  val TagId = 946 
  val Successful=0
  val InvalidOrUnknownInstrument=1
  val InvalidOrUnknownCollateralType=2
  val InvalidParties=3
  val InvalidTransportTypeRequested=4
  val InvalidDestinationRequested=5
  val NoCollateralFoundForTheTradeSpecified=6
  val NoCollateralFoundForTheOrderSpecified=7
  val CollateralInquiryTypeNotSupported=8
  val UnauthorizedForCollateralInquiry=9
  val Other=99
  lazy val fixDescriptionByValue = Map(0->"SUCCESSFUL",1->"INVALID_OR_UNKNOWN_INSTRUMENT",
    2->"INVALID_OR_UNKNOWN_COLLATERAL_TYPE",3->"INVALID_PARTIES",4->"INVALID_TRANSPORT_TYPE_REQUESTED",
    5->"INVALID_DESTINATION_REQUESTED",6->"NO_COLLATERAL_FOUND_FOR_THE_TRADE_SPECIFIED",7->"NO_COLLATERAL_FOUND_FOR_THE_ORDER_SPECIFIED",
    8->"COLLATERAL_INQUIRY_TYPE_NOT_SUPPORTED",9->"UNAUTHORIZED_FOR_COLLATERAL_INQUIRY",99->"OTHER")
 
  def apply(value: String) = try {
    new CollInquiryResultField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new CollInquiryResult("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[CollInquiryResultField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[CollInquiryResultField]
  }

  def decode(a: Any) : Option[CollInquiryResultField] = a match {
    case v: String => Some(CollInquiryResultField(v))
    case v: Int => Some(CollInquiryResultField(v))
    case v: CollInquiryResultField => Some(v)
    case _ => scala.Option.empty[CollInquiryResultField]
  } 
}
