package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldUtcTimeOnly
import java.time.LocalTime
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20210314
  */
case class ComplexEventEndTimeField(override val value: LocalTime) extends SfFieldUtcTimeOnly(1496, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(1496)ComplexEventEndTime=(").append(value).append(")")
}

object ComplexEventEndTimeField {
  val TagId = 1496  
  def apply(value: String) = try {
    new ComplexEventEndTimeField(LocalTime.from(SfFixDateFormats.utcTimeOnly.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new ComplexEventEndTime("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[ComplexEventEndTimeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[ComplexEventEndTimeField]
  }

  def decode(a: Any) : Option[ComplexEventEndTimeField] = a match {
    case v: String => Some(ComplexEventEndTimeField(v))
    case v: LocalTime => Some(ComplexEventEndTimeField(v))
    case v: ComplexEventEndTimeField => Some(v)
    case _ => scala.Option.empty[ComplexEventEndTimeField]
  } 
}
