package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldUtcTimeOnly
import java.time.LocalTime
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20210314
  */
case class ComplexEventStartTimeField(override val value: LocalTime) extends SfFieldUtcTimeOnly(1495, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(1495)ComplexEventStartTime=(").append(value).append(")")
}

object ComplexEventStartTimeField {
  val TagId = 1495  
  def apply(value: String) = try {
    new ComplexEventStartTimeField(LocalTime.from(SfFixDateFormats.utcTimeOnly.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new ComplexEventStartTime("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[ComplexEventStartTimeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[ComplexEventStartTimeField]
  }

  def decode(a: Any) : Option[ComplexEventStartTimeField] = a match {
    case v: String => Some(ComplexEventStartTimeField(v))
    case v: LocalTime => Some(ComplexEventStartTimeField(v))
    case v: ComplexEventStartTimeField => Some(v)
    case _ => scala.Option.empty[ComplexEventStartTimeField]
  } 
}
