package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldLocalMktDate
import java.time.LocalDate
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20210314
  */
case class EventDateField(override val value: LocalDate) extends SfFieldLocalMktDate(866, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(866)EventDate=(").append(value).append(")")
}

object EventDateField {
  val TagId = 866  
  def apply(value: String) = try {
    new EventDateField(LocalDate.from(SfFixDateFormats.localMktDate.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new EventDate("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[EventDateField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[EventDateField]
  }

  def decode(a: Any) : Option[EventDateField] = a match {
    case v: String => Some(EventDateField(v))
    case v: LocalDate => Some(EventDateField(v))
    case v: EventDateField => Some(v)
    case _ => scala.Option.empty[EventDateField]
  } 
}
