package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20210314
  */
case class EventTypeField(override val value: Int) extends SfFieldInt(865, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(865)EventType=(").append(value).append(")").append(EventTypeField.fixDescriptionByValue.getOrElse(value,""))
}

object EventTypeField {
  val TagId = 865 
  val Put=1
  val Call=2
  val Tender=3
  val SinkingFundCall=4
  val Activation=5
  val Inactiviation=6
  val Other=99
  lazy val fixDescriptionByValue = Map(1->"PUT",2->"CALL",
    3->"TENDER",4->"SINKING_FUND_CALL",5->"ACTIVATION",
    6->"INACTIVIATION",99->"OTHER")
 
  def apply(value: String) = try {
    new EventTypeField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new EventType("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[EventTypeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[EventTypeField]
  }

  def decode(a: Any) : Option[EventTypeField] = a match {
    case v: String => Some(EventTypeField(v))
    case v: Int => Some(EventTypeField(v))
    case v: EventTypeField => Some(v)
    case _ => scala.Option.empty[EventTypeField]
  } 
}
