package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldString

/**
  * Generated by SackFix code generator on 20210314
  */
case class OrdTypeField(override val value: String) extends SfFieldString(40, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(40)OrdType=(").append(value).append(")").append(OrdTypeField.fixDescriptionByValue.getOrElse(value,""))
}

object OrdTypeField {
  val TagId = 40 
  val Market="1"
  val Limit="2"
  val Stop="3"
  val StopLimit="4"
  val MarketOnClose="5"
  val WithOrWithout="6"
  val LimitOrBetter="7"
  val LimitWithOrWithout="8"
  val OnBasis="9"
  val OnClose="A"
  val LimitOnClose="B"
  val ForexMarket="C"
  val PreviouslyQuoted="D"
  val PreviouslyIndicated="E"
  val ForexLimit="F"
  val ForexSwap="G"
  val ForexPreviouslyQuoted="H"
  val Funari="I"
  val MarketIfTouched="J"
  val MarketWithLeftoverAsLimit="K"
  val PreviousFundValuationPoint="L"
  val NextFundValuationPoint="M"
  val Pegged="P"
  val CounterOrderSelection="Q"
  lazy val fixDescriptionByValue = Map("1"->"MARKET","2"->"LIMIT",
    "3"->"STOP","4"->"STOP_LIMIT","5"->"MARKET_ON_CLOSE",
    "6"->"WITH_OR_WITHOUT","7"->"LIMIT_OR_BETTER","8"->"LIMIT_WITH_OR_WITHOUT",
    "9"->"ON_BASIS","A"->"ON_CLOSE","B"->"LIMIT_ON_CLOSE",
    "C"->"FOREX_MARKET","D"->"PREVIOUSLY_QUOTED","E"->"PREVIOUSLY_INDICATED",
    "F"->"FOREX_LIMIT","G"->"FOREX_SWAP","H"->"FOREX_PREVIOUSLY_QUOTED",
    "I"->"FUNARI","J"->"MARKET_IF_TOUCHED","K"->"MARKET_WITH_LEFTOVER_AS_LIMIT",
    "L"->"PREVIOUS_FUND_VALUATION_POINT","M"->"NEXT_FUND_VALUATION_POINT","P"->"PEGGED",
    "Q"->"COUNTER_ORDER_SELECTION")
 
  def decode(a: Option[Any]) : Option[OrdTypeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[OrdTypeField]
  }

  def decode(a: Any) : Option[OrdTypeField] = a match {
    case v: String => Some(OrdTypeField(v))
    case v: Char => Some(OrdTypeField(v.toString))
    case v: OrdTypeField => Some(v)
    case _ => scala.Option.empty[OrdTypeField]
  } 
}
