package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20210314
  */
case class ProductField(override val value: Int) extends SfFieldInt(460, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(460)Product=(").append(value).append(")").append(ProductField.fixDescriptionByValue.getOrElse(value,""))
}

object ProductField {
  val TagId = 460 
  val Agency=1
  val Commodity=2
  val Corporate=3
  val Currency=4
  val Equity=5
  val Government=6
  val Index=7
  val Loan=8
  val Moneymarket=9
  val Mortgage=10
  val Municipal=11
  val Other=12
  val Financing=13
  lazy val fixDescriptionByValue = Map(1->"AGENCY",2->"COMMODITY",
    3->"CORPORATE",4->"CURRENCY",5->"EQUITY",
    6->"GOVERNMENT",7->"INDEX",8->"LOAN",
    9->"MONEYMARKET",10->"MORTGAGE",11->"MUNICIPAL",
    12->"OTHER",13->"FINANCING")
 
  def apply(value: String) = try {
    new ProductField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new Product("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[ProductField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[ProductField]
  }

  def decode(a: Any) : Option[ProductField] = a match {
    case v: String => Some(ProductField(v))
    case v: Int => Some(ProductField(v))
    case v: ProductField => Some(v)
    case _ => scala.Option.empty[ProductField]
  } 
}
