package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20210314
  */
case class QuoteResponseLevelField(override val value: Int) extends SfFieldInt(301, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(301)QuoteResponseLevel=(").append(value).append(")").append(QuoteResponseLevelField.fixDescriptionByValue.getOrElse(value,""))
}

object QuoteResponseLevelField {
  val TagId = 301 
  val NoAcknowledgement=0
  val AcknowledgeOnlyNegativeOrErroneousQuotes=1
  val AcknowledgeEachQuoteMessages=2
  lazy val fixDescriptionByValue = Map(0->"NO_ACKNOWLEDGEMENT",1->"ACKNOWLEDGE_ONLY_NEGATIVE_OR_ERRONEOUS_QUOTES",
    2->"ACKNOWLEDGE_EACH_QUOTE_MESSAGES")
 
  def apply(value: String) = try {
    new QuoteResponseLevelField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new QuoteResponseLevel("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[QuoteResponseLevelField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[QuoteResponseLevelField]
  }

  def decode(a: Any) : Option[QuoteResponseLevelField] = a match {
    case v: String => Some(QuoteResponseLevelField(v))
    case v: Int => Some(QuoteResponseLevelField(v))
    case v: QuoteResponseLevelField => Some(v)
    case _ => scala.Option.empty[QuoteResponseLevelField]
  } 
}
