package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20210314
  */
case class QuoteStatusField(override val value: Int) extends SfFieldInt(297, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(297)QuoteStatus=(").append(value).append(")").append(QuoteStatusField.fixDescriptionByValue.getOrElse(value,""))
}

object QuoteStatusField {
  val TagId = 297 
  val Accepted=0
  val CanceledForSymbol=1
  val Pending=10
  val Pass=11
  val LockedMarketWarning=12
  val CrossMarketWarning=13
  val CanceledDueToLockMarket=14
  val CanceledDueToCrossMarket=15
  val CanceledForSecurityType=2
  val CanceledForUnderlying=3
  val CanceledAll=4
  val Rejected=5
  val RemovedFromMarket=6
  val Expired=7
  val Query=8
  val QuoteNotFound=9
  lazy val fixDescriptionByValue = Map(0->"ACCEPTED",1->"CANCELED_FOR_SYMBOL",
    10->"PENDING",11->"PASS",12->"LOCKED_MARKET_WARNING",
    13->"CROSS_MARKET_WARNING",14->"CANCELED_DUE_TO_LOCK_MARKET",15->"CANCELED_DUE_TO_CROSS_MARKET",
    2->"CANCELED_FOR_SECURITY_TYPE",3->"CANCELED_FOR_UNDERLYING",4->"CANCELED_ALL",
    5->"REJECTED",6->"REMOVED_FROM_MARKET",7->"EXPIRED",
    8->"QUERY",9->"QUOTE_NOT_FOUND")
 
  def apply(value: String) = try {
    new QuoteStatusField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new QuoteStatus("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[QuoteStatusField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[QuoteStatusField]
  }

  def decode(a: Any) : Option[QuoteStatusField] = a match {
    case v: String => Some(QuoteStatusField(v))
    case v: Int => Some(QuoteStatusField(v))
    case v: QuoteStatusField => Some(v)
    case _ => scala.Option.empty[QuoteStatusField]
  } 
}
