package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20210314
  */
case class RegistRejReasonCodeField(override val value: Int) extends SfFieldInt(507, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(507)RegistRejReasonCode=(").append(value).append(")").append(RegistRejReasonCodeField.fixDescriptionByValue.getOrElse(value,""))
}

object RegistRejReasonCodeField {
  val TagId = 507 
  val InvalidUnacceptableAccountType=1
  val InvalidUnacceptableTaxExemptType=2
  val InvalidUnacceptableOwnershipType=3
  val InvalidUnacceptableNoRegDetls=4
  val InvalidUnacceptableRegSeqNo=5
  val InvalidUnacceptableRegDtls=6
  val InvalidUnacceptableMailingDtls=7
  val InvalidUnacceptableMailingInst=8
  val InvalidUnacceptableInvestorId=9
  val InvalidUnacceptableInvestorIdSource=10
  val InvalidUnacceptableDateOfBirth=11
  val InvalidUnacceptableInvestorCountryOfResidence=12
  val InvalidUnacceptableNodistribinstns=13
  val InvalidUnacceptableDistribPercentage=14
  val InvalidUnacceptableDistribPaymentMethod=15
  val InvalidUnacceptableCashDistribAgentAcctName=16
  val InvalidUnacceptableCashDistribAgentCode=17
  val InvalidUnacceptableCashDistribAgentAcctNum=18
  val Other=99
  lazy val fixDescriptionByValue = Map(1->"INVALID_UNACCEPTABLE_ACCOUNT_TYPE",2->"INVALID_UNACCEPTABLE_TAX_EXEMPT_TYPE",
    3->"INVALID_UNACCEPTABLE_OWNERSHIP_TYPE",4->"INVALID_UNACCEPTABLE_NO_REG_DETLS",5->"INVALID_UNACCEPTABLE_REG_SEQ_NO",
    6->"INVALID_UNACCEPTABLE_REG_DTLS",7->"INVALID_UNACCEPTABLE_MAILING_DTLS",8->"INVALID_UNACCEPTABLE_MAILING_INST",
    9->"INVALID_UNACCEPTABLE_INVESTOR_ID",10->"INVALID_UNACCEPTABLE_INVESTOR_ID_SOURCE",11->"INVALID_UNACCEPTABLE_DATE_OF_BIRTH",
    12->"INVALID_UNACCEPTABLE_INVESTOR_COUNTRY_OF_RESIDENCE",13->"INVALID_UNACCEPTABLE_NODISTRIBINSTNS",14->"INVALID_UNACCEPTABLE_DISTRIB_PERCENTAGE",
    15->"INVALID_UNACCEPTABLE_DISTRIB_PAYMENT_METHOD",16->"INVALID_UNACCEPTABLE_CASH_DISTRIB_AGENT_ACCT_NAME",17->"INVALID_UNACCEPTABLE_CASH_DISTRIB_AGENT_CODE",
    18->"INVALID_UNACCEPTABLE_CASH_DISTRIB_AGENT_ACCT_NUM",99->"OTHER")
 
  def apply(value: String) = try {
    new RegistRejReasonCodeField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new RegistRejReasonCode("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[RegistRejReasonCodeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[RegistRejReasonCodeField]
  }

  def decode(a: Any) : Option[RegistRejReasonCodeField] = a match {
    case v: String => Some(RegistRejReasonCodeField(v))
    case v: Int => Some(RegistRejReasonCodeField(v))
    case v: RegistRejReasonCodeField => Some(v)
    case _ => scala.Option.empty[RegistRejReasonCodeField]
  } 
}
