package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20210314
  */
case class SecurityTradingEventField(override val value: Int) extends SfFieldInt(1174, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(1174)SecurityTradingEvent=(").append(value).append(")").append(SecurityTradingEventField.fixDescriptionByValue.getOrElse(value,""))
}

object SecurityTradingEventField {
  val TagId = 1174 
  val OrderImbalanceAuctionIsExtended=1
  val TradingResumes=2
  val PriceVolatilityInterruption=3
  val ChangeOfTradingSession=4
  val ChangeOfTradingSubsession=5
  val ChangeOfSecurityStatus=6
  val ChangeOfBookType=7
  val ChangeOfMarketDepth=8
  lazy val fixDescriptionByValue = Map(1->"ORDER_IMBALANCE_AUCTION_IS_EXTENDED",2->"TRADING_RESUMES",
    3->"PRICE_VOLATILITY_INTERRUPTION",4->"CHANGE_OF_TRADING_SESSION",5->"CHANGE_OF_TRADING_SUBSESSION",
    6->"CHANGE_OF_SECURITY_STATUS",7->"CHANGE_OF_BOOK_TYPE",8->"CHANGE_OF_MARKET_DEPTH")
 
  def apply(value: String) = try {
    new SecurityTradingEventField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new SecurityTradingEvent("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[SecurityTradingEventField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[SecurityTradingEventField]
  }

  def decode(a: Any) : Option[SecurityTradingEventField] = a match {
    case v: String => Some(SecurityTradingEventField(v))
    case v: Int => Some(SecurityTradingEventField(v))
    case v: SecurityTradingEventField => Some(v)
    case _ => scala.Option.empty[SecurityTradingEventField]
  } 
}
