package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldString

/**
  * Generated by SackFix code generator on 20210314
  */
case class SecurityTypeField(override val value: String) extends SfFieldString(167, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(167)SecurityType=(").append(value).append(")").append(SecurityTypeField.fixDescriptionByValue.getOrElse(value,""))
}

object SecurityTypeField {
  val TagId = 167 
  val Wildcard="?"
  val AssetBackedSecurities="ABS"
  val AmendedAndRestated="AMENDED"
  val OtherAnticipationNotes="AN"
  val BankersAcceptance="BA"
  val BankNotes="BN"
  val BillOfExchanges="BOX"
  val BradyBond="BRADY"
  val BridgeLoan="BRIDGE"
  val BuySellback="BUYSELL"
  val ConvertibleBond="CB"
  val CertificateOfDeposit="CD"
  val CallLoans="CL"
  val CorpMortgageBackedSecurities="CMBS"
  val CollateralizedMortgageObligation="CMO"
  val CertificateOfObligation="COFO"
  val CertificateOfParticipation="COFP"
  val CorporateBond="CORP"
  val CommercialPaper="CP"
  val CorporatePrivatePlacement="CPP"
  val CommonStock="CS"
  val Defaulted="DEFLTED"
  val DebtorInPossession="DINP"
  val DepositNotes="DN"
  val DualCurrency="DUAL"
  val EuroCertificateOfDeposit="EUCD"
  val EuroCorporateBond="EUCORP"
  val EuroCommercialPaper="EUCP"
  val EuroSovereigns="EUSOV"
  val EuroSupranationalCoupons="EUSUPRA"
  val FederalAgencyCoupon="FAC"
  val FederalAgencyDiscountNote="FADN"
  val ForeignExchangeContract="FOR"
  val Forward="FORWARD"
  val Future="FUT"
  val GeneralObligationBonds="GO"
  val IoetteMortgage="IET"
  val LetterOfCredit="LOFC"
  val LiquidityNote="LQN"
  val Matured="MATURED"
  val MortgageBackedSecurities="MBS"
  val MutualFund="MF"
  val MortgageInterestOnly="MIO"
  val MultiLegInstrument="MLEG"
  val MortgagePrincipalOnly="MPO"
  val MortgagePrivatePlacement="MPP"
  val MiscellaneousPassThrough="MPT"
  val MandatoryTender="MT"
  val MediumTermNotes="MTN"
  val NoSecurityType="NONE"
  val Overnight="ONITE"
  val Option="OPT"
  val PrivateExportFunding="PEF"
  val Pfandbriefe="PFAND"
  val PromissoryNote="PN"
  val PreferredStock="PS"
  val PlazosFijos="PZFJ"
  val RevenueAnticipationNote="RAN"
  val Replaced="REPLACD"
  val Repurchase="REPO"
  val Retired="RETIRED"
  val RevenueBonds="REV"
  val RevolverLoan="RVLV"
  val RevolverTermLoan="RVLVTRM"
  val SecuritiesLoan="SECLOAN"
  val SecuritiesPledge="SECPLEDGE"
  val SpecialAssessment="SPCLA"
  val SpecialObligation="SPCLO"
  val SpecialTax="SPCLT"
  val ShortTermLoanNote="STN"
  val StructuredNotes="STRUCT"
  val UsdSupranationalCoupons="SUPRA"
  val SwingLineFacility="SWING"
  val TaxAnticipationNote="TAN"
  val TaxAllocation="TAXA"
  val ToBeAnnounced="TBA"
  val UsTreasuryBill="TBILL"
  val UsTreasuryBond="TBOND"
  val PrincipalStripOfACallableBondOrNote="TCAL"
  val TimeDeposit="TD"
  val TaxExemptCommercialPaper="TECP"
  val TermLoan="TERM"
  val InterestStripFromAnyBondOrNote="TINT"
  val TreasuryInflationProtectedSecurities="TIPS"
  val UsTreasuryNote="TNOTE"
  val PrincipalStripFromANonCallableBondOrNote="TPRN"
  val TaxAndRevenueAnticipationNote="TRAN"
  val UsTreasuryNote2="UST"
  val UsTreasuryBill2="USTB"
  val VariableRateDemandNote="VRDN"
  val Warrant="WAR"
  val Withdrawn="WITHDRN"
  val _Unknown="WLD"
  val ExtendedCommNote="XCN"
  val IndexedLinked="XLINKD"
  val YankeeCorporateBond="YANK"
  val YankeeCertificateOfDeposit="YCD"
  val OptionsOnPhysical="OOP"
  val OptionsOnFutures="OOF"
  val Cash="CASH"
  lazy val fixDescriptionByValue = Map("?"->"WILDCARD","ABS"->"ASSET_BACKED_SECURITIES",
    "AMENDED"->"AMENDED_AND_RESTATED","AN"->"OTHER_ANTICIPATION_NOTES","BA"->"BANKERS_ACCEPTANCE",
    "BN"->"BANK_NOTES","BOX"->"BILL_OF_EXCHANGES","BRADY"->"BRADY_BOND",
    "BRIDGE"->"BRIDGE_LOAN","BUYSELL"->"BUY_SELLBACK","CB"->"CONVERTIBLE_BOND",
    "CD"->"CERTIFICATE_OF_DEPOSIT","CL"->"CALL_LOANS","CMBS"->"CORP_MORTGAGE_BACKED_SECURITIES",
    "CMO"->"COLLATERALIZED_MORTGAGE_OBLIGATION","COFO"->"CERTIFICATE_OF_OBLIGATION","COFP"->"CERTIFICATE_OF_PARTICIPATION",
    "CORP"->"CORPORATE_BOND","CP"->"COMMERCIAL_PAPER","CPP"->"CORPORATE_PRIVATE_PLACEMENT",
    "CS"->"COMMON_STOCK","DEFLTED"->"DEFAULTED","DINP"->"DEBTOR_IN_POSSESSION",
    "DN"->"DEPOSIT_NOTES","DUAL"->"DUAL_CURRENCY","EUCD"->"EURO_CERTIFICATE_OF_DEPOSIT",
    "EUCORP"->"EURO_CORPORATE_BOND","EUCP"->"EURO_COMMERCIAL_PAPER","EUSOV"->"EURO_SOVEREIGNS",
    "EUSUPRA"->"EURO_SUPRANATIONAL_COUPONS","FAC"->"FEDERAL_AGENCY_COUPON","FADN"->"FEDERAL_AGENCY_DISCOUNT_NOTE",
    "FOR"->"FOREIGN_EXCHANGE_CONTRACT","FORWARD"->"FORWARD","FUT"->"FUTURE",
    "GO"->"GENERAL_OBLIGATION_BONDS","IET"->"IOETTE_MORTGAGE","LOFC"->"LETTER_OF_CREDIT",
    "LQN"->"LIQUIDITY_NOTE","MATURED"->"MATURED","MBS"->"MORTGAGE_BACKED_SECURITIES",
    "MF"->"MUTUAL_FUND","MIO"->"MORTGAGE_INTEREST_ONLY","MLEG"->"MULTI_LEG_INSTRUMENT",
    "MPO"->"MORTGAGE_PRINCIPAL_ONLY","MPP"->"MORTGAGE_PRIVATE_PLACEMENT","MPT"->"MISCELLANEOUS_PASS_THROUGH",
    "MT"->"MANDATORY_TENDER","MTN"->"MEDIUM_TERM_NOTES","NONE"->"NO_SECURITY_TYPE",
    "ONITE"->"OVERNIGHT","OPT"->"OPTION","PEF"->"PRIVATE_EXPORT_FUNDING",
    "PFAND"->"PFANDBRIEFE","PN"->"PROMISSORY_NOTE","PS"->"PREFERRED_STOCK",
    "PZFJ"->"PLAZOS_FIJOS","RAN"->"REVENUE_ANTICIPATION_NOTE","REPLACD"->"REPLACED",
    "REPO"->"REPURCHASE","RETIRED"->"RETIRED","REV"->"REVENUE_BONDS",
    "RVLV"->"REVOLVER_LOAN","RVLVTRM"->"REVOLVER_TERM_LOAN","SECLOAN"->"SECURITIES_LOAN",
    "SECPLEDGE"->"SECURITIES_PLEDGE","SPCLA"->"SPECIAL_ASSESSMENT","SPCLO"->"SPECIAL_OBLIGATION",
    "SPCLT"->"SPECIAL_TAX","STN"->"SHORT_TERM_LOAN_NOTE","STRUCT"->"STRUCTURED_NOTES",
    "SUPRA"->"USD_SUPRANATIONAL_COUPONS","SWING"->"SWING_LINE_FACILITY","TAN"->"TAX_ANTICIPATION_NOTE",
    "TAXA"->"TAX_ALLOCATION","TBA"->"TO_BE_ANNOUNCED","TBILL"->"US_TREASURY_BILL",
    "TBOND"->"US_TREASURY_BOND","TCAL"->"PRINCIPAL_STRIP_OF_A_CALLABLE_BOND_OR_NOTE","TD"->"TIME_DEPOSIT",
    "TECP"->"TAX_EXEMPT_COMMERCIAL_PAPER","TERM"->"TERM_LOAN","TINT"->"INTEREST_STRIP_FROM_ANY_BOND_OR_NOTE",
    "TIPS"->"TREASURY_INFLATION_PROTECTED_SECURITIES","TNOTE"->"US_TREASURY_NOTE","TPRN"->"PRINCIPAL_STRIP_FROM_A_NON_CALLABLE_BOND_OR_NOTE",
    "TRAN"->"TAX_AND_REVENUE_ANTICIPATION_NOTE","UST"->"US_TREASURY_NOTE2","USTB"->"US_TREASURY_BILL2",
    "VRDN"->"VARIABLE_RATE_DEMAND_NOTE","WAR"->"WARRANT","WITHDRN"->"WITHDRAWN",
    "WLD"->"_UNKNOWN","XCN"->"EXTENDED_COMM_NOTE","XLINKD"->"INDEXED_LINKED",
    "YANK"->"YANKEE_CORPORATE_BOND","YCD"->"YANKEE_CERTIFICATE_OF_DEPOSIT","OOP"->"OPTIONS_ON_PHYSICAL",
    "OOF"->"OPTIONS_ON_FUTURES","CASH"->"CASH")
 
  def decode(a: Option[Any]) : Option[SecurityTypeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[SecurityTypeField]
  }

  def decode(a: Any) : Option[SecurityTypeField] = a match {
    case v: String => Some(SecurityTypeField(v))
    case v: SecurityTypeField => Some(v)
    case _ => scala.Option.empty[SecurityTypeField]
  } 
}
