package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldInt

/**
  * Generated by SackFix code generator on 20210314
  */
case class TradeAllocIndicatorField(override val value: Int) extends SfFieldInt(826, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(826)TradeAllocIndicator=(").append(value).append(")").append(TradeAllocIndicatorField.fixDescriptionByValue.getOrElse(value,""))
}

object TradeAllocIndicatorField {
  val TagId = 826 
  val AllocationNotRequired=0
  val AllocationRequired=1
  val UseAllocationProvidedWithTheTrade=2
  val AllocationGiveUpExecutor=3
  val AllocationFromExecutor=4
  val AllocationToClaimAccount=5
  lazy val fixDescriptionByValue = Map(0->"ALLOCATION_NOT_REQUIRED",1->"ALLOCATION_REQUIRED",
    2->"USE_ALLOCATION_PROVIDED_WITH_THE_TRADE",3->"ALLOCATION_GIVE_UP_EXECUTOR",4->"ALLOCATION_FROM_EXECUTOR",
    5->"ALLOCATION_TO_CLAIM_ACCOUNT")
 
  def apply(value: String) = try {
    new TradeAllocIndicatorField(value.toInt)
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new TradeAllocIndicator("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[TradeAllocIndicatorField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[TradeAllocIndicatorField]
  }

  def decode(a: Any) : Option[TradeAllocIndicatorField] = a match {
    case v: String => Some(TradeAllocIndicatorField(v))
    case v: Int => Some(TradeAllocIndicatorField(v))
    case v: TradeAllocIndicatorField => Some(v)
    case _ => scala.Option.empty[TradeAllocIndicatorField]
  } 
}
