package org.sackfix.field

import org.sackfix.common.validated.fields.SfFieldUtcTimeStamp
import java.time.LocalDateTime
import org.sackfix.common.validated.fields.SfFixDateFormats

/**
  * Generated by SackFix code generator on 20210314
  */
case class ValidUntilTimeField(override val value: LocalDateTime) extends SfFieldUtcTimeStamp(62, value) {
  override def toString = appendStringBuilder().toString
  override def appendStringBuilder(b:StringBuilder = new StringBuilder()) = b.append("(62)ValidUntilTime=(").append(value).append(")")
}

object ValidUntilTimeField {
  val TagId = 62  
  def apply(value: String) = try {
    new ValidUntilTimeField(LocalDateTime.from(SfFixDateFormats.utcTimeStamp.parse(value)))
  } catch {
    case ex: Exception => throw new IllegalArgumentException("new ValidUntilTime("+value.toString+") failed with exception", ex)
  } 
  def decode(a: Option[Any]) : Option[ValidUntilTimeField] = a match {
    case Some(v) => decode(v)
    case _ =>  scala.Option.empty[ValidUntilTimeField]
  }

  def decode(a: Any) : Option[ValidUntilTimeField] = a match {
    case v: String => Some(ValidUntilTimeField(v))
    case v: LocalDateTime => Some(ValidUntilTimeField(v))
    case v: ValidUntilTimeField => Some(v)
    case _ => scala.Option.empty[ValidUntilTimeField]
  } 
}
