package org.sackfix.fix40

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX40.xml
  */
case class AdvertisementMessage(advIdIntField:AdvIdIntField,
                                advTransTypeField:AdvTransTypeField,
                                advRefIDIntField:Option[AdvRefIDIntField]=None,
                                symbolField:SymbolField,
                                symbolSfxField:Option[SymbolSfxField]=None,
                                securityIDField:Option[SecurityIDField]=None,
                                iDSourceField:Option[IDSourceField]=None,
                                issuerField:Option[IssuerField]=None,
                                securityDescField:Option[SecurityDescField]=None,
                                advSideField:AdvSideField,
                                sharesIntField:SharesIntField,
                                priceField:Option[PriceField]=None,
                                currencyField:Option[CurrencyField]=None,
                                transactTimeField:Option[TransactTimeField]=None,
                                textField:Option[TextField]=None) extends SfFixMessageBody("7")  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,advIdIntField)
    fmt(b,advTransTypeField)
    advRefIDIntField.foreach(fmt(b,_))
    fmt(b,symbolField)
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    fmt(b,advSideField)
    fmt(b,sharesIntField)
    priceField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    transactTimeField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    b
  }

}
     
object AdvertisementMessage extends SfFixMessageDecoder {
  val MsgType="7"
  val MsgName="Advertisement"
             
  override val MandatoryFields = HashSet[Int](
    AdvIdIntField.TagId, AdvTransTypeField.TagId, SymbolField.TagId, AdvSideField.TagId, SharesIntField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId) 
  }

  override val OptionalFields = HashSet[Int](
    AdvRefIDIntField.TagId, SymbolSfxField.TagId, SecurityIDField.TagId, IDSourceField.TagId, IssuerField.TagId, 
    SecurityDescField.TagId, PriceField.TagId, CurrencyField.TagId, TransactTimeField.TagId, TextField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId) 
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId) 

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==AdvIdIntField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(AdvertisementMessage(AdvIdIntField.decode(myFields.get(AdvIdIntField.TagId)).get,
        AdvTransTypeField.decode(myFields.get(AdvTransTypeField.TagId)).get,
        myFields.get(AdvRefIDIntField.TagId).flatMap(f=>AdvRefIDIntField.decode(f)),
        SymbolField.decode(myFields.get(SymbolField.TagId)).get,
        myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
        myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
        myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
        myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
        myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)),
        AdvSideField.decode(myFields.get(AdvSideField.TagId)).get,
        SharesIntField.decode(myFields.get(SharesIntField.TagId)).get,
        myFields.get(PriceField.TagId).flatMap(f=>PriceField.decode(f)),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(TransactTimeField.TagId).flatMap(f=>TransactTimeField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f))))
    } else None
  }

    
}
     