package org.sackfix.fix40

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX40.xml
  */
case class ExecutionReportMessage(orderIDField:OrderIDField,
                                  clOrdIDField:Option[ClOrdIDField]=None,
                                  clientIDField:Option[ClientIDField]=None,
                                  execBrokerField:Option[ExecBrokerField]=None,
                                  listIDField:Option[ListIDField]=None,
                                  execIDIntField:ExecIDIntField,
                                  execTransTypeField:ExecTransTypeField,
                                  execRefIDIntField:Option[ExecRefIDIntField]=None,
                                  ordStatusField:OrdStatusField,
                                  ordRejReasonField:Option[OrdRejReasonField]=None,
                                  accountField:Option[AccountField]=None,
                                  settlmntTypField:Option[SettlmntTypField]=None,
                                  futSettDateField:Option[FutSettDateField]=None,
                                  symbolField:SymbolField,
                                  symbolSfxField:Option[SymbolSfxField]=None,
                                  securityIDField:Option[SecurityIDField]=None,
                                  iDSourceField:Option[IDSourceField]=None,
                                  issuerField:Option[IssuerField]=None,
                                  securityDescField:Option[SecurityDescField]=None,
                                  sideField:SideField,
                                  orderQtyIntField:OrderQtyIntField,
                                  ordTypeField:Option[OrdTypeField]=None,
                                  priceField:Option[PriceField]=None,
                                  stopPxField:Option[StopPxField]=None,
                                  currencyField:Option[CurrencyField]=None,
                                  timeInForceField:Option[TimeInForceField]=None,
                                  expireTimeField:Option[ExpireTimeField]=None,
                                  execInstField:Option[ExecInstField]=None,
                                  rule80AField:Option[Rule80AField]=None,
                                  lastSharesIntField:LastSharesIntField,
                                  lastPxField:LastPxField,
                                  lastMktField:Option[LastMktField]=None,
                                  lastCapacityField:Option[LastCapacityField]=None,
                                  cumQtyIntField:CumQtyIntField,
                                  avgPxField:AvgPxField,
                                  tradeDateField:Option[TradeDateField]=None,
                                  transactTimeField:Option[TransactTimeField]=None,
                                  reportToExchStringField:Option[ReportToExchStringField]=None,
                                  commissionField:Option[CommissionField]=None,
                                  commTypeField:Option[CommTypeField]=None,
                                  noMiscFeesField:Option[NoMiscFeesField]=None,
                                  miscFeesGroups: Option[List[MiscFeesGroup]]=None,
                                  netMoneyField:Option[NetMoneyField]=None,
                                  settlCurrAmtField:Option[SettlCurrAmtField]=None,
                                  settlCurrencyField:Option[SettlCurrencyField]=None,
                                  textField:Option[TextField]=None) extends SfFixMessageBody("8")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noMiscFeesField.map(_.value).getOrElse(0) != miscFeesGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoMiscFeesField.TagId,noMiscFeesField.map(_.value).getOrElse(0), miscFeesGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,orderIDField)
    clOrdIDField.foreach(fmt(b,_))
    clientIDField.foreach(fmt(b,_))
    execBrokerField.foreach(fmt(b,_))
    listIDField.foreach(fmt(b,_))
    fmt(b,execIDIntField)
    fmt(b,execTransTypeField)
    execRefIDIntField.foreach(fmt(b,_))
    fmt(b,ordStatusField)
    ordRejReasonField.foreach(fmt(b,_))
    accountField.foreach(fmt(b,_))
    settlmntTypField.foreach(fmt(b,_))
    futSettDateField.foreach(fmt(b,_))
    fmt(b,symbolField)
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    fmt(b,sideField)
    fmt(b,orderQtyIntField)
    ordTypeField.foreach(fmt(b,_))
    priceField.foreach(fmt(b,_))
    stopPxField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    timeInForceField.foreach(fmt(b,_))
    expireTimeField.foreach(fmt(b,_))
    execInstField.foreach(fmt(b,_))
    rule80AField.foreach(fmt(b,_))
    fmt(b,lastSharesIntField)
    fmt(b,lastPxField)
    lastMktField.foreach(fmt(b,_))
    lastCapacityField.foreach(fmt(b,_))
    fmt(b,cumQtyIntField)
    fmt(b,avgPxField)
    tradeDateField.foreach(fmt(b,_))
    transactTimeField.foreach(fmt(b,_))
    reportToExchStringField.foreach(fmt(b,_))
    commissionField.foreach(fmt(b,_))
    commTypeField.foreach(fmt(b,_))
    noMiscFeesField.foreach(fmt(b,_))
    miscFeesGroups.getOrElse(List.empty).foreach(fmt(b,_))
    netMoneyField.foreach(fmt(b,_))
    settlCurrAmtField.foreach(fmt(b,_))
    settlCurrencyField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    b
  }

}
     
object ExecutionReportMessage extends SfFixMessageDecoder {
  val MsgType="8"
  val MsgName="ExecutionReport"
             
  override val MandatoryFields = HashSet[Int](
    OrderIDField.TagId, ExecIDIntField.TagId, ExecTransTypeField.TagId, OrdStatusField.TagId, SymbolField.TagId, 
    SideField.TagId, OrderQtyIntField.TagId, LastSharesIntField.TagId, LastPxField.TagId, CumQtyIntField.TagId, 
    AvgPxField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    MiscFeesGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    ClOrdIDField.TagId, ClientIDField.TagId, ExecBrokerField.TagId, ListIDField.TagId, ExecRefIDIntField.TagId, 
    OrdRejReasonField.TagId, AccountField.TagId, SettlmntTypField.TagId, FutSettDateField.TagId, SymbolSfxField.TagId, 
    SecurityIDField.TagId, IDSourceField.TagId, IssuerField.TagId, SecurityDescField.TagId, OrdTypeField.TagId, 
    PriceField.TagId, StopPxField.TagId, CurrencyField.TagId, TimeInForceField.TagId, ExpireTimeField.TagId, 
    ExecInstField.TagId, Rule80AField.TagId, LastMktField.TagId, LastCapacityField.TagId, TradeDateField.TagId, 
    TransactTimeField.TagId, ReportToExchStringField.TagId, CommissionField.TagId, CommTypeField.TagId, NoMiscFeesField.TagId, 
    NetMoneyField.TagId, SettlCurrAmtField.TagId, SettlCurrencyField.TagId, TextField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    MiscFeesGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    MiscFeesGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoMiscFeesField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==OrderIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(ExecutionReportMessage(OrderIDField.decode(myFields.get(OrderIDField.TagId)).get,
        myFields.get(ClOrdIDField.TagId).flatMap(f=>ClOrdIDField.decode(f)),
        myFields.get(ClientIDField.TagId).flatMap(f=>ClientIDField.decode(f)),
        myFields.get(ExecBrokerField.TagId).flatMap(f=>ExecBrokerField.decode(f)),
        myFields.get(ListIDField.TagId).flatMap(f=>ListIDField.decode(f)),
        ExecIDIntField.decode(myFields.get(ExecIDIntField.TagId)).get,
        ExecTransTypeField.decode(myFields.get(ExecTransTypeField.TagId)).get,
        myFields.get(ExecRefIDIntField.TagId).flatMap(f=>ExecRefIDIntField.decode(f)),
        OrdStatusField.decode(myFields.get(OrdStatusField.TagId)).get,
        myFields.get(OrdRejReasonField.TagId).flatMap(f=>OrdRejReasonField.decode(f)),
        myFields.get(AccountField.TagId).flatMap(f=>AccountField.decode(f)),
        myFields.get(SettlmntTypField.TagId).flatMap(f=>SettlmntTypField.decode(f)),
        myFields.get(FutSettDateField.TagId).flatMap(f=>FutSettDateField.decode(f)),
        SymbolField.decode(myFields.get(SymbolField.TagId)).get,
        myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
        myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
        myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
        myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
        myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)),
        SideField.decode(myFields.get(SideField.TagId)).get,
        OrderQtyIntField.decode(myFields.get(OrderQtyIntField.TagId)).get,
        myFields.get(OrdTypeField.TagId).flatMap(f=>OrdTypeField.decode(f)),
        myFields.get(PriceField.TagId).flatMap(f=>PriceField.decode(f)),
        myFields.get(StopPxField.TagId).flatMap(f=>StopPxField.decode(f)),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(TimeInForceField.TagId).flatMap(f=>TimeInForceField.decode(f)),
        myFields.get(ExpireTimeField.TagId).flatMap(f=>ExpireTimeField.decode(f)),
        myFields.get(ExecInstField.TagId).flatMap(f=>ExecInstField.decode(f)),
        myFields.get(Rule80AField.TagId).flatMap(f=>Rule80AField.decode(f)),
        LastSharesIntField.decode(myFields.get(LastSharesIntField.TagId)).get,
        LastPxField.decode(myFields.get(LastPxField.TagId)).get,
        myFields.get(LastMktField.TagId).flatMap(f=>LastMktField.decode(f)),
        myFields.get(LastCapacityField.TagId).flatMap(f=>LastCapacityField.decode(f)),
        CumQtyIntField.decode(myFields.get(CumQtyIntField.TagId)).get,
        AvgPxField.decode(myFields.get(AvgPxField.TagId)).get,
        myFields.get(TradeDateField.TagId).flatMap(f=>TradeDateField.decode(f)),
        myFields.get(TransactTimeField.TagId).flatMap(f=>TransactTimeField.decode(f)),
        myFields.get(ReportToExchStringField.TagId).flatMap(f=>ReportToExchStringField.decode(f)),
        myFields.get(CommissionField.TagId).flatMap(f=>CommissionField.decode(f)),
        myFields.get(CommTypeField.TagId).flatMap(f=>CommTypeField.decode(f)),
        myFields.get(NoMiscFeesField.TagId).flatMap(f=>NoMiscFeesField.decode(f)),
        if (nextTagPosLookup.contains(NoMiscFeesField.TagId)) MiscFeesGroup.decode(flds, nextTagPosLookup(NoMiscFeesField.TagId)) else None,
        myFields.get(NetMoneyField.TagId).flatMap(f=>NetMoneyField.decode(f)),
        myFields.get(SettlCurrAmtField.TagId).flatMap(f=>SettlCurrAmtField.decode(f)),
        myFields.get(SettlCurrencyField.TagId).flatMap(f=>SettlCurrencyField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f))))
    } else None
  }

    
}
     