package org.sackfix.fix40

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX40.xml
  */
case class QuoteMessage(quoteReqIDField:Option[QuoteReqIDField]=None,
                        quoteIDField:QuoteIDField,
                        symbolField:SymbolField,
                        symbolSfxField:Option[SymbolSfxField]=None,
                        securityIDField:Option[SecurityIDField]=None,
                        iDSourceField:Option[IDSourceField]=None,
                        issuerField:Option[IssuerField]=None,
                        securityDescField:Option[SecurityDescField]=None,
                        bidPxField:BidPxField,
                        offerPxField:Option[OfferPxField]=None,
                        bidSizeIntField:Option[BidSizeIntField]=None,
                        offerSizeIntField:Option[OfferSizeIntField]=None,
                        validUntilTimeField:Option[ValidUntilTimeField]=None) extends SfFixMessageBody("S")  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    quoteReqIDField.foreach(fmt(b,_))
    fmt(b,quoteIDField)
    fmt(b,symbolField)
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    fmt(b,bidPxField)
    offerPxField.foreach(fmt(b,_))
    bidSizeIntField.foreach(fmt(b,_))
    offerSizeIntField.foreach(fmt(b,_))
    validUntilTimeField.foreach(fmt(b,_))
    b
  }

}
     
object QuoteMessage extends SfFixMessageDecoder {
  val MsgType="S"
  val MsgName="Quote"
             
  override val MandatoryFields = HashSet[Int](
    QuoteIDField.TagId, SymbolField.TagId, BidPxField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId) 
  }

  override val OptionalFields = HashSet[Int](
    QuoteReqIDField.TagId, SymbolSfxField.TagId, SecurityIDField.TagId, IDSourceField.TagId, IssuerField.TagId, 
    SecurityDescField.TagId, OfferPxField.TagId, BidSizeIntField.TagId, OfferSizeIntField.TagId, ValidUntilTimeField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId) 
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId) 

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==QuoteReqIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(QuoteMessage(myFields.get(QuoteReqIDField.TagId).flatMap(f=>QuoteReqIDField.decode(f)),
        QuoteIDField.decode(myFields.get(QuoteIDField.TagId)).get,
        SymbolField.decode(myFields.get(SymbolField.TagId)).get,
        myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
        myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
        myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
        myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
        myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)),
        BidPxField.decode(myFields.get(BidPxField.TagId)).get,
        myFields.get(OfferPxField.TagId).flatMap(f=>OfferPxField.decode(f)),
        myFields.get(BidSizeIntField.TagId).flatMap(f=>BidSizeIntField.decode(f)),
        myFields.get(OfferSizeIntField.TagId).flatMap(f=>OfferSizeIntField.decode(f)),
        myFields.get(ValidUntilTimeField.TagId).flatMap(f=>ValidUntilTimeField.decode(f))))
    } else None
  }

    
}
     