package org.sackfix.fix40

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX40.xml
  */
case class AllocationMessage(allocIDIntField:AllocIDIntField,
                             allocTransTypeField:AllocTransTypeField,
                             refAllocIDIntField:Option[RefAllocIDIntField]=None,
                             noOrdersField:NoOrdersField,
                             ordersGroups: List[OrdersGroup],
                             noExecsField:Option[NoExecsField]=None,
                             execsGroups: Option[List[ExecsGroup]]=None,
                             sideField:SideField,
                             symbolField:SymbolField,
                             symbolSfxField:Option[SymbolSfxField]=None,
                             securityIDField:Option[SecurityIDField]=None,
                             iDSourceField:Option[IDSourceField]=None,
                             issuerField:Option[IssuerField]=None,
                             securityDescField:Option[SecurityDescField]=None,
                             sharesField:SharesField,
                             avgPxField:AvgPxField,
                             currencyField:Option[CurrencyField]=None,
                             avgPrxPrecisionField:Option[AvgPrxPrecisionField]=None,
                             tradeDateField:TradeDateField,
                             transactTimeField:Option[TransactTimeField]=None,
                             settlmntTypField:Option[SettlmntTypField]=None,
                             futSettDateField:Option[FutSettDateField]=None,
                             netMoneyField:Option[NetMoneyField]=None,
                             noMiscFeesField:Option[NoMiscFeesField]=None,
                             miscFeesGroups: Option[List[MiscFeesGroup]]=None,
                             settlCurrAmtField:Option[SettlCurrAmtField]=None,
                             settlCurrencyField:Option[SettlCurrencyField]=None,
                             openCloseField:Option[OpenCloseField]=None,
                             textField:Option[TextField]=None,
                             noAllocsField:NoAllocsField,
                             allocsGroups: List[AllocsGroup]) extends SfFixMessageBody("J")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noOrdersField.value != ordersGroups.size)
    throw SfRepeatingGroupCountException(NoOrdersField.TagId,noOrdersField.value, ordersGroups.size)
  if (noExecsField.map(_.value).getOrElse(0) != execsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoExecsField.TagId,noExecsField.map(_.value).getOrElse(0), execsGroups.map(_.size).getOrElse(0))
  if (noMiscFeesField.map(_.value).getOrElse(0) != miscFeesGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoMiscFeesField.TagId,noMiscFeesField.map(_.value).getOrElse(0), miscFeesGroups.map(_.size).getOrElse(0))
  if (noAllocsField.value != allocsGroups.size)
    throw SfRepeatingGroupCountException(NoAllocsField.TagId,noAllocsField.value, allocsGroups.size)

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,allocIDIntField)
    fmt(b,allocTransTypeField)
    refAllocIDIntField.foreach(fmt(b,_))
    fmt(b,noOrdersField)
    noExecsField.foreach(fmt(b,_))
    execsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    fmt(b,sideField)
    fmt(b,symbolField)
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    fmt(b,sharesField)
    fmt(b,avgPxField)
    currencyField.foreach(fmt(b,_))
    avgPrxPrecisionField.foreach(fmt(b,_))
    fmt(b,tradeDateField)
    transactTimeField.foreach(fmt(b,_))
    settlmntTypField.foreach(fmt(b,_))
    futSettDateField.foreach(fmt(b,_))
    netMoneyField.foreach(fmt(b,_))
    noMiscFeesField.foreach(fmt(b,_))
    miscFeesGroups.getOrElse(List.empty).foreach(fmt(b,_))
    settlCurrAmtField.foreach(fmt(b,_))
    settlCurrencyField.foreach(fmt(b,_))
    openCloseField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    fmt(b,noAllocsField)
    b
  }

}
     
object AllocationMessage extends SfFixMessageDecoder {
  val MsgType="J"
  val MsgName="Allocation"
             
  override val MandatoryFields = HashSet[Int](
    AllocIDIntField.TagId, AllocTransTypeField.TagId, NoOrdersField.TagId, SideField.TagId, SymbolField.TagId, 
    SharesField.TagId, AvgPxField.TagId, TradeDateField.TagId, NoAllocsField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    OrdersGroup.isMandatoryField(tagId) || ExecsGroup.isMandatoryField(tagId) || MiscFeesGroup.isMandatoryField(tagId) || AllocsGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    RefAllocIDIntField.TagId, NoExecsField.TagId, SymbolSfxField.TagId, SecurityIDField.TagId, IDSourceField.TagId, 
    IssuerField.TagId, SecurityDescField.TagId, CurrencyField.TagId, AvgPrxPrecisionField.TagId, TransactTimeField.TagId, 
    SettlmntTypField.TagId, FutSettDateField.TagId, NetMoneyField.TagId, NoMiscFeesField.TagId, SettlCurrAmtField.TagId, 
    SettlCurrencyField.TagId, OpenCloseField.TagId, TextField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    OrdersGroup.isOptionalField(tagId) || ExecsGroup.isOptionalField(tagId) || MiscFeesGroup.isOptionalField(tagId) || AllocsGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    OrdersGroup.isFieldOf(tagId) || ExecsGroup.isFieldOf(tagId) || MiscFeesGroup.isFieldOf(tagId) || 
    AllocsGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoOrdersField.TagId, NoExecsField.TagId, NoMiscFeesField.TagId, NoAllocsField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==AllocIDIntField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(AllocationMessage(AllocIDIntField.decode(myFields.get(AllocIDIntField.TagId)).get,
        AllocTransTypeField.decode(myFields.get(AllocTransTypeField.TagId)).get,
        myFields.get(RefAllocIDIntField.TagId).flatMap(f=>RefAllocIDIntField.decode(f)),
        NoOrdersField.decode(myFields.get(NoOrdersField.TagId)).get,
        if (nextTagPosLookup.contains(NoOrdersField.TagId)) OrdersGroup.decode(flds, nextTagPosLookup(NoOrdersField.TagId)).get else List.empty,
        myFields.get(NoExecsField.TagId).flatMap(f=>NoExecsField.decode(f)),
        if (nextTagPosLookup.contains(NoExecsField.TagId)) ExecsGroup.decode(flds, nextTagPosLookup(NoExecsField.TagId)) else None,
        SideField.decode(myFields.get(SideField.TagId)).get,
        SymbolField.decode(myFields.get(SymbolField.TagId)).get,
        myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
        myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
        myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
        myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
        myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)),
        SharesField.decode(myFields.get(SharesField.TagId)).get,
        AvgPxField.decode(myFields.get(AvgPxField.TagId)).get,
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(AvgPrxPrecisionField.TagId).flatMap(f=>AvgPrxPrecisionField.decode(f)),
        TradeDateField.decode(myFields.get(TradeDateField.TagId)).get,
        myFields.get(TransactTimeField.TagId).flatMap(f=>TransactTimeField.decode(f)),
        myFields.get(SettlmntTypField.TagId).flatMap(f=>SettlmntTypField.decode(f)),
        myFields.get(FutSettDateField.TagId).flatMap(f=>FutSettDateField.decode(f)),
        myFields.get(NetMoneyField.TagId).flatMap(f=>NetMoneyField.decode(f)),
        myFields.get(NoMiscFeesField.TagId).flatMap(f=>NoMiscFeesField.decode(f)),
        if (nextTagPosLookup.contains(NoMiscFeesField.TagId)) MiscFeesGroup.decode(flds, nextTagPosLookup(NoMiscFeesField.TagId)) else None,
        myFields.get(SettlCurrAmtField.TagId).flatMap(f=>SettlCurrAmtField.decode(f)),
        myFields.get(SettlCurrencyField.TagId).flatMap(f=>SettlCurrencyField.decode(f)),
        myFields.get(OpenCloseField.TagId).flatMap(f=>OpenCloseField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        NoAllocsField.decode(myFields.get(NoAllocsField.TagId)).get,
        if (nextTagPosLookup.contains(NoAllocsField.TagId)) AllocsGroup.decode(flds, nextTagPosLookup(NoAllocsField.TagId)).get else List.empty))
    } else None
  }

    
}
     