package org.sackfix.fix40

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixGroup, SfGroupDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX40.xml
  */
case class AllocsGroup(allocAccountField:AllocAccountField,
                       allocSharesField:AllocSharesField,
                       processCodeField:Option[ProcessCodeField]=None,
                       execBrokerField:Option[ExecBrokerField]=None,
                       clientIDField:Option[ClientIDField]=None,
                       commissionField:Option[CommissionField]=None,
                       commTypeField:Option[CommTypeField]=None,
                       noDlvyInstField:Option[NoDlvyInstField]=None,
                       dlvyInstGroups: Option[List[DlvyInstGroup]]=None) extends SfFixGroup  with SfFixRenderable with SfFixFieldsToAscii {
  if (noDlvyInstField.map(_.value).getOrElse(0) != dlvyInstGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoDlvyInstField.TagId,noDlvyInstField.map(_.value).getOrElse(0), dlvyInstGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,allocAccountField)
    fmt(b,allocSharesField)
    processCodeField.foreach(fmt(b,_))
    execBrokerField.foreach(fmt(b,_))
    clientIDField.foreach(fmt(b,_))
    commissionField.foreach(fmt(b,_))
    commTypeField.foreach(fmt(b,_))
    noDlvyInstField.foreach(fmt(b,_))
    dlvyInstGroups.getOrElse(List.empty).foreach(fmt(b,_))
    b
  }

}
     
object AllocsGroup extends SfGroupDecoder {

  override val MandatoryFields = HashSet[Int](
    AllocAccountField.TagId, AllocSharesField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    DlvyInstGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    ProcessCodeField.TagId, ExecBrokerField.TagId, ClientIDField.TagId, CommissionField.TagId, CommTypeField.TagId, 
    NoDlvyInstField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    DlvyInstGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    DlvyInstGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoDlvyInstField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==AllocAccountField.TagId 

  // Group version, startPos is the index to the first element of the first repeating group
  @tailrec
  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0, groups:ArrayBuffer[AllocsGroup]=ArrayBuffer.empty[AllocsGroup]):Option[List[AllocsGroup]] = {
    decodeSingle(flds, startPos) match {
      case (pos: Int, None) => if (groups.nonEmpty) Some(groups.toList) else None
      case (pos: Int, grp: Some[AllocsGroup]) => decode(flds, pos, groups += grp.get)
    }
  }

  /**
    * @param flds For groups in Fix ordering is VITAL.
    * @param startPos This index into the ordered fields. It HAS to contain the first field of the group
    * @return A Tuple2 holding the next position to read from the fields, and the newly created group
    */
  def decodeSingle(flds: Seq[Tuple2[Int, Any]], startPos:Int):Tuple2[Int,Option[AllocsGroup]] = {
    if (!isFirstField(flds(startPos)._1)) (startPos, None)
    else {
      val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(true, flds, startPos)
      validateMandatoryFieldsPresent(myFields)

      if (myFields.nonEmpty) {
        (pos,Some(AllocsGroup(AllocAccountField.decode(myFields.get(AllocAccountField.TagId)).get,
          AllocSharesField.decode(myFields.get(AllocSharesField.TagId)).get,
          myFields.get(ProcessCodeField.TagId).flatMap(f=>ProcessCodeField.decode(f)),
          myFields.get(ExecBrokerField.TagId).flatMap(f=>ExecBrokerField.decode(f)),
          myFields.get(ClientIDField.TagId).flatMap(f=>ClientIDField.decode(f)),
          myFields.get(CommissionField.TagId).flatMap(f=>CommissionField.decode(f)),
          myFields.get(CommTypeField.TagId).flatMap(f=>CommTypeField.decode(f)),
          myFields.get(NoDlvyInstField.TagId).flatMap(f=>NoDlvyInstField.decode(f)),
          if (nextTagPosLookup.contains(NoDlvyInstField.TagId)) DlvyInstGroup.decode(flds, nextTagPosLookup(NoDlvyInstField.TagId)) else None)))
      } else (startPos, None)
    }
  }
    
}
     