package org.sackfix.fix41

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixGroup, SfGroupDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX41.xml
  */
case class AllocsGroup(allocAccountField:AllocAccountField,
                       allocSharesIntField:AllocSharesIntField,
                       processCodeField:Option[ProcessCodeField]=None,
                       brokerOfCreditField:Option[BrokerOfCreditField]=None,
                       notifyBrokerOfCreditStringField:Option[NotifyBrokerOfCreditStringField]=None,
                       allocHandlInstField:Option[AllocHandlInstField]=None,
                       allocTextField:Option[AllocTextField]=None,
                       execBrokerField:Option[ExecBrokerField]=None,
                       clientIDField:Option[ClientIDField]=None,
                       commissionField:Option[CommissionField]=None,
                       commTypeField:Option[CommTypeField]=None,
                       allocAvgPxField:Option[AllocAvgPxField]=None,
                       allocNetMoneyField:Option[AllocNetMoneyField]=None,
                       settlCurrAmtField:Option[SettlCurrAmtField]=None,
                       settlCurrencyField:Option[SettlCurrencyField]=None,
                       settlCurrFxRateField:Option[SettlCurrFxRateField]=None,
                       settlCurrFxRateCalcField:Option[SettlCurrFxRateCalcField]=None,
                       accruedInterestAmtField:Option[AccruedInterestAmtField]=None,
                       settlInstModeField:Option[SettlInstModeField]=None,
                       noMiscFeesField:Option[NoMiscFeesField]=None,
                       miscFeesGroups: Option[List[MiscFeesGroup]]=None) extends SfFixGroup  with SfFixRenderable with SfFixFieldsToAscii {
  if (noMiscFeesField.map(_.value).getOrElse(0) != miscFeesGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoMiscFeesField.TagId,noMiscFeesField.map(_.value).getOrElse(0), miscFeesGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,allocAccountField)
    fmt(b,allocSharesIntField)
    processCodeField.foreach(fmt(b,_))
    brokerOfCreditField.foreach(fmt(b,_))
    notifyBrokerOfCreditStringField.foreach(fmt(b,_))
    allocHandlInstField.foreach(fmt(b,_))
    allocTextField.foreach(fmt(b,_))
    execBrokerField.foreach(fmt(b,_))
    clientIDField.foreach(fmt(b,_))
    commissionField.foreach(fmt(b,_))
    commTypeField.foreach(fmt(b,_))
    allocAvgPxField.foreach(fmt(b,_))
    allocNetMoneyField.foreach(fmt(b,_))
    settlCurrAmtField.foreach(fmt(b,_))
    settlCurrencyField.foreach(fmt(b,_))
    settlCurrFxRateField.foreach(fmt(b,_))
    settlCurrFxRateCalcField.foreach(fmt(b,_))
    accruedInterestAmtField.foreach(fmt(b,_))
    settlInstModeField.foreach(fmt(b,_))
    noMiscFeesField.foreach(fmt(b,_))
    miscFeesGroups.getOrElse(List.empty).foreach(fmt(b,_))
    b
  }

}
     
object AllocsGroup extends SfGroupDecoder {

  override val MandatoryFields = HashSet[Int](
    AllocAccountField.TagId, AllocSharesIntField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    MiscFeesGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    ProcessCodeField.TagId, BrokerOfCreditField.TagId, NotifyBrokerOfCreditStringField.TagId, AllocHandlInstField.TagId, AllocTextField.TagId, 
    ExecBrokerField.TagId, ClientIDField.TagId, CommissionField.TagId, CommTypeField.TagId, AllocAvgPxField.TagId, 
    AllocNetMoneyField.TagId, SettlCurrAmtField.TagId, SettlCurrencyField.TagId, SettlCurrFxRateField.TagId, SettlCurrFxRateCalcField.TagId, 
    AccruedInterestAmtField.TagId, SettlInstModeField.TagId, NoMiscFeesField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    MiscFeesGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    MiscFeesGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoMiscFeesField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==AllocAccountField.TagId 

  // Group version, startPos is the index to the first element of the first repeating group
  @tailrec
  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0, groups:ArrayBuffer[AllocsGroup]=ArrayBuffer.empty[AllocsGroup]):Option[List[AllocsGroup]] = {
    decodeSingle(flds, startPos) match {
      case (pos: Int, None) => if (groups.nonEmpty) Some(groups.toList) else None
      case (pos: Int, grp: Some[AllocsGroup]) => decode(flds, pos, groups += grp.get)
    }
  }

  /**
    * @param flds For groups in Fix ordering is VITAL.
    * @param startPos This index into the ordered fields. It HAS to contain the first field of the group
    * @return A Tuple2 holding the next position to read from the fields, and the newly created group
    */
  def decodeSingle(flds: Seq[Tuple2[Int, Any]], startPos:Int):Tuple2[Int,Option[AllocsGroup]] = {
    if (!isFirstField(flds(startPos)._1)) (startPos, None)
    else {
      val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(true, flds, startPos)
      validateMandatoryFieldsPresent(myFields)

      if (myFields.nonEmpty) {
        (pos,Some(AllocsGroup(AllocAccountField.decode(myFields.get(AllocAccountField.TagId)).get,
          AllocSharesIntField.decode(myFields.get(AllocSharesIntField.TagId)).get,
          myFields.get(ProcessCodeField.TagId).flatMap(f=>ProcessCodeField.decode(f)),
          myFields.get(BrokerOfCreditField.TagId).flatMap(f=>BrokerOfCreditField.decode(f)),
          myFields.get(NotifyBrokerOfCreditStringField.TagId).flatMap(f=>NotifyBrokerOfCreditStringField.decode(f)),
          myFields.get(AllocHandlInstField.TagId).flatMap(f=>AllocHandlInstField.decode(f)),
          myFields.get(AllocTextField.TagId).flatMap(f=>AllocTextField.decode(f)),
          myFields.get(ExecBrokerField.TagId).flatMap(f=>ExecBrokerField.decode(f)),
          myFields.get(ClientIDField.TagId).flatMap(f=>ClientIDField.decode(f)),
          myFields.get(CommissionField.TagId).flatMap(f=>CommissionField.decode(f)),
          myFields.get(CommTypeField.TagId).flatMap(f=>CommTypeField.decode(f)),
          myFields.get(AllocAvgPxField.TagId).flatMap(f=>AllocAvgPxField.decode(f)),
          myFields.get(AllocNetMoneyField.TagId).flatMap(f=>AllocNetMoneyField.decode(f)),
          myFields.get(SettlCurrAmtField.TagId).flatMap(f=>SettlCurrAmtField.decode(f)),
          myFields.get(SettlCurrencyField.TagId).flatMap(f=>SettlCurrencyField.decode(f)),
          myFields.get(SettlCurrFxRateField.TagId).flatMap(f=>SettlCurrFxRateField.decode(f)),
          myFields.get(SettlCurrFxRateCalcField.TagId).flatMap(f=>SettlCurrFxRateCalcField.decode(f)),
          myFields.get(AccruedInterestAmtField.TagId).flatMap(f=>AccruedInterestAmtField.decode(f)),
          myFields.get(SettlInstModeField.TagId).flatMap(f=>SettlInstModeField.decode(f)),
          myFields.get(NoMiscFeesField.TagId).flatMap(f=>NoMiscFeesField.decode(f)),
          if (nextTagPosLookup.contains(NoMiscFeesField.TagId)) MiscFeesGroup.decode(flds, nextTagPosLookup(NoMiscFeesField.TagId)) else None)))
      } else (startPos, None)
    }
  }
    
}
     