package org.sackfix.fix41

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixGroup, SfGroupDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX41.xml
  */
case class RelatedSymGroup(relatdSymField:Option[RelatdSymField]=None,
                           symbolSfxField:Option[SymbolSfxField]=None,
                           securityIDField:Option[SecurityIDField]=None,
                           iDSourceField:Option[IDSourceField]=None,
                           securityTypeField:Option[SecurityTypeField]=None,
                           maturityMonthYearField:Option[MaturityMonthYearField]=None,
                           maturityDayField:Option[MaturityDayField]=None,
                           putOrCallField:Option[PutOrCallField]=None,
                           strikePriceField:Option[StrikePriceField]=None,
                           optAttributeField:Option[OptAttributeField]=None,
                           securityExchangeField:Option[SecurityExchangeField]=None,
                           issuerField:Option[IssuerField]=None,
                           securityDescField:Option[SecurityDescField]=None) extends SfFixGroup  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    relatdSymField.foreach(fmt(b,_))
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    securityTypeField.foreach(fmt(b,_))
    maturityMonthYearField.foreach(fmt(b,_))
    maturityDayField.foreach(fmt(b,_))
    putOrCallField.foreach(fmt(b,_))
    strikePriceField.foreach(fmt(b,_))
    optAttributeField.foreach(fmt(b,_))
    securityExchangeField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    b
  }

}
     
object RelatedSymGroup extends SfGroupDecoder {

  override val MandatoryFields = HashSet[Int]()

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId) 
  }

  override val OptionalFields = HashSet[Int](
    RelatdSymField.TagId, SymbolSfxField.TagId, SecurityIDField.TagId, IDSourceField.TagId, SecurityTypeField.TagId, 
    MaturityMonthYearField.TagId, MaturityDayField.TagId, PutOrCallField.TagId, StrikePriceField.TagId, OptAttributeField.TagId, 
    SecurityExchangeField.TagId, IssuerField.TagId, SecurityDescField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId) 
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId) 

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==RelatdSymField.TagId 

  // Group version, startPos is the index to the first element of the first repeating group
  @tailrec
  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0, groups:ArrayBuffer[RelatedSymGroup]=ArrayBuffer.empty[RelatedSymGroup]):Option[List[RelatedSymGroup]] = {
    decodeSingle(flds, startPos) match {
      case (pos: Int, None) => if (groups.nonEmpty) Some(groups.toList) else None
      case (pos: Int, grp: Some[RelatedSymGroup]) => decode(flds, pos, groups += grp.get)
    }
  }

  /**
    * @param flds For groups in Fix ordering is VITAL.
    * @param startPos This index into the ordered fields. It HAS to contain the first field of the group
    * @return A Tuple2 holding the next position to read from the fields, and the newly created group
    */
  def decodeSingle(flds: Seq[Tuple2[Int, Any]], startPos:Int):Tuple2[Int,Option[RelatedSymGroup]] = {
    if (!isFirstField(flds(startPos)._1)) (startPos, None)
    else {
      val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(true, flds, startPos)
      validateMandatoryFieldsPresent(myFields)

      if (myFields.nonEmpty) {
        (pos,Some(RelatedSymGroup(myFields.get(RelatdSymField.TagId).flatMap(f=>RelatdSymField.decode(f)),
          myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
          myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
          myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
          myFields.get(SecurityTypeField.TagId).flatMap(f=>SecurityTypeField.decode(f)),
          myFields.get(MaturityMonthYearField.TagId).flatMap(f=>MaturityMonthYearField.decode(f)),
          myFields.get(MaturityDayField.TagId).flatMap(f=>MaturityDayField.decode(f)),
          myFields.get(PutOrCallField.TagId).flatMap(f=>PutOrCallField.decode(f)),
          myFields.get(StrikePriceField.TagId).flatMap(f=>StrikePriceField.decode(f)),
          myFields.get(OptAttributeField.TagId).flatMap(f=>OptAttributeField.decode(f)),
          myFields.get(SecurityExchangeField.TagId).flatMap(f=>SecurityExchangeField.decode(f)),
          myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
          myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)))))
      } else (startPos, None)
    }
  }
    
}
     