package org.sackfix.fix41

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX41.xml
  */
case class AdvertisementMessage(advIdField:AdvIdField,
                                advTransTypeField:AdvTransTypeField,
                                advRefIDField:Option[AdvRefIDField]=None,
                                symbolField:SymbolField,
                                symbolSfxField:Option[SymbolSfxField]=None,
                                securityIDField:Option[SecurityIDField]=None,
                                iDSourceField:Option[IDSourceField]=None,
                                securityTypeField:Option[SecurityTypeField]=None,
                                maturityMonthYearField:Option[MaturityMonthYearField]=None,
                                maturityDayField:Option[MaturityDayField]=None,
                                putOrCallField:Option[PutOrCallField]=None,
                                strikePriceField:Option[StrikePriceField]=None,
                                optAttributeField:Option[OptAttributeField]=None,
                                securityExchangeField:Option[SecurityExchangeField]=None,
                                issuerField:Option[IssuerField]=None,
                                securityDescField:Option[SecurityDescField]=None,
                                advSideField:AdvSideField,
                                sharesField:SharesField,
                                priceField:Option[PriceField]=None,
                                currencyField:Option[CurrencyField]=None,
                                tradeDateField:Option[TradeDateField]=None,
                                transactTimeField:Option[TransactTimeField]=None,
                                textField:Option[TextField]=None,
                                uRLLinkField:Option[URLLinkField]=None,
                                lastMktField:Option[LastMktField]=None) extends SfFixMessageBody("7")  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,advIdField)
    fmt(b,advTransTypeField)
    advRefIDField.foreach(fmt(b,_))
    fmt(b,symbolField)
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    securityTypeField.foreach(fmt(b,_))
    maturityMonthYearField.foreach(fmt(b,_))
    maturityDayField.foreach(fmt(b,_))
    putOrCallField.foreach(fmt(b,_))
    strikePriceField.foreach(fmt(b,_))
    optAttributeField.foreach(fmt(b,_))
    securityExchangeField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    fmt(b,advSideField)
    fmt(b,sharesField)
    priceField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    tradeDateField.foreach(fmt(b,_))
    transactTimeField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    uRLLinkField.foreach(fmt(b,_))
    lastMktField.foreach(fmt(b,_))
    b
  }

}
     
object AdvertisementMessage extends SfFixMessageDecoder {
  val MsgType="7"
  val MsgName="Advertisement"
             
  override val MandatoryFields = HashSet[Int](
    AdvIdField.TagId, AdvTransTypeField.TagId, SymbolField.TagId, AdvSideField.TagId, SharesField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId) 
  }

  override val OptionalFields = HashSet[Int](
    AdvRefIDField.TagId, SymbolSfxField.TagId, SecurityIDField.TagId, IDSourceField.TagId, SecurityTypeField.TagId, 
    MaturityMonthYearField.TagId, MaturityDayField.TagId, PutOrCallField.TagId, StrikePriceField.TagId, OptAttributeField.TagId, 
    SecurityExchangeField.TagId, IssuerField.TagId, SecurityDescField.TagId, PriceField.TagId, CurrencyField.TagId, 
    TradeDateField.TagId, TransactTimeField.TagId, TextField.TagId, URLLinkField.TagId, LastMktField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId) 
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId) 

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==AdvIdField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(AdvertisementMessage(AdvIdField.decode(myFields.get(AdvIdField.TagId)).get,
        AdvTransTypeField.decode(myFields.get(AdvTransTypeField.TagId)).get,
        myFields.get(AdvRefIDField.TagId).flatMap(f=>AdvRefIDField.decode(f)),
        SymbolField.decode(myFields.get(SymbolField.TagId)).get,
        myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
        myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
        myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
        myFields.get(SecurityTypeField.TagId).flatMap(f=>SecurityTypeField.decode(f)),
        myFields.get(MaturityMonthYearField.TagId).flatMap(f=>MaturityMonthYearField.decode(f)),
        myFields.get(MaturityDayField.TagId).flatMap(f=>MaturityDayField.decode(f)),
        myFields.get(PutOrCallField.TagId).flatMap(f=>PutOrCallField.decode(f)),
        myFields.get(StrikePriceField.TagId).flatMap(f=>StrikePriceField.decode(f)),
        myFields.get(OptAttributeField.TagId).flatMap(f=>OptAttributeField.decode(f)),
        myFields.get(SecurityExchangeField.TagId).flatMap(f=>SecurityExchangeField.decode(f)),
        myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
        myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)),
        AdvSideField.decode(myFields.get(AdvSideField.TagId)).get,
        SharesField.decode(myFields.get(SharesField.TagId)).get,
        myFields.get(PriceField.TagId).flatMap(f=>PriceField.decode(f)),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(TradeDateField.TagId).flatMap(f=>TradeDateField.decode(f)),
        myFields.get(TransactTimeField.TagId).flatMap(f=>TransactTimeField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(URLLinkField.TagId).flatMap(f=>URLLinkField.decode(f)),
        myFields.get(LastMktField.TagId).flatMap(f=>LastMktField.decode(f))))
    } else None
  }

    
}
     