package org.sackfix.fix42

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX42.xml
  */
case class IndicationofInterestMessage(iOIIDField:IOIIDField,
                                       iOITransTypeField:IOITransTypeField,
                                       iOIRefIDField:Option[IOIRefIDField]=None,
                                       symbolField:SymbolField,
                                       symbolSfxField:Option[SymbolSfxField]=None,
                                       securityIDField:Option[SecurityIDField]=None,
                                       iDSourceField:Option[IDSourceField]=None,
                                       securityTypeField:Option[SecurityTypeField]=None,
                                       maturityMonthYearField:Option[MaturityMonthYearField]=None,
                                       maturityDayField:Option[MaturityDayField]=None,
                                       putOrCallField:Option[PutOrCallField]=None,
                                       strikePriceField:Option[StrikePriceField]=None,
                                       optAttributeField:Option[OptAttributeField]=None,
                                       contractMultiplierField:Option[ContractMultiplierField]=None,
                                       couponRateField:Option[CouponRateField]=None,
                                       securityExchangeField:Option[SecurityExchangeField]=None,
                                       issuerField:Option[IssuerField]=None,
                                       encodedIssuerLenField:Option[EncodedIssuerLenField]=None,
                                       encodedIssuerField:Option[EncodedIssuerField]=None,
                                       securityDescField:Option[SecurityDescField]=None,
                                       encodedSecurityDescLenField:Option[EncodedSecurityDescLenField]=None,
                                       encodedSecurityDescField:Option[EncodedSecurityDescField]=None,
                                       sideField:SideField,
                                       iOISharesField:IOISharesField,
                                       priceField:Option[PriceField]=None,
                                       currencyField:Option[CurrencyField]=None,
                                       validUntilTimeField:Option[ValidUntilTimeField]=None,
                                       iOIQltyIndField:Option[IOIQltyIndField]=None,
                                       iOINaturalFlagField:Option[IOINaturalFlagField]=None,
                                       noIOIQualifiersField:Option[NoIOIQualifiersField]=None,
                                       iOIQualifiersGroups: Option[List[IOIQualifiersGroup]]=None,
                                       textField:Option[TextField]=None,
                                       encodedTextLenField:Option[EncodedTextLenField]=None,
                                       encodedTextField:Option[EncodedTextField]=None,
                                       transactTimeField:Option[TransactTimeField]=None,
                                       uRLLinkField:Option[URLLinkField]=None,
                                       noRoutingIDsField:Option[NoRoutingIDsField]=None,
                                       routingIDsGroups: Option[List[RoutingIDsGroup]]=None,
                                       spreadToBenchmarkField:Option[SpreadToBenchmarkField]=None,
                                       benchmarkField:Option[BenchmarkField]=None) extends SfFixMessageBody("6")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noIOIQualifiersField.map(_.value).getOrElse(0) != iOIQualifiersGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoIOIQualifiersField.TagId,noIOIQualifiersField.map(_.value).getOrElse(0), iOIQualifiersGroups.map(_.size).getOrElse(0))
  if (noRoutingIDsField.map(_.value).getOrElse(0) != routingIDsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoRoutingIDsField.TagId,noRoutingIDsField.map(_.value).getOrElse(0), routingIDsGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,iOIIDField)
    fmt(b,iOITransTypeField)
    iOIRefIDField.foreach(fmt(b,_))
    fmt(b,symbolField)
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    securityTypeField.foreach(fmt(b,_))
    maturityMonthYearField.foreach(fmt(b,_))
    maturityDayField.foreach(fmt(b,_))
    putOrCallField.foreach(fmt(b,_))
    strikePriceField.foreach(fmt(b,_))
    optAttributeField.foreach(fmt(b,_))
    contractMultiplierField.foreach(fmt(b,_))
    couponRateField.foreach(fmt(b,_))
    securityExchangeField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    encodedIssuerLenField.foreach(fmt(b,_))
    encodedIssuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    encodedSecurityDescLenField.foreach(fmt(b,_))
    encodedSecurityDescField.foreach(fmt(b,_))
    fmt(b,sideField)
    fmt(b,iOISharesField)
    priceField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    validUntilTimeField.foreach(fmt(b,_))
    iOIQltyIndField.foreach(fmt(b,_))
    iOINaturalFlagField.foreach(fmt(b,_))
    noIOIQualifiersField.foreach(fmt(b,_))
    iOIQualifiersGroups.getOrElse(List.empty).foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    encodedTextLenField.foreach(fmt(b,_))
    encodedTextField.foreach(fmt(b,_))
    transactTimeField.foreach(fmt(b,_))
    uRLLinkField.foreach(fmt(b,_))
    noRoutingIDsField.foreach(fmt(b,_))
    routingIDsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    spreadToBenchmarkField.foreach(fmt(b,_))
    benchmarkField.foreach(fmt(b,_))
    b
  }

}
     
object IndicationofInterestMessage extends SfFixMessageDecoder {
  val MsgType="6"
  val MsgName="IndicationofInterest"
             
  override val MandatoryFields = HashSet[Int](
    IOIIDField.TagId, IOITransTypeField.TagId, SymbolField.TagId, SideField.TagId, IOISharesField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    IOIQualifiersGroup.isMandatoryField(tagId) || RoutingIDsGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    IOIRefIDField.TagId, SymbolSfxField.TagId, SecurityIDField.TagId, IDSourceField.TagId, SecurityTypeField.TagId, 
    MaturityMonthYearField.TagId, MaturityDayField.TagId, PutOrCallField.TagId, StrikePriceField.TagId, OptAttributeField.TagId, 
    ContractMultiplierField.TagId, CouponRateField.TagId, SecurityExchangeField.TagId, IssuerField.TagId, EncodedIssuerLenField.TagId, 
    EncodedIssuerField.TagId, SecurityDescField.TagId, EncodedSecurityDescLenField.TagId, EncodedSecurityDescField.TagId, PriceField.TagId, 
    CurrencyField.TagId, ValidUntilTimeField.TagId, IOIQltyIndField.TagId, IOINaturalFlagField.TagId, NoIOIQualifiersField.TagId, 
    TextField.TagId, EncodedTextLenField.TagId, EncodedTextField.TagId, TransactTimeField.TagId, URLLinkField.TagId, 
    NoRoutingIDsField.TagId, SpreadToBenchmarkField.TagId, BenchmarkField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    IOIQualifiersGroup.isOptionalField(tagId) || RoutingIDsGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    IOIQualifiersGroup.isFieldOf(tagId) || RoutingIDsGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoIOIQualifiersField.TagId, NoRoutingIDsField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==IOIIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(IndicationofInterestMessage(IOIIDField.decode(myFields.get(IOIIDField.TagId)).get,
        IOITransTypeField.decode(myFields.get(IOITransTypeField.TagId)).get,
        myFields.get(IOIRefIDField.TagId).flatMap(f=>IOIRefIDField.decode(f)),
        SymbolField.decode(myFields.get(SymbolField.TagId)).get,
        myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
        myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
        myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
        myFields.get(SecurityTypeField.TagId).flatMap(f=>SecurityTypeField.decode(f)),
        myFields.get(MaturityMonthYearField.TagId).flatMap(f=>MaturityMonthYearField.decode(f)),
        myFields.get(MaturityDayField.TagId).flatMap(f=>MaturityDayField.decode(f)),
        myFields.get(PutOrCallField.TagId).flatMap(f=>PutOrCallField.decode(f)),
        myFields.get(StrikePriceField.TagId).flatMap(f=>StrikePriceField.decode(f)),
        myFields.get(OptAttributeField.TagId).flatMap(f=>OptAttributeField.decode(f)),
        myFields.get(ContractMultiplierField.TagId).flatMap(f=>ContractMultiplierField.decode(f)),
        myFields.get(CouponRateField.TagId).flatMap(f=>CouponRateField.decode(f)),
        myFields.get(SecurityExchangeField.TagId).flatMap(f=>SecurityExchangeField.decode(f)),
        myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
        myFields.get(EncodedIssuerLenField.TagId).flatMap(f=>EncodedIssuerLenField.decode(f)),
        myFields.get(EncodedIssuerField.TagId).flatMap(f=>EncodedIssuerField.decode(f)),
        myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)),
        myFields.get(EncodedSecurityDescLenField.TagId).flatMap(f=>EncodedSecurityDescLenField.decode(f)),
        myFields.get(EncodedSecurityDescField.TagId).flatMap(f=>EncodedSecurityDescField.decode(f)),
        SideField.decode(myFields.get(SideField.TagId)).get,
        IOISharesField.decode(myFields.get(IOISharesField.TagId)).get,
        myFields.get(PriceField.TagId).flatMap(f=>PriceField.decode(f)),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(ValidUntilTimeField.TagId).flatMap(f=>ValidUntilTimeField.decode(f)),
        myFields.get(IOIQltyIndField.TagId).flatMap(f=>IOIQltyIndField.decode(f)),
        myFields.get(IOINaturalFlagField.TagId).flatMap(f=>IOINaturalFlagField.decode(f)),
        myFields.get(NoIOIQualifiersField.TagId).flatMap(f=>NoIOIQualifiersField.decode(f)),
        if (nextTagPosLookup.contains(NoIOIQualifiersField.TagId)) IOIQualifiersGroup.decode(flds, nextTagPosLookup(NoIOIQualifiersField.TagId)) else None,
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(EncodedTextLenField.TagId).flatMap(f=>EncodedTextLenField.decode(f)),
        myFields.get(EncodedTextField.TagId).flatMap(f=>EncodedTextField.decode(f)),
        myFields.get(TransactTimeField.TagId).flatMap(f=>TransactTimeField.decode(f)),
        myFields.get(URLLinkField.TagId).flatMap(f=>URLLinkField.decode(f)),
        myFields.get(NoRoutingIDsField.TagId).flatMap(f=>NoRoutingIDsField.decode(f)),
        if (nextTagPosLookup.contains(NoRoutingIDsField.TagId)) RoutingIDsGroup.decode(flds, nextTagPosLookup(NoRoutingIDsField.TagId)) else None,
        myFields.get(SpreadToBenchmarkField.TagId).flatMap(f=>SpreadToBenchmarkField.decode(f)),
        myFields.get(BenchmarkField.TagId).flatMap(f=>BenchmarkField.decode(f))))
    } else None
  }

    
}
     