package org.sackfix.fix42

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX42.xml
  */
case class NewOrderSingleMessage(clOrdIDField:ClOrdIDField,
                                 clientIDField:Option[ClientIDField]=None,
                                 execBrokerField:Option[ExecBrokerField]=None,
                                 accountField:Option[AccountField]=None,
                                 noAllocsField:Option[NoAllocsField]=None,
                                 allocsGroups: Option[List[AllocsGroup]]=None,
                                 settlmntTypField:Option[SettlmntTypField]=None,
                                 futSettDateField:Option[FutSettDateField]=None,
                                 handlInstField:HandlInstField,
                                 execInstField:Option[ExecInstField]=None,
                                 minQtyField:Option[MinQtyField]=None,
                                 maxFloorField:Option[MaxFloorField]=None,
                                 exDestinationField:Option[ExDestinationField]=None,
                                 noTradingSessionsField:Option[NoTradingSessionsField]=None,
                                 tradingSessionsGroups: Option[List[TradingSessionsGroup]]=None,
                                 processCodeField:Option[ProcessCodeField]=None,
                                 symbolField:SymbolField,
                                 symbolSfxField:Option[SymbolSfxField]=None,
                                 securityIDField:Option[SecurityIDField]=None,
                                 iDSourceField:Option[IDSourceField]=None,
                                 securityTypeField:Option[SecurityTypeField]=None,
                                 maturityMonthYearField:Option[MaturityMonthYearField]=None,
                                 maturityDayField:Option[MaturityDayField]=None,
                                 putOrCallField:Option[PutOrCallField]=None,
                                 strikePriceField:Option[StrikePriceField]=None,
                                 optAttributeField:Option[OptAttributeField]=None,
                                 contractMultiplierField:Option[ContractMultiplierField]=None,
                                 couponRateField:Option[CouponRateField]=None,
                                 securityExchangeField:Option[SecurityExchangeField]=None,
                                 issuerField:Option[IssuerField]=None,
                                 encodedIssuerLenField:Option[EncodedIssuerLenField]=None,
                                 encodedIssuerField:Option[EncodedIssuerField]=None,
                                 securityDescField:Option[SecurityDescField]=None,
                                 encodedSecurityDescLenField:Option[EncodedSecurityDescLenField]=None,
                                 encodedSecurityDescField:Option[EncodedSecurityDescField]=None,
                                 prevClosePxField:Option[PrevClosePxField]=None,
                                 sideField:SideField,
                                 locateReqdField:Option[LocateReqdField]=None,
                                 transactTimeField:TransactTimeField,
                                 orderQtyField:Option[OrderQtyField]=None,
                                 cashOrderQtyField:Option[CashOrderQtyField]=None,
                                 ordTypeField:OrdTypeField,
                                 priceField:Option[PriceField]=None,
                                 stopPxField:Option[StopPxField]=None,
                                 currencyField:Option[CurrencyField]=None,
                                 complianceIDField:Option[ComplianceIDField]=None,
                                 solicitedFlagField:Option[SolicitedFlagField]=None,
                                 iOIIDField:Option[IOIIDField]=None,
                                 quoteIDField:Option[QuoteIDField]=None,
                                 timeInForceField:Option[TimeInForceField]=None,
                                 effectiveTimeField:Option[EffectiveTimeField]=None,
                                 expireDateField:Option[ExpireDateField]=None,
                                 expireTimeField:Option[ExpireTimeField]=None,
                                 gTBookingInstField:Option[GTBookingInstField]=None,
                                 commissionField:Option[CommissionField]=None,
                                 commTypeField:Option[CommTypeField]=None,
                                 rule80AField:Option[Rule80AField]=None,
                                 forexReqField:Option[ForexReqField]=None,
                                 settlCurrencyField:Option[SettlCurrencyField]=None,
                                 textField:Option[TextField]=None,
                                 encodedTextLenField:Option[EncodedTextLenField]=None,
                                 encodedTextField:Option[EncodedTextField]=None,
                                 futSettDate2Field:Option[FutSettDate2Field]=None,
                                 orderQty2Field:Option[OrderQty2Field]=None,
                                 openCloseField:Option[OpenCloseField]=None,
                                 coveredOrUncoveredField:Option[CoveredOrUncoveredField]=None,
                                 customerOrFirmField:Option[CustomerOrFirmField]=None,
                                 maxShowField:Option[MaxShowField]=None,
                                 pegDifferenceField:Option[PegDifferenceField]=None,
                                 discretionInstField:Option[DiscretionInstField]=None,
                                 discretionOffsetField:Option[DiscretionOffsetField]=None,
                                 clearingFirmField:Option[ClearingFirmField]=None,
                                 clearingAccountField:Option[ClearingAccountField]=None) extends SfFixMessageBody("D")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noAllocsField.map(_.value).getOrElse(0) != allocsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoAllocsField.TagId,noAllocsField.map(_.value).getOrElse(0), allocsGroups.map(_.size).getOrElse(0))
  if (noTradingSessionsField.map(_.value).getOrElse(0) != tradingSessionsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoTradingSessionsField.TagId,noTradingSessionsField.map(_.value).getOrElse(0), tradingSessionsGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,clOrdIDField)
    clientIDField.foreach(fmt(b,_))
    execBrokerField.foreach(fmt(b,_))
    accountField.foreach(fmt(b,_))
    noAllocsField.foreach(fmt(b,_))
    allocsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    settlmntTypField.foreach(fmt(b,_))
    futSettDateField.foreach(fmt(b,_))
    fmt(b,handlInstField)
    execInstField.foreach(fmt(b,_))
    minQtyField.foreach(fmt(b,_))
    maxFloorField.foreach(fmt(b,_))
    exDestinationField.foreach(fmt(b,_))
    noTradingSessionsField.foreach(fmt(b,_))
    tradingSessionsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    processCodeField.foreach(fmt(b,_))
    fmt(b,symbolField)
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    securityTypeField.foreach(fmt(b,_))
    maturityMonthYearField.foreach(fmt(b,_))
    maturityDayField.foreach(fmt(b,_))
    putOrCallField.foreach(fmt(b,_))
    strikePriceField.foreach(fmt(b,_))
    optAttributeField.foreach(fmt(b,_))
    contractMultiplierField.foreach(fmt(b,_))
    couponRateField.foreach(fmt(b,_))
    securityExchangeField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    encodedIssuerLenField.foreach(fmt(b,_))
    encodedIssuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    encodedSecurityDescLenField.foreach(fmt(b,_))
    encodedSecurityDescField.foreach(fmt(b,_))
    prevClosePxField.foreach(fmt(b,_))
    fmt(b,sideField)
    locateReqdField.foreach(fmt(b,_))
    fmt(b,transactTimeField)
    orderQtyField.foreach(fmt(b,_))
    cashOrderQtyField.foreach(fmt(b,_))
    fmt(b,ordTypeField)
    priceField.foreach(fmt(b,_))
    stopPxField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    complianceIDField.foreach(fmt(b,_))
    solicitedFlagField.foreach(fmt(b,_))
    iOIIDField.foreach(fmt(b,_))
    quoteIDField.foreach(fmt(b,_))
    timeInForceField.foreach(fmt(b,_))
    effectiveTimeField.foreach(fmt(b,_))
    expireDateField.foreach(fmt(b,_))
    expireTimeField.foreach(fmt(b,_))
    gTBookingInstField.foreach(fmt(b,_))
    commissionField.foreach(fmt(b,_))
    commTypeField.foreach(fmt(b,_))
    rule80AField.foreach(fmt(b,_))
    forexReqField.foreach(fmt(b,_))
    settlCurrencyField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    encodedTextLenField.foreach(fmt(b,_))
    encodedTextField.foreach(fmt(b,_))
    futSettDate2Field.foreach(fmt(b,_))
    orderQty2Field.foreach(fmt(b,_))
    openCloseField.foreach(fmt(b,_))
    coveredOrUncoveredField.foreach(fmt(b,_))
    customerOrFirmField.foreach(fmt(b,_))
    maxShowField.foreach(fmt(b,_))
    pegDifferenceField.foreach(fmt(b,_))
    discretionInstField.foreach(fmt(b,_))
    discretionOffsetField.foreach(fmt(b,_))
    clearingFirmField.foreach(fmt(b,_))
    clearingAccountField.foreach(fmt(b,_))
    b
  }

}
     
object NewOrderSingleMessage extends SfFixMessageDecoder {
  val MsgType="D"
  val MsgName="NewOrderSingle"
             
  override val MandatoryFields = HashSet[Int](
    ClOrdIDField.TagId, HandlInstField.TagId, SymbolField.TagId, SideField.TagId, TransactTimeField.TagId, 
    OrdTypeField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    AllocsGroup.isMandatoryField(tagId) || TradingSessionsGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    ClientIDField.TagId, ExecBrokerField.TagId, AccountField.TagId, NoAllocsField.TagId, SettlmntTypField.TagId, 
    FutSettDateField.TagId, ExecInstField.TagId, MinQtyField.TagId, MaxFloorField.TagId, ExDestinationField.TagId, 
    NoTradingSessionsField.TagId, ProcessCodeField.TagId, SymbolSfxField.TagId, SecurityIDField.TagId, IDSourceField.TagId, 
    SecurityTypeField.TagId, MaturityMonthYearField.TagId, MaturityDayField.TagId, PutOrCallField.TagId, StrikePriceField.TagId, 
    OptAttributeField.TagId, ContractMultiplierField.TagId, CouponRateField.TagId, SecurityExchangeField.TagId, IssuerField.TagId, 
    EncodedIssuerLenField.TagId, EncodedIssuerField.TagId, SecurityDescField.TagId, EncodedSecurityDescLenField.TagId, EncodedSecurityDescField.TagId, 
    PrevClosePxField.TagId, LocateReqdField.TagId, OrderQtyField.TagId, CashOrderQtyField.TagId, PriceField.TagId, 
    StopPxField.TagId, CurrencyField.TagId, ComplianceIDField.TagId, SolicitedFlagField.TagId, IOIIDField.TagId, 
    QuoteIDField.TagId, TimeInForceField.TagId, EffectiveTimeField.TagId, ExpireDateField.TagId, ExpireTimeField.TagId, 
    GTBookingInstField.TagId, CommissionField.TagId, CommTypeField.TagId, Rule80AField.TagId, ForexReqField.TagId, 
    SettlCurrencyField.TagId, TextField.TagId, EncodedTextLenField.TagId, EncodedTextField.TagId, FutSettDate2Field.TagId, 
    OrderQty2Field.TagId, OpenCloseField.TagId, CoveredOrUncoveredField.TagId, CustomerOrFirmField.TagId, MaxShowField.TagId, 
    PegDifferenceField.TagId, DiscretionInstField.TagId, DiscretionOffsetField.TagId, ClearingFirmField.TagId, ClearingAccountField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    AllocsGroup.isOptionalField(tagId) || TradingSessionsGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    AllocsGroup.isFieldOf(tagId) || TradingSessionsGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoAllocsField.TagId, NoTradingSessionsField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==ClOrdIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(NewOrderSingleMessage(ClOrdIDField.decode(myFields.get(ClOrdIDField.TagId)).get,
        myFields.get(ClientIDField.TagId).flatMap(f=>ClientIDField.decode(f)),
        myFields.get(ExecBrokerField.TagId).flatMap(f=>ExecBrokerField.decode(f)),
        myFields.get(AccountField.TagId).flatMap(f=>AccountField.decode(f)),
        myFields.get(NoAllocsField.TagId).flatMap(f=>NoAllocsField.decode(f)),
        if (nextTagPosLookup.contains(NoAllocsField.TagId)) AllocsGroup.decode(flds, nextTagPosLookup(NoAllocsField.TagId)) else None,
        myFields.get(SettlmntTypField.TagId).flatMap(f=>SettlmntTypField.decode(f)),
        myFields.get(FutSettDateField.TagId).flatMap(f=>FutSettDateField.decode(f)),
        HandlInstField.decode(myFields.get(HandlInstField.TagId)).get,
        myFields.get(ExecInstField.TagId).flatMap(f=>ExecInstField.decode(f)),
        myFields.get(MinQtyField.TagId).flatMap(f=>MinQtyField.decode(f)),
        myFields.get(MaxFloorField.TagId).flatMap(f=>MaxFloorField.decode(f)),
        myFields.get(ExDestinationField.TagId).flatMap(f=>ExDestinationField.decode(f)),
        myFields.get(NoTradingSessionsField.TagId).flatMap(f=>NoTradingSessionsField.decode(f)),
        if (nextTagPosLookup.contains(NoTradingSessionsField.TagId)) TradingSessionsGroup.decode(flds, nextTagPosLookup(NoTradingSessionsField.TagId)) else None,
        myFields.get(ProcessCodeField.TagId).flatMap(f=>ProcessCodeField.decode(f)),
        SymbolField.decode(myFields.get(SymbolField.TagId)).get,
        myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
        myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
        myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
        myFields.get(SecurityTypeField.TagId).flatMap(f=>SecurityTypeField.decode(f)),
        myFields.get(MaturityMonthYearField.TagId).flatMap(f=>MaturityMonthYearField.decode(f)),
        myFields.get(MaturityDayField.TagId).flatMap(f=>MaturityDayField.decode(f)),
        myFields.get(PutOrCallField.TagId).flatMap(f=>PutOrCallField.decode(f)),
        myFields.get(StrikePriceField.TagId).flatMap(f=>StrikePriceField.decode(f)),
        myFields.get(OptAttributeField.TagId).flatMap(f=>OptAttributeField.decode(f)),
        myFields.get(ContractMultiplierField.TagId).flatMap(f=>ContractMultiplierField.decode(f)),
        myFields.get(CouponRateField.TagId).flatMap(f=>CouponRateField.decode(f)),
        myFields.get(SecurityExchangeField.TagId).flatMap(f=>SecurityExchangeField.decode(f)),
        myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
        myFields.get(EncodedIssuerLenField.TagId).flatMap(f=>EncodedIssuerLenField.decode(f)),
        myFields.get(EncodedIssuerField.TagId).flatMap(f=>EncodedIssuerField.decode(f)),
        myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)),
        myFields.get(EncodedSecurityDescLenField.TagId).flatMap(f=>EncodedSecurityDescLenField.decode(f)),
        myFields.get(EncodedSecurityDescField.TagId).flatMap(f=>EncodedSecurityDescField.decode(f)),
        myFields.get(PrevClosePxField.TagId).flatMap(f=>PrevClosePxField.decode(f)),
        SideField.decode(myFields.get(SideField.TagId)).get,
        myFields.get(LocateReqdField.TagId).flatMap(f=>LocateReqdField.decode(f)),
        TransactTimeField.decode(myFields.get(TransactTimeField.TagId)).get,
        myFields.get(OrderQtyField.TagId).flatMap(f=>OrderQtyField.decode(f)),
        myFields.get(CashOrderQtyField.TagId).flatMap(f=>CashOrderQtyField.decode(f)),
        OrdTypeField.decode(myFields.get(OrdTypeField.TagId)).get,
        myFields.get(PriceField.TagId).flatMap(f=>PriceField.decode(f)),
        myFields.get(StopPxField.TagId).flatMap(f=>StopPxField.decode(f)),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(ComplianceIDField.TagId).flatMap(f=>ComplianceIDField.decode(f)),
        myFields.get(SolicitedFlagField.TagId).flatMap(f=>SolicitedFlagField.decode(f)),
        myFields.get(IOIIDField.TagId).flatMap(f=>IOIIDField.decode(f)),
        myFields.get(QuoteIDField.TagId).flatMap(f=>QuoteIDField.decode(f)),
        myFields.get(TimeInForceField.TagId).flatMap(f=>TimeInForceField.decode(f)),
        myFields.get(EffectiveTimeField.TagId).flatMap(f=>EffectiveTimeField.decode(f)),
        myFields.get(ExpireDateField.TagId).flatMap(f=>ExpireDateField.decode(f)),
        myFields.get(ExpireTimeField.TagId).flatMap(f=>ExpireTimeField.decode(f)),
        myFields.get(GTBookingInstField.TagId).flatMap(f=>GTBookingInstField.decode(f)),
        myFields.get(CommissionField.TagId).flatMap(f=>CommissionField.decode(f)),
        myFields.get(CommTypeField.TagId).flatMap(f=>CommTypeField.decode(f)),
        myFields.get(Rule80AField.TagId).flatMap(f=>Rule80AField.decode(f)),
        myFields.get(ForexReqField.TagId).flatMap(f=>ForexReqField.decode(f)),
        myFields.get(SettlCurrencyField.TagId).flatMap(f=>SettlCurrencyField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(EncodedTextLenField.TagId).flatMap(f=>EncodedTextLenField.decode(f)),
        myFields.get(EncodedTextField.TagId).flatMap(f=>EncodedTextField.decode(f)),
        myFields.get(FutSettDate2Field.TagId).flatMap(f=>FutSettDate2Field.decode(f)),
        myFields.get(OrderQty2Field.TagId).flatMap(f=>OrderQty2Field.decode(f)),
        myFields.get(OpenCloseField.TagId).flatMap(f=>OpenCloseField.decode(f)),
        myFields.get(CoveredOrUncoveredField.TagId).flatMap(f=>CoveredOrUncoveredField.decode(f)),
        myFields.get(CustomerOrFirmField.TagId).flatMap(f=>CustomerOrFirmField.decode(f)),
        myFields.get(MaxShowField.TagId).flatMap(f=>MaxShowField.decode(f)),
        myFields.get(PegDifferenceField.TagId).flatMap(f=>PegDifferenceField.decode(f)),
        myFields.get(DiscretionInstField.TagId).flatMap(f=>DiscretionInstField.decode(f)),
        myFields.get(DiscretionOffsetField.TagId).flatMap(f=>DiscretionOffsetField.decode(f)),
        myFields.get(ClearingFirmField.TagId).flatMap(f=>ClearingFirmField.decode(f)),
        myFields.get(ClearingAccountField.TagId).flatMap(f=>ClearingAccountField.decode(f))))
    } else None
  }

    
}
     