package org.sackfix.fix42

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX42.xml
  */
case class QuoteAcknowledgementMessage(quoteReqIDField:Option[QuoteReqIDField]=None,
                                       quoteIDField:Option[QuoteIDField]=None,
                                       quoteAckStatusField:QuoteAckStatusField,
                                       quoteRejectReasonField:Option[QuoteRejectReasonField]=None,
                                       quoteResponseLevelField:Option[QuoteResponseLevelField]=None,
                                       tradingSessionIDField:Option[TradingSessionIDField]=None,
                                       textField:Option[TextField]=None,
                                       noQuoteSetsField:Option[NoQuoteSetsField]=None,
                                       quoteSetsGroups: Option[List[QuoteSetsGroup]]=None) extends SfFixMessageBody("b")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noQuoteSetsField.map(_.value).getOrElse(0) != quoteSetsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoQuoteSetsField.TagId,noQuoteSetsField.map(_.value).getOrElse(0), quoteSetsGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    quoteReqIDField.foreach(fmt(b,_))
    quoteIDField.foreach(fmt(b,_))
    fmt(b,quoteAckStatusField)
    quoteRejectReasonField.foreach(fmt(b,_))
    quoteResponseLevelField.foreach(fmt(b,_))
    tradingSessionIDField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    noQuoteSetsField.foreach(fmt(b,_))
    quoteSetsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    b
  }

}
     
object QuoteAcknowledgementMessage extends SfFixMessageDecoder {
  val MsgType="b"
  val MsgName="QuoteAcknowledgement"
             
  override val MandatoryFields = HashSet[Int](
    QuoteAckStatusField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    QuoteSetsGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    QuoteReqIDField.TagId, QuoteIDField.TagId, QuoteRejectReasonField.TagId, QuoteResponseLevelField.TagId, TradingSessionIDField.TagId, 
    TextField.TagId, NoQuoteSetsField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    QuoteSetsGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    QuoteSetsGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoQuoteSetsField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==QuoteReqIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(QuoteAcknowledgementMessage(myFields.get(QuoteReqIDField.TagId).flatMap(f=>QuoteReqIDField.decode(f)),
        myFields.get(QuoteIDField.TagId).flatMap(f=>QuoteIDField.decode(f)),
        QuoteAckStatusField.decode(myFields.get(QuoteAckStatusField.TagId)).get,
        myFields.get(QuoteRejectReasonField.TagId).flatMap(f=>QuoteRejectReasonField.decode(f)),
        myFields.get(QuoteResponseLevelField.TagId).flatMap(f=>QuoteResponseLevelField.decode(f)),
        myFields.get(TradingSessionIDField.TagId).flatMap(f=>TradingSessionIDField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(NoQuoteSetsField.TagId).flatMap(f=>NoQuoteSetsField.decode(f)),
        if (nextTagPosLookup.contains(NoQuoteSetsField.TagId)) QuoteSetsGroup.decode(flds, nextTagPosLookup(NoQuoteSetsField.TagId)) else None))
    } else None
  }

    
}
     