package org.sackfix.fix42

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX42.xml
  */
case class QuoteCancelMessage(quoteReqIDField:Option[QuoteReqIDField]=None,
                              quoteIDField:QuoteIDField,
                              quoteCancelTypeField:QuoteCancelTypeField,
                              quoteResponseLevelField:Option[QuoteResponseLevelField]=None,
                              tradingSessionIDField:Option[TradingSessionIDField]=None,
                              noQuoteEntriesField:NoQuoteEntriesField,
                              quoteEntriesGroups: List[QuoteEntriesGroup]) extends SfFixMessageBody("Z")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noQuoteEntriesField.value != quoteEntriesGroups.size)
    throw SfRepeatingGroupCountException(NoQuoteEntriesField.TagId,noQuoteEntriesField.value, quoteEntriesGroups.size)

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    quoteReqIDField.foreach(fmt(b,_))
    fmt(b,quoteIDField)
    fmt(b,quoteCancelTypeField)
    quoteResponseLevelField.foreach(fmt(b,_))
    tradingSessionIDField.foreach(fmt(b,_))
    fmt(b,noQuoteEntriesField)
    b
  }

}
     
object QuoteCancelMessage extends SfFixMessageDecoder {
  val MsgType="Z"
  val MsgName="QuoteCancel"
             
  override val MandatoryFields = HashSet[Int](
    QuoteIDField.TagId, QuoteCancelTypeField.TagId, NoQuoteEntriesField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    QuoteEntriesGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    QuoteReqIDField.TagId, QuoteResponseLevelField.TagId, TradingSessionIDField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    QuoteEntriesGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    QuoteEntriesGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoQuoteEntriesField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==QuoteReqIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(QuoteCancelMessage(myFields.get(QuoteReqIDField.TagId).flatMap(f=>QuoteReqIDField.decode(f)),
        QuoteIDField.decode(myFields.get(QuoteIDField.TagId)).get,
        QuoteCancelTypeField.decode(myFields.get(QuoteCancelTypeField.TagId)).get,
        myFields.get(QuoteResponseLevelField.TagId).flatMap(f=>QuoteResponseLevelField.decode(f)),
        myFields.get(TradingSessionIDField.TagId).flatMap(f=>TradingSessionIDField.decode(f)),
        NoQuoteEntriesField.decode(myFields.get(NoQuoteEntriesField.TagId)).get,
        if (nextTagPosLookup.contains(NoQuoteEntriesField.TagId)) QuoteEntriesGroup.decode(flds, nextTagPosLookup(NoQuoteEntriesField.TagId)).get else List.empty))
    } else None
  }

    
}
     