package org.sackfix.fix42

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixGroup, SfGroupDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX42.xml
  */
case class QuoteEntriesGroup(quoteEntryIDField:Option[QuoteEntryIDField]=None,
                             symbolField:Option[SymbolField]=None,
                             symbolSfxField:Option[SymbolSfxField]=None,
                             securityIDField:Option[SecurityIDField]=None,
                             iDSourceField:Option[IDSourceField]=None,
                             securityTypeField:Option[SecurityTypeField]=None,
                             maturityMonthYearField:Option[MaturityMonthYearField]=None,
                             maturityDayField:Option[MaturityDayField]=None,
                             putOrCallField:Option[PutOrCallField]=None,
                             strikePriceField:Option[StrikePriceField]=None,
                             optAttributeField:Option[OptAttributeField]=None,
                             contractMultiplierField:Option[ContractMultiplierField]=None,
                             couponRateField:Option[CouponRateField]=None,
                             securityExchangeField:Option[SecurityExchangeField]=None,
                             issuerField:Option[IssuerField]=None,
                             encodedIssuerLenField:Option[EncodedIssuerLenField]=None,
                             encodedIssuerField:Option[EncodedIssuerField]=None,
                             securityDescField:Option[SecurityDescField]=None,
                             encodedSecurityDescLenField:Option[EncodedSecurityDescLenField]=None,
                             encodedSecurityDescField:Option[EncodedSecurityDescField]=None,
                             quoteEntryRejectReasonField:Option[QuoteEntryRejectReasonField]=None) extends SfFixGroup  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    quoteEntryIDField.foreach(fmt(b,_))
    symbolField.foreach(fmt(b,_))
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    securityTypeField.foreach(fmt(b,_))
    maturityMonthYearField.foreach(fmt(b,_))
    maturityDayField.foreach(fmt(b,_))
    putOrCallField.foreach(fmt(b,_))
    strikePriceField.foreach(fmt(b,_))
    optAttributeField.foreach(fmt(b,_))
    contractMultiplierField.foreach(fmt(b,_))
    couponRateField.foreach(fmt(b,_))
    securityExchangeField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    encodedIssuerLenField.foreach(fmt(b,_))
    encodedIssuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    encodedSecurityDescLenField.foreach(fmt(b,_))
    encodedSecurityDescField.foreach(fmt(b,_))
    quoteEntryRejectReasonField.foreach(fmt(b,_))
    b
  }

}
     
object QuoteEntriesGroup extends SfGroupDecoder {

  override val MandatoryFields = HashSet[Int]()

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId) 
  }

  override val OptionalFields = HashSet[Int](
    QuoteEntryIDField.TagId, SymbolField.TagId, SymbolSfxField.TagId, SecurityIDField.TagId, IDSourceField.TagId, 
    SecurityTypeField.TagId, MaturityMonthYearField.TagId, MaturityDayField.TagId, PutOrCallField.TagId, StrikePriceField.TagId, 
    OptAttributeField.TagId, ContractMultiplierField.TagId, CouponRateField.TagId, SecurityExchangeField.TagId, IssuerField.TagId, 
    EncodedIssuerLenField.TagId, EncodedIssuerField.TagId, SecurityDescField.TagId, EncodedSecurityDescLenField.TagId, EncodedSecurityDescField.TagId, 
    QuoteEntryRejectReasonField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId) 
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId) 

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==QuoteEntryIDField.TagId 

  // Group version, startPos is the index to the first element of the first repeating group
  @tailrec
  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0, groups:ArrayBuffer[QuoteEntriesGroup]=ArrayBuffer.empty[QuoteEntriesGroup]):Option[List[QuoteEntriesGroup]] = {
    decodeSingle(flds, startPos) match {
      case (pos: Int, None) => if (groups.nonEmpty) Some(groups.toList) else None
      case (pos: Int, grp: Some[QuoteEntriesGroup]) => decode(flds, pos, groups += grp.get)
    }
  }

  /**
    * @param flds For groups in Fix ordering is VITAL.
    * @param startPos This index into the ordered fields. It HAS to contain the first field of the group
    * @return A Tuple2 holding the next position to read from the fields, and the newly created group
    */
  def decodeSingle(flds: Seq[Tuple2[Int, Any]], startPos:Int):Tuple2[Int,Option[QuoteEntriesGroup]] = {
    if (!isFirstField(flds(startPos)._1)) (startPos, None)
    else {
      val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(true, flds, startPos)
      validateMandatoryFieldsPresent(myFields)

      if (myFields.nonEmpty) {
        (pos,Some(QuoteEntriesGroup(myFields.get(QuoteEntryIDField.TagId).flatMap(f=>QuoteEntryIDField.decode(f)),
          myFields.get(SymbolField.TagId).flatMap(f=>SymbolField.decode(f)),
          myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
          myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
          myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
          myFields.get(SecurityTypeField.TagId).flatMap(f=>SecurityTypeField.decode(f)),
          myFields.get(MaturityMonthYearField.TagId).flatMap(f=>MaturityMonthYearField.decode(f)),
          myFields.get(MaturityDayField.TagId).flatMap(f=>MaturityDayField.decode(f)),
          myFields.get(PutOrCallField.TagId).flatMap(f=>PutOrCallField.decode(f)),
          myFields.get(StrikePriceField.TagId).flatMap(f=>StrikePriceField.decode(f)),
          myFields.get(OptAttributeField.TagId).flatMap(f=>OptAttributeField.decode(f)),
          myFields.get(ContractMultiplierField.TagId).flatMap(f=>ContractMultiplierField.decode(f)),
          myFields.get(CouponRateField.TagId).flatMap(f=>CouponRateField.decode(f)),
          myFields.get(SecurityExchangeField.TagId).flatMap(f=>SecurityExchangeField.decode(f)),
          myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
          myFields.get(EncodedIssuerLenField.TagId).flatMap(f=>EncodedIssuerLenField.decode(f)),
          myFields.get(EncodedIssuerField.TagId).flatMap(f=>EncodedIssuerField.decode(f)),
          myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)),
          myFields.get(EncodedSecurityDescLenField.TagId).flatMap(f=>EncodedSecurityDescLenField.decode(f)),
          myFields.get(EncodedSecurityDescField.TagId).flatMap(f=>EncodedSecurityDescField.decode(f)),
          myFields.get(QuoteEntryRejectReasonField.TagId).flatMap(f=>QuoteEntryRejectReasonField.decode(f)))))
      } else (startPos, None)
    }
  }
    
}
     