package org.sackfix.fix42

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX42.xml
  */
case class SecurityStatusMessage(securityStatusReqIDField:Option[SecurityStatusReqIDField]=None,
                                 symbolField:SymbolField,
                                 symbolSfxField:Option[SymbolSfxField]=None,
                                 securityIDField:Option[SecurityIDField]=None,
                                 iDSourceField:Option[IDSourceField]=None,
                                 securityTypeField:Option[SecurityTypeField]=None,
                                 maturityMonthYearField:Option[MaturityMonthYearField]=None,
                                 maturityDayField:Option[MaturityDayField]=None,
                                 putOrCallField:Option[PutOrCallField]=None,
                                 strikePriceField:Option[StrikePriceField]=None,
                                 optAttributeField:Option[OptAttributeField]=None,
                                 contractMultiplierField:Option[ContractMultiplierField]=None,
                                 couponRateField:Option[CouponRateField]=None,
                                 securityExchangeField:Option[SecurityExchangeField]=None,
                                 issuerField:Option[IssuerField]=None,
                                 encodedIssuerLenField:Option[EncodedIssuerLenField]=None,
                                 encodedIssuerField:Option[EncodedIssuerField]=None,
                                 securityDescField:Option[SecurityDescField]=None,
                                 encodedSecurityDescLenField:Option[EncodedSecurityDescLenField]=None,
                                 encodedSecurityDescField:Option[EncodedSecurityDescField]=None,
                                 currencyField:Option[CurrencyField]=None,
                                 tradingSessionIDField:Option[TradingSessionIDField]=None,
                                 unsolicitedIndicatorField:Option[UnsolicitedIndicatorField]=None,
                                 securityTradingStatusField:Option[SecurityTradingStatusField]=None,
                                 financialStatusField:Option[FinancialStatusField]=None,
                                 corporateActionField:Option[CorporateActionField]=None,
                                 haltReasonField:Option[HaltReasonField]=None,
                                 inViewOfCommonField:Option[InViewOfCommonField]=None,
                                 dueToRelatedField:Option[DueToRelatedField]=None,
                                 buyVolumeField:Option[BuyVolumeField]=None,
                                 sellVolumeField:Option[SellVolumeField]=None,
                                 highPxField:Option[HighPxField]=None,
                                 lowPxField:Option[LowPxField]=None,
                                 lastPxField:Option[LastPxField]=None,
                                 transactTimeField:Option[TransactTimeField]=None,
                                 adjustmentField:Option[AdjustmentField]=None) extends SfFixMessageBody("f")  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    securityStatusReqIDField.foreach(fmt(b,_))
    fmt(b,symbolField)
    symbolSfxField.foreach(fmt(b,_))
    securityIDField.foreach(fmt(b,_))
    iDSourceField.foreach(fmt(b,_))
    securityTypeField.foreach(fmt(b,_))
    maturityMonthYearField.foreach(fmt(b,_))
    maturityDayField.foreach(fmt(b,_))
    putOrCallField.foreach(fmt(b,_))
    strikePriceField.foreach(fmt(b,_))
    optAttributeField.foreach(fmt(b,_))
    contractMultiplierField.foreach(fmt(b,_))
    couponRateField.foreach(fmt(b,_))
    securityExchangeField.foreach(fmt(b,_))
    issuerField.foreach(fmt(b,_))
    encodedIssuerLenField.foreach(fmt(b,_))
    encodedIssuerField.foreach(fmt(b,_))
    securityDescField.foreach(fmt(b,_))
    encodedSecurityDescLenField.foreach(fmt(b,_))
    encodedSecurityDescField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    tradingSessionIDField.foreach(fmt(b,_))
    unsolicitedIndicatorField.foreach(fmt(b,_))
    securityTradingStatusField.foreach(fmt(b,_))
    financialStatusField.foreach(fmt(b,_))
    corporateActionField.foreach(fmt(b,_))
    haltReasonField.foreach(fmt(b,_))
    inViewOfCommonField.foreach(fmt(b,_))
    dueToRelatedField.foreach(fmt(b,_))
    buyVolumeField.foreach(fmt(b,_))
    sellVolumeField.foreach(fmt(b,_))
    highPxField.foreach(fmt(b,_))
    lowPxField.foreach(fmt(b,_))
    lastPxField.foreach(fmt(b,_))
    transactTimeField.foreach(fmt(b,_))
    adjustmentField.foreach(fmt(b,_))
    b
  }

}
     
object SecurityStatusMessage extends SfFixMessageDecoder {
  val MsgType="f"
  val MsgName="SecurityStatus"
             
  override val MandatoryFields = HashSet[Int](
    SymbolField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId) 
  }

  override val OptionalFields = HashSet[Int](
    SecurityStatusReqIDField.TagId, SymbolSfxField.TagId, SecurityIDField.TagId, IDSourceField.TagId, SecurityTypeField.TagId, 
    MaturityMonthYearField.TagId, MaturityDayField.TagId, PutOrCallField.TagId, StrikePriceField.TagId, OptAttributeField.TagId, 
    ContractMultiplierField.TagId, CouponRateField.TagId, SecurityExchangeField.TagId, IssuerField.TagId, EncodedIssuerLenField.TagId, 
    EncodedIssuerField.TagId, SecurityDescField.TagId, EncodedSecurityDescLenField.TagId, EncodedSecurityDescField.TagId, CurrencyField.TagId, 
    TradingSessionIDField.TagId, UnsolicitedIndicatorField.TagId, SecurityTradingStatusField.TagId, FinancialStatusField.TagId, CorporateActionField.TagId, 
    HaltReasonField.TagId, InViewOfCommonField.TagId, DueToRelatedField.TagId, BuyVolumeField.TagId, SellVolumeField.TagId, 
    HighPxField.TagId, LowPxField.TagId, LastPxField.TagId, TransactTimeField.TagId, AdjustmentField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId) 
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId) 

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==SecurityStatusReqIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(SecurityStatusMessage(myFields.get(SecurityStatusReqIDField.TagId).flatMap(f=>SecurityStatusReqIDField.decode(f)),
        SymbolField.decode(myFields.get(SymbolField.TagId)).get,
        myFields.get(SymbolSfxField.TagId).flatMap(f=>SymbolSfxField.decode(f)),
        myFields.get(SecurityIDField.TagId).flatMap(f=>SecurityIDField.decode(f)),
        myFields.get(IDSourceField.TagId).flatMap(f=>IDSourceField.decode(f)),
        myFields.get(SecurityTypeField.TagId).flatMap(f=>SecurityTypeField.decode(f)),
        myFields.get(MaturityMonthYearField.TagId).flatMap(f=>MaturityMonthYearField.decode(f)),
        myFields.get(MaturityDayField.TagId).flatMap(f=>MaturityDayField.decode(f)),
        myFields.get(PutOrCallField.TagId).flatMap(f=>PutOrCallField.decode(f)),
        myFields.get(StrikePriceField.TagId).flatMap(f=>StrikePriceField.decode(f)),
        myFields.get(OptAttributeField.TagId).flatMap(f=>OptAttributeField.decode(f)),
        myFields.get(ContractMultiplierField.TagId).flatMap(f=>ContractMultiplierField.decode(f)),
        myFields.get(CouponRateField.TagId).flatMap(f=>CouponRateField.decode(f)),
        myFields.get(SecurityExchangeField.TagId).flatMap(f=>SecurityExchangeField.decode(f)),
        myFields.get(IssuerField.TagId).flatMap(f=>IssuerField.decode(f)),
        myFields.get(EncodedIssuerLenField.TagId).flatMap(f=>EncodedIssuerLenField.decode(f)),
        myFields.get(EncodedIssuerField.TagId).flatMap(f=>EncodedIssuerField.decode(f)),
        myFields.get(SecurityDescField.TagId).flatMap(f=>SecurityDescField.decode(f)),
        myFields.get(EncodedSecurityDescLenField.TagId).flatMap(f=>EncodedSecurityDescLenField.decode(f)),
        myFields.get(EncodedSecurityDescField.TagId).flatMap(f=>EncodedSecurityDescField.decode(f)),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(TradingSessionIDField.TagId).flatMap(f=>TradingSessionIDField.decode(f)),
        myFields.get(UnsolicitedIndicatorField.TagId).flatMap(f=>UnsolicitedIndicatorField.decode(f)),
        myFields.get(SecurityTradingStatusField.TagId).flatMap(f=>SecurityTradingStatusField.decode(f)),
        myFields.get(FinancialStatusField.TagId).flatMap(f=>FinancialStatusField.decode(f)),
        myFields.get(CorporateActionField.TagId).flatMap(f=>CorporateActionField.decode(f)),
        myFields.get(HaltReasonField.TagId).flatMap(f=>HaltReasonField.decode(f)),
        myFields.get(InViewOfCommonField.TagId).flatMap(f=>InViewOfCommonField.decode(f)),
        myFields.get(DueToRelatedField.TagId).flatMap(f=>DueToRelatedField.decode(f)),
        myFields.get(BuyVolumeField.TagId).flatMap(f=>BuyVolumeField.decode(f)),
        myFields.get(SellVolumeField.TagId).flatMap(f=>SellVolumeField.decode(f)),
        myFields.get(HighPxField.TagId).flatMap(f=>HighPxField.decode(f)),
        myFields.get(LowPxField.TagId).flatMap(f=>LowPxField.decode(f)),
        myFields.get(LastPxField.TagId).flatMap(f=>LastPxField.decode(f)),
        myFields.get(TransactTimeField.TagId).flatMap(f=>TransactTimeField.decode(f)),
        myFields.get(AdjustmentField.TagId).flatMap(f=>AdjustmentField.decode(f))))
    } else None
  }

    
}
     