package org.sackfix.fix43

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX43.xml
  */
case class TradeCaptureReportMessage(tradeReportIDField:TradeReportIDField,
                                     tradeReportTransTypeStringField:Option[TradeReportTransTypeStringField]=None,
                                     tradeRequestIDField:Option[TradeRequestIDField]=None,
                                     execTypeField:ExecTypeField,
                                     tradeReportRefIDField:Option[TradeReportRefIDField]=None,
                                     execIDField:Option[ExecIDField]=None,
                                     secondaryExecIDField:Option[SecondaryExecIDField]=None,
                                     execRestatementReasonField:Option[ExecRestatementReasonField]=None,
                                     previouslyReportedField:PreviouslyReportedField,
                                     instrumentComponent:InstrumentComponent,
                                     orderQtyDataComponent:Option[OrderQtyDataComponent]=None,
                                     lastQtyField:LastQtyField,
                                     lastPxField:LastPxField,
                                     lastSpotRateField:Option[LastSpotRateField]=None,
                                     lastForwardPointsField:Option[LastForwardPointsField]=None,
                                     lastMktField:Option[LastMktField]=None,
                                     tradeDateField:TradeDateField,
                                     transactTimeField:TransactTimeField,
                                     settlmntTypField:Option[SettlmntTypField]=None,
                                     futSettDateField:Option[FutSettDateField]=None,
                                     matchStatusField:Option[MatchStatusField]=None,
                                     matchTypeField:Option[MatchTypeField]=None,
                                     noSidesField:NoSidesField,
                                     sidesGroups: List[SidesGroup]) extends SfFixMessageBody("AE")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noSidesField.value != sidesGroups.size)
    throw SfRepeatingGroupCountException(NoSidesField.TagId,noSidesField.value, sidesGroups.size)

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,tradeReportIDField)
    tradeReportTransTypeStringField.foreach(fmt(b,_))
    tradeRequestIDField.foreach(fmt(b,_))
    fmt(b,execTypeField)
    tradeReportRefIDField.foreach(fmt(b,_))
    execIDField.foreach(fmt(b,_))
    secondaryExecIDField.foreach(fmt(b,_))
    execRestatementReasonField.foreach(fmt(b,_))
    fmt(b,previouslyReportedField)
    fmt(b,instrumentComponent)
    orderQtyDataComponent.foreach(fmt(b,_))
    fmt(b,lastQtyField)
    fmt(b,lastPxField)
    lastSpotRateField.foreach(fmt(b,_))
    lastForwardPointsField.foreach(fmt(b,_))
    lastMktField.foreach(fmt(b,_))
    fmt(b,tradeDateField)
    fmt(b,transactTimeField)
    settlmntTypField.foreach(fmt(b,_))
    futSettDateField.foreach(fmt(b,_))
    matchStatusField.foreach(fmt(b,_))
    matchTypeField.foreach(fmt(b,_))
    fmt(b,noSidesField)
    b
  }

}
     
object TradeCaptureReportMessage extends SfFixMessageDecoder {
  val MsgType="AE"
  val MsgName="TradeCaptureReport"
             
  override val MandatoryFields = HashSet[Int](
    TradeReportIDField.TagId, ExecTypeField.TagId, PreviouslyReportedField.TagId, LastQtyField.TagId, LastPxField.TagId, 
    TradeDateField.TagId, TransactTimeField.TagId, NoSidesField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    InstrumentComponent.isMandatoryField(tagId) || OrderQtyDataComponent.isMandatoryField(tagId) || SidesGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    TradeReportTransTypeStringField.TagId, TradeRequestIDField.TagId, TradeReportRefIDField.TagId, ExecIDField.TagId, SecondaryExecIDField.TagId, 
    ExecRestatementReasonField.TagId, LastSpotRateField.TagId, LastForwardPointsField.TagId, LastMktField.TagId, SettlmntTypField.TagId, 
    FutSettDateField.TagId, MatchStatusField.TagId, MatchTypeField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    InstrumentComponent.isOptionalField(tagId) || OrderQtyDataComponent.isOptionalField(tagId) || SidesGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    InstrumentComponent.isFieldOf(tagId) || OrderQtyDataComponent.isFieldOf(tagId) || SidesGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoSidesField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==TradeReportIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(TradeCaptureReportMessage(TradeReportIDField.decode(myFields.get(TradeReportIDField.TagId)).get,
        myFields.get(TradeReportTransTypeStringField.TagId).flatMap(f=>TradeReportTransTypeStringField.decode(f)),
        myFields.get(TradeRequestIDField.TagId).flatMap(f=>TradeRequestIDField.decode(f)),
        ExecTypeField.decode(myFields.get(ExecTypeField.TagId)).get,
        myFields.get(TradeReportRefIDField.TagId).flatMap(f=>TradeReportRefIDField.decode(f)),
        myFields.get(ExecIDField.TagId).flatMap(f=>ExecIDField.decode(f)),
        myFields.get(SecondaryExecIDField.TagId).flatMap(f=>SecondaryExecIDField.decode(f)),
        myFields.get(ExecRestatementReasonField.TagId).flatMap(f=>ExecRestatementReasonField.decode(f)),
        PreviouslyReportedField.decode(myFields.get(PreviouslyReportedField.TagId)).get,
        InstrumentComponent.decode(flds, startPos).get,
        OrderQtyDataComponent.decode(flds, startPos),
        LastQtyField.decode(myFields.get(LastQtyField.TagId)).get,
        LastPxField.decode(myFields.get(LastPxField.TagId)).get,
        myFields.get(LastSpotRateField.TagId).flatMap(f=>LastSpotRateField.decode(f)),
        myFields.get(LastForwardPointsField.TagId).flatMap(f=>LastForwardPointsField.decode(f)),
        myFields.get(LastMktField.TagId).flatMap(f=>LastMktField.decode(f)),
        TradeDateField.decode(myFields.get(TradeDateField.TagId)).get,
        TransactTimeField.decode(myFields.get(TransactTimeField.TagId)).get,
        myFields.get(SettlmntTypField.TagId).flatMap(f=>SettlmntTypField.decode(f)),
        myFields.get(FutSettDateField.TagId).flatMap(f=>FutSettDateField.decode(f)),
        myFields.get(MatchStatusField.TagId).flatMap(f=>MatchStatusField.decode(f)),
        myFields.get(MatchTypeField.TagId).flatMap(f=>MatchTypeField.decode(f)),
        NoSidesField.decode(myFields.get(NoSidesField.TagId)).get,
        if (nextTagPosLookup.contains(NoSidesField.TagId)) SidesGroup.decode(flds, nextTagPosLookup(NoSidesField.TagId)).get else List.empty))
    } else None
  }

    
}
     