package org.sackfix.fix43

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX43.xml
  */
case class ExecutionReportMessage(orderIDField:OrderIDField,
                                  secondaryOrderIDField:Option[SecondaryOrderIDField]=None,
                                  secondaryClOrdIDField:Option[SecondaryClOrdIDField]=None,
                                  secondaryExecIDField:Option[SecondaryExecIDField]=None,
                                  clOrdIDField:Option[ClOrdIDField]=None,
                                  origClOrdIDField:Option[OrigClOrdIDField]=None,
                                  clOrdLinkIDField:Option[ClOrdLinkIDField]=None,
                                  partiesComponent:Option[PartiesComponent]=None,
                                  tradeOriginationDateField:Option[TradeOriginationDateField]=None,
                                  noContraBrokersField:Option[NoContraBrokersField]=None,
                                  contraBrokersGroups: Option[List[ContraBrokersGroup]]=None,
                                  listIDField:Option[ListIDField]=None,
                                  crossIDField:Option[CrossIDField]=None,
                                  origCrossIDField:Option[OrigCrossIDField]=None,
                                  crossTypeField:Option[CrossTypeField]=None,
                                  execIDField:ExecIDField,
                                  execRefIDField:Option[ExecRefIDField]=None,
                                  execTypeField:ExecTypeField,
                                  ordStatusField:OrdStatusField,
                                  workingIndicatorField:Option[WorkingIndicatorField]=None,
                                  ordRejReasonField:Option[OrdRejReasonField]=None,
                                  execRestatementReasonField:Option[ExecRestatementReasonField]=None,
                                  accountField:Option[AccountField]=None,
                                  accountTypeField:Option[AccountTypeField]=None,
                                  dayBookingInstField:Option[DayBookingInstField]=None,
                                  bookingUnitField:Option[BookingUnitField]=None,
                                  preallocMethodField:Option[PreallocMethodField]=None,
                                  settlmntTypField:Option[SettlmntTypField]=None,
                                  futSettDateField:Option[FutSettDateField]=None,
                                  cashMarginField:Option[CashMarginField]=None,
                                  clearingFeeIndicatorField:Option[ClearingFeeIndicatorField]=None,
                                  instrumentComponent:InstrumentComponent,
                                  sideField:SideField,
                                  stipulationsComponent:Option[StipulationsComponent]=None,
                                  quantityTypeField:Option[QuantityTypeField]=None,
                                  orderQtyDataComponent:OrderQtyDataComponent,
                                  ordTypeField:Option[OrdTypeField]=None,
                                  priceTypeField:Option[PriceTypeField]=None,
                                  priceField:Option[PriceField]=None,
                                  stopPxField:Option[StopPxField]=None,
                                  pegDifferenceField:Option[PegDifferenceField]=None,
                                  discretionInstField:Option[DiscretionInstField]=None,
                                  discretionOffsetField:Option[DiscretionOffsetField]=None,
                                  currencyField:Option[CurrencyField]=None,
                                  complianceIDField:Option[ComplianceIDField]=None,
                                  solicitedFlagField:Option[SolicitedFlagField]=None,
                                  timeInForceField:Option[TimeInForceField]=None,
                                  effectiveTimeField:Option[EffectiveTimeField]=None,
                                  expireDateField:Option[ExpireDateField]=None,
                                  expireTimeField:Option[ExpireTimeField]=None,
                                  execInstField:Option[ExecInstField]=None,
                                  orderCapacityField:Option[OrderCapacityField]=None,
                                  orderRestrictionsField:Option[OrderRestrictionsField]=None,
                                  custOrderCapacityField:Option[CustOrderCapacityField]=None,
                                  rule80AField:Option[Rule80AField]=None,
                                  lastQtyField:Option[LastQtyField]=None,
                                  underlyingLastQtyField:Option[UnderlyingLastQtyField]=None,
                                  lastPxField:Option[LastPxField]=None,
                                  underlyingLastPxField:Option[UnderlyingLastPxField]=None,
                                  lastSpotRateField:Option[LastSpotRateField]=None,
                                  lastForwardPointsField:Option[LastForwardPointsField]=None,
                                  lastMktField:Option[LastMktField]=None,
                                  tradingSessionIDField:Option[TradingSessionIDField]=None,
                                  tradingSessionSubIDField:Option[TradingSessionSubIDField]=None,
                                  lastCapacityField:Option[LastCapacityField]=None,
                                  leavesQtyField:LeavesQtyField,
                                  cumQtyField:CumQtyField,
                                  avgPxField:AvgPxField,
                                  dayOrderQtyField:Option[DayOrderQtyField]=None,
                                  dayCumQtyField:Option[DayCumQtyField]=None,
                                  dayAvgPxField:Option[DayAvgPxField]=None,
                                  gTBookingInstField:Option[GTBookingInstField]=None,
                                  tradeDateField:Option[TradeDateField]=None,
                                  transactTimeField:Option[TransactTimeField]=None,
                                  reportToExchField:Option[ReportToExchField]=None,
                                  commissionDataComponent:Option[CommissionDataComponent]=None,
                                  spreadOrBenchmarkCurveDataComponent:Option[SpreadOrBenchmarkCurveDataComponent]=None,
                                  yieldDataComponent:Option[YieldDataComponent]=None,
                                  grossTradeAmtField:Option[GrossTradeAmtField]=None,
                                  numDaysInterestField:Option[NumDaysInterestField]=None,
                                  exDateField:Option[ExDateField]=None,
                                  accruedInterestRateField:Option[AccruedInterestRateField]=None,
                                  accruedInterestAmtField:Option[AccruedInterestAmtField]=None,
                                  tradedFlatSwitchField:Option[TradedFlatSwitchField]=None,
                                  basisFeatureDateField:Option[BasisFeatureDateField]=None,
                                  basisFeaturePriceField:Option[BasisFeaturePriceField]=None,
                                  concessionField:Option[ConcessionField]=None,
                                  totalTakedownField:Option[TotalTakedownField]=None,
                                  netMoneyField:Option[NetMoneyField]=None,
                                  settlCurrAmtField:Option[SettlCurrAmtField]=None,
                                  settlCurrencyField:Option[SettlCurrencyField]=None,
                                  settlCurrFxRateField:Option[SettlCurrFxRateField]=None,
                                  settlCurrFxRateCalcField:Option[SettlCurrFxRateCalcField]=None,
                                  handlInstField:Option[HandlInstField]=None,
                                  minQtyField:Option[MinQtyField]=None,
                                  maxFloorField:Option[MaxFloorField]=None,
                                  positionEffectField:Option[PositionEffectField]=None,
                                  maxShowField:Option[MaxShowField]=None,
                                  textField:Option[TextField]=None,
                                  encodedTextLenField:Option[EncodedTextLenField]=None,
                                  encodedTextField:Option[EncodedTextField]=None,
                                  futSettDate2Field:Option[FutSettDate2Field]=None,
                                  orderQty2Field:Option[OrderQty2Field]=None,
                                  lastForwardPoints2Field:Option[LastForwardPoints2Field]=None,
                                  multiLegReportingTypeField:Option[MultiLegReportingTypeField]=None,
                                  cancellationRightsField:Option[CancellationRightsField]=None,
                                  moneyLaunderingStatusField:Option[MoneyLaunderingStatusField]=None,
                                  registIDField:Option[RegistIDField]=None,
                                  designationField:Option[DesignationField]=None,
                                  transBkdTimeField:Option[TransBkdTimeField]=None,
                                  execValuationPointField:Option[ExecValuationPointField]=None,
                                  execPriceTypeField:Option[ExecPriceTypeField]=None,
                                  execPriceAdjustmentField:Option[ExecPriceAdjustmentField]=None,
                                  priorityIndicatorField:Option[PriorityIndicatorField]=None,
                                  priceImprovementField:Option[PriceImprovementField]=None,
                                  noContAmtsField:Option[NoContAmtsField]=None,
                                  contAmtsGroups: Option[List[ContAmtsGroup]]=None,
                                  noLegsField:Option[NoLegsField]=None,
                                  legsGroups: Option[List[LegsGroup]]=None) extends SfFixMessageBody("8")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noContraBrokersField.map(_.value).getOrElse(0) != contraBrokersGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoContraBrokersField.TagId,noContraBrokersField.map(_.value).getOrElse(0), contraBrokersGroups.map(_.size).getOrElse(0))
  if (noContAmtsField.map(_.value).getOrElse(0) != contAmtsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoContAmtsField.TagId,noContAmtsField.map(_.value).getOrElse(0), contAmtsGroups.map(_.size).getOrElse(0))
  if (noLegsField.map(_.value).getOrElse(0) != legsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoLegsField.TagId,noLegsField.map(_.value).getOrElse(0), legsGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,orderIDField)
    secondaryOrderIDField.foreach(fmt(b,_))
    secondaryClOrdIDField.foreach(fmt(b,_))
    secondaryExecIDField.foreach(fmt(b,_))
    clOrdIDField.foreach(fmt(b,_))
    origClOrdIDField.foreach(fmt(b,_))
    clOrdLinkIDField.foreach(fmt(b,_))
    partiesComponent.foreach(fmt(b,_))
    tradeOriginationDateField.foreach(fmt(b,_))
    noContraBrokersField.foreach(fmt(b,_))
    contraBrokersGroups.getOrElse(List.empty).foreach(fmt(b,_))
    listIDField.foreach(fmt(b,_))
    crossIDField.foreach(fmt(b,_))
    origCrossIDField.foreach(fmt(b,_))
    crossTypeField.foreach(fmt(b,_))
    fmt(b,execIDField)
    execRefIDField.foreach(fmt(b,_))
    fmt(b,execTypeField)
    fmt(b,ordStatusField)
    workingIndicatorField.foreach(fmt(b,_))
    ordRejReasonField.foreach(fmt(b,_))
    execRestatementReasonField.foreach(fmt(b,_))
    accountField.foreach(fmt(b,_))
    accountTypeField.foreach(fmt(b,_))
    dayBookingInstField.foreach(fmt(b,_))
    bookingUnitField.foreach(fmt(b,_))
    preallocMethodField.foreach(fmt(b,_))
    settlmntTypField.foreach(fmt(b,_))
    futSettDateField.foreach(fmt(b,_))
    cashMarginField.foreach(fmt(b,_))
    clearingFeeIndicatorField.foreach(fmt(b,_))
    fmt(b,instrumentComponent)
    fmt(b,sideField)
    stipulationsComponent.foreach(fmt(b,_))
    quantityTypeField.foreach(fmt(b,_))
    fmt(b,orderQtyDataComponent)
    ordTypeField.foreach(fmt(b,_))
    priceTypeField.foreach(fmt(b,_))
    priceField.foreach(fmt(b,_))
    stopPxField.foreach(fmt(b,_))
    pegDifferenceField.foreach(fmt(b,_))
    discretionInstField.foreach(fmt(b,_))
    discretionOffsetField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    complianceIDField.foreach(fmt(b,_))
    solicitedFlagField.foreach(fmt(b,_))
    timeInForceField.foreach(fmt(b,_))
    effectiveTimeField.foreach(fmt(b,_))
    expireDateField.foreach(fmt(b,_))
    expireTimeField.foreach(fmt(b,_))
    execInstField.foreach(fmt(b,_))
    orderCapacityField.foreach(fmt(b,_))
    orderRestrictionsField.foreach(fmt(b,_))
    custOrderCapacityField.foreach(fmt(b,_))
    rule80AField.foreach(fmt(b,_))
    lastQtyField.foreach(fmt(b,_))
    underlyingLastQtyField.foreach(fmt(b,_))
    lastPxField.foreach(fmt(b,_))
    underlyingLastPxField.foreach(fmt(b,_))
    lastSpotRateField.foreach(fmt(b,_))
    lastForwardPointsField.foreach(fmt(b,_))
    lastMktField.foreach(fmt(b,_))
    tradingSessionIDField.foreach(fmt(b,_))
    tradingSessionSubIDField.foreach(fmt(b,_))
    lastCapacityField.foreach(fmt(b,_))
    fmt(b,leavesQtyField)
    fmt(b,cumQtyField)
    fmt(b,avgPxField)
    dayOrderQtyField.foreach(fmt(b,_))
    dayCumQtyField.foreach(fmt(b,_))
    dayAvgPxField.foreach(fmt(b,_))
    gTBookingInstField.foreach(fmt(b,_))
    tradeDateField.foreach(fmt(b,_))
    transactTimeField.foreach(fmt(b,_))
    reportToExchField.foreach(fmt(b,_))
    commissionDataComponent.foreach(fmt(b,_))
    spreadOrBenchmarkCurveDataComponent.foreach(fmt(b,_))
    yieldDataComponent.foreach(fmt(b,_))
    grossTradeAmtField.foreach(fmt(b,_))
    numDaysInterestField.foreach(fmt(b,_))
    exDateField.foreach(fmt(b,_))
    accruedInterestRateField.foreach(fmt(b,_))
    accruedInterestAmtField.foreach(fmt(b,_))
    tradedFlatSwitchField.foreach(fmt(b,_))
    basisFeatureDateField.foreach(fmt(b,_))
    basisFeaturePriceField.foreach(fmt(b,_))
    concessionField.foreach(fmt(b,_))
    totalTakedownField.foreach(fmt(b,_))
    netMoneyField.foreach(fmt(b,_))
    settlCurrAmtField.foreach(fmt(b,_))
    settlCurrencyField.foreach(fmt(b,_))
    settlCurrFxRateField.foreach(fmt(b,_))
    settlCurrFxRateCalcField.foreach(fmt(b,_))
    handlInstField.foreach(fmt(b,_))
    minQtyField.foreach(fmt(b,_))
    maxFloorField.foreach(fmt(b,_))
    positionEffectField.foreach(fmt(b,_))
    maxShowField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    encodedTextLenField.foreach(fmt(b,_))
    encodedTextField.foreach(fmt(b,_))
    futSettDate2Field.foreach(fmt(b,_))
    orderQty2Field.foreach(fmt(b,_))
    lastForwardPoints2Field.foreach(fmt(b,_))
    multiLegReportingTypeField.foreach(fmt(b,_))
    cancellationRightsField.foreach(fmt(b,_))
    moneyLaunderingStatusField.foreach(fmt(b,_))
    registIDField.foreach(fmt(b,_))
    designationField.foreach(fmt(b,_))
    transBkdTimeField.foreach(fmt(b,_))
    execValuationPointField.foreach(fmt(b,_))
    execPriceTypeField.foreach(fmt(b,_))
    execPriceAdjustmentField.foreach(fmt(b,_))
    priorityIndicatorField.foreach(fmt(b,_))
    priceImprovementField.foreach(fmt(b,_))
    noContAmtsField.foreach(fmt(b,_))
    contAmtsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    noLegsField.foreach(fmt(b,_))
    legsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    b
  }

}
     
object ExecutionReportMessage extends SfFixMessageDecoder {
  val MsgType="8"
  val MsgName="ExecutionReport"
             
  override val MandatoryFields = HashSet[Int](
    OrderIDField.TagId, ExecIDField.TagId, ExecTypeField.TagId, OrdStatusField.TagId, SideField.TagId, 
    LeavesQtyField.TagId, CumQtyField.TagId, AvgPxField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    PartiesComponent.isMandatoryField(tagId) || ContraBrokersGroup.isMandatoryField(tagId) || InstrumentComponent.isMandatoryField(tagId) || StipulationsComponent.isMandatoryField(tagId) || 
    OrderQtyDataComponent.isMandatoryField(tagId) || CommissionDataComponent.isMandatoryField(tagId) || SpreadOrBenchmarkCurveDataComponent.isMandatoryField(tagId) || YieldDataComponent.isMandatoryField(tagId) || 
    ContAmtsGroup.isMandatoryField(tagId) || LegsGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    SecondaryOrderIDField.TagId, SecondaryClOrdIDField.TagId, SecondaryExecIDField.TagId, ClOrdIDField.TagId, OrigClOrdIDField.TagId, 
    ClOrdLinkIDField.TagId, TradeOriginationDateField.TagId, NoContraBrokersField.TagId, ListIDField.TagId, CrossIDField.TagId, 
    OrigCrossIDField.TagId, CrossTypeField.TagId, ExecRefIDField.TagId, WorkingIndicatorField.TagId, OrdRejReasonField.TagId, 
    ExecRestatementReasonField.TagId, AccountField.TagId, AccountTypeField.TagId, DayBookingInstField.TagId, BookingUnitField.TagId, 
    PreallocMethodField.TagId, SettlmntTypField.TagId, FutSettDateField.TagId, CashMarginField.TagId, ClearingFeeIndicatorField.TagId, 
    QuantityTypeField.TagId, OrdTypeField.TagId, PriceTypeField.TagId, PriceField.TagId, StopPxField.TagId, 
    PegDifferenceField.TagId, DiscretionInstField.TagId, DiscretionOffsetField.TagId, CurrencyField.TagId, ComplianceIDField.TagId, 
    SolicitedFlagField.TagId, TimeInForceField.TagId, EffectiveTimeField.TagId, ExpireDateField.TagId, ExpireTimeField.TagId, 
    ExecInstField.TagId, OrderCapacityField.TagId, OrderRestrictionsField.TagId, CustOrderCapacityField.TagId, Rule80AField.TagId, 
    LastQtyField.TagId, UnderlyingLastQtyField.TagId, LastPxField.TagId, UnderlyingLastPxField.TagId, LastSpotRateField.TagId, 
    LastForwardPointsField.TagId, LastMktField.TagId, TradingSessionIDField.TagId, TradingSessionSubIDField.TagId, LastCapacityField.TagId, 
    DayOrderQtyField.TagId, DayCumQtyField.TagId, DayAvgPxField.TagId, GTBookingInstField.TagId, TradeDateField.TagId, 
    TransactTimeField.TagId, ReportToExchField.TagId, GrossTradeAmtField.TagId, NumDaysInterestField.TagId, ExDateField.TagId, 
    AccruedInterestRateField.TagId, AccruedInterestAmtField.TagId, TradedFlatSwitchField.TagId, BasisFeatureDateField.TagId, BasisFeaturePriceField.TagId, 
    ConcessionField.TagId, TotalTakedownField.TagId, NetMoneyField.TagId, SettlCurrAmtField.TagId, SettlCurrencyField.TagId, 
    SettlCurrFxRateField.TagId, SettlCurrFxRateCalcField.TagId, HandlInstField.TagId, MinQtyField.TagId, MaxFloorField.TagId, 
    PositionEffectField.TagId, MaxShowField.TagId, TextField.TagId, EncodedTextLenField.TagId, EncodedTextField.TagId, 
    FutSettDate2Field.TagId, OrderQty2Field.TagId, LastForwardPoints2Field.TagId, MultiLegReportingTypeField.TagId, CancellationRightsField.TagId, 
    MoneyLaunderingStatusField.TagId, RegistIDField.TagId, DesignationField.TagId, TransBkdTimeField.TagId, ExecValuationPointField.TagId, 
    ExecPriceTypeField.TagId, ExecPriceAdjustmentField.TagId, PriorityIndicatorField.TagId, PriceImprovementField.TagId, NoContAmtsField.TagId, 
    NoLegsField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    PartiesComponent.isOptionalField(tagId) || ContraBrokersGroup.isOptionalField(tagId) || InstrumentComponent.isOptionalField(tagId) || StipulationsComponent.isOptionalField(tagId) || 
    OrderQtyDataComponent.isOptionalField(tagId) || CommissionDataComponent.isOptionalField(tagId) || SpreadOrBenchmarkCurveDataComponent.isOptionalField(tagId) || YieldDataComponent.isOptionalField(tagId) || 
    ContAmtsGroup.isOptionalField(tagId) || LegsGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    PartiesComponent.isFieldOf(tagId) || ContraBrokersGroup.isFieldOf(tagId) || InstrumentComponent.isFieldOf(tagId) || 
    StipulationsComponent.isFieldOf(tagId) || OrderQtyDataComponent.isFieldOf(tagId) || CommissionDataComponent.isFieldOf(tagId) || 
    SpreadOrBenchmarkCurveDataComponent.isFieldOf(tagId) || YieldDataComponent.isFieldOf(tagId) || ContAmtsGroup.isFieldOf(tagId) || 
    LegsGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoContraBrokersField.TagId, NoContAmtsField.TagId, NoLegsField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==OrderIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(ExecutionReportMessage(OrderIDField.decode(myFields.get(OrderIDField.TagId)).get,
        myFields.get(SecondaryOrderIDField.TagId).flatMap(f=>SecondaryOrderIDField.decode(f)),
        myFields.get(SecondaryClOrdIDField.TagId).flatMap(f=>SecondaryClOrdIDField.decode(f)),
        myFields.get(SecondaryExecIDField.TagId).flatMap(f=>SecondaryExecIDField.decode(f)),
        myFields.get(ClOrdIDField.TagId).flatMap(f=>ClOrdIDField.decode(f)),
        myFields.get(OrigClOrdIDField.TagId).flatMap(f=>OrigClOrdIDField.decode(f)),
        myFields.get(ClOrdLinkIDField.TagId).flatMap(f=>ClOrdLinkIDField.decode(f)),
        PartiesComponent.decode(flds, startPos),
        myFields.get(TradeOriginationDateField.TagId).flatMap(f=>TradeOriginationDateField.decode(f)),
        myFields.get(NoContraBrokersField.TagId).flatMap(f=>NoContraBrokersField.decode(f)),
        if (nextTagPosLookup.contains(NoContraBrokersField.TagId)) ContraBrokersGroup.decode(flds, nextTagPosLookup(NoContraBrokersField.TagId)) else None,
        myFields.get(ListIDField.TagId).flatMap(f=>ListIDField.decode(f)),
        myFields.get(CrossIDField.TagId).flatMap(f=>CrossIDField.decode(f)),
        myFields.get(OrigCrossIDField.TagId).flatMap(f=>OrigCrossIDField.decode(f)),
        myFields.get(CrossTypeField.TagId).flatMap(f=>CrossTypeField.decode(f)),
        ExecIDField.decode(myFields.get(ExecIDField.TagId)).get,
        myFields.get(ExecRefIDField.TagId).flatMap(f=>ExecRefIDField.decode(f)),
        ExecTypeField.decode(myFields.get(ExecTypeField.TagId)).get,
        OrdStatusField.decode(myFields.get(OrdStatusField.TagId)).get,
        myFields.get(WorkingIndicatorField.TagId).flatMap(f=>WorkingIndicatorField.decode(f)),
        myFields.get(OrdRejReasonField.TagId).flatMap(f=>OrdRejReasonField.decode(f)),
        myFields.get(ExecRestatementReasonField.TagId).flatMap(f=>ExecRestatementReasonField.decode(f)),
        myFields.get(AccountField.TagId).flatMap(f=>AccountField.decode(f)),
        myFields.get(AccountTypeField.TagId).flatMap(f=>AccountTypeField.decode(f)),
        myFields.get(DayBookingInstField.TagId).flatMap(f=>DayBookingInstField.decode(f)),
        myFields.get(BookingUnitField.TagId).flatMap(f=>BookingUnitField.decode(f)),
        myFields.get(PreallocMethodField.TagId).flatMap(f=>PreallocMethodField.decode(f)),
        myFields.get(SettlmntTypField.TagId).flatMap(f=>SettlmntTypField.decode(f)),
        myFields.get(FutSettDateField.TagId).flatMap(f=>FutSettDateField.decode(f)),
        myFields.get(CashMarginField.TagId).flatMap(f=>CashMarginField.decode(f)),
        myFields.get(ClearingFeeIndicatorField.TagId).flatMap(f=>ClearingFeeIndicatorField.decode(f)),
        InstrumentComponent.decode(flds, startPos).get,
        SideField.decode(myFields.get(SideField.TagId)).get,
        StipulationsComponent.decode(flds, startPos),
        myFields.get(QuantityTypeField.TagId).flatMap(f=>QuantityTypeField.decode(f)),
        OrderQtyDataComponent.decode(flds, startPos).get,
        myFields.get(OrdTypeField.TagId).flatMap(f=>OrdTypeField.decode(f)),
        myFields.get(PriceTypeField.TagId).flatMap(f=>PriceTypeField.decode(f)),
        myFields.get(PriceField.TagId).flatMap(f=>PriceField.decode(f)),
        myFields.get(StopPxField.TagId).flatMap(f=>StopPxField.decode(f)),
        myFields.get(PegDifferenceField.TagId).flatMap(f=>PegDifferenceField.decode(f)),
        myFields.get(DiscretionInstField.TagId).flatMap(f=>DiscretionInstField.decode(f)),
        myFields.get(DiscretionOffsetField.TagId).flatMap(f=>DiscretionOffsetField.decode(f)),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(ComplianceIDField.TagId).flatMap(f=>ComplianceIDField.decode(f)),
        myFields.get(SolicitedFlagField.TagId).flatMap(f=>SolicitedFlagField.decode(f)),
        myFields.get(TimeInForceField.TagId).flatMap(f=>TimeInForceField.decode(f)),
        myFields.get(EffectiveTimeField.TagId).flatMap(f=>EffectiveTimeField.decode(f)),
        myFields.get(ExpireDateField.TagId).flatMap(f=>ExpireDateField.decode(f)),
        myFields.get(ExpireTimeField.TagId).flatMap(f=>ExpireTimeField.decode(f)),
        myFields.get(ExecInstField.TagId).flatMap(f=>ExecInstField.decode(f)),
        myFields.get(OrderCapacityField.TagId).flatMap(f=>OrderCapacityField.decode(f)),
        myFields.get(OrderRestrictionsField.TagId).flatMap(f=>OrderRestrictionsField.decode(f)),
        myFields.get(CustOrderCapacityField.TagId).flatMap(f=>CustOrderCapacityField.decode(f)),
        myFields.get(Rule80AField.TagId).flatMap(f=>Rule80AField.decode(f)),
        myFields.get(LastQtyField.TagId).flatMap(f=>LastQtyField.decode(f)),
        myFields.get(UnderlyingLastQtyField.TagId).flatMap(f=>UnderlyingLastQtyField.decode(f)),
        myFields.get(LastPxField.TagId).flatMap(f=>LastPxField.decode(f)),
        myFields.get(UnderlyingLastPxField.TagId).flatMap(f=>UnderlyingLastPxField.decode(f)),
        myFields.get(LastSpotRateField.TagId).flatMap(f=>LastSpotRateField.decode(f)),
        myFields.get(LastForwardPointsField.TagId).flatMap(f=>LastForwardPointsField.decode(f)),
        myFields.get(LastMktField.TagId).flatMap(f=>LastMktField.decode(f)),
        myFields.get(TradingSessionIDField.TagId).flatMap(f=>TradingSessionIDField.decode(f)),
        myFields.get(TradingSessionSubIDField.TagId).flatMap(f=>TradingSessionSubIDField.decode(f)),
        myFields.get(LastCapacityField.TagId).flatMap(f=>LastCapacityField.decode(f)),
        LeavesQtyField.decode(myFields.get(LeavesQtyField.TagId)).get,
        CumQtyField.decode(myFields.get(CumQtyField.TagId)).get,
        AvgPxField.decode(myFields.get(AvgPxField.TagId)).get,
        myFields.get(DayOrderQtyField.TagId).flatMap(f=>DayOrderQtyField.decode(f)),
        myFields.get(DayCumQtyField.TagId).flatMap(f=>DayCumQtyField.decode(f)),
        myFields.get(DayAvgPxField.TagId).flatMap(f=>DayAvgPxField.decode(f)),
        myFields.get(GTBookingInstField.TagId).flatMap(f=>GTBookingInstField.decode(f)),
        myFields.get(TradeDateField.TagId).flatMap(f=>TradeDateField.decode(f)),
        myFields.get(TransactTimeField.TagId).flatMap(f=>TransactTimeField.decode(f)),
        myFields.get(ReportToExchField.TagId).flatMap(f=>ReportToExchField.decode(f)),
        CommissionDataComponent.decode(flds, startPos),
        SpreadOrBenchmarkCurveDataComponent.decode(flds, startPos),
        YieldDataComponent.decode(flds, startPos),
        myFields.get(GrossTradeAmtField.TagId).flatMap(f=>GrossTradeAmtField.decode(f)),
        myFields.get(NumDaysInterestField.TagId).flatMap(f=>NumDaysInterestField.decode(f)),
        myFields.get(ExDateField.TagId).flatMap(f=>ExDateField.decode(f)),
        myFields.get(AccruedInterestRateField.TagId).flatMap(f=>AccruedInterestRateField.decode(f)),
        myFields.get(AccruedInterestAmtField.TagId).flatMap(f=>AccruedInterestAmtField.decode(f)),
        myFields.get(TradedFlatSwitchField.TagId).flatMap(f=>TradedFlatSwitchField.decode(f)),
        myFields.get(BasisFeatureDateField.TagId).flatMap(f=>BasisFeatureDateField.decode(f)),
        myFields.get(BasisFeaturePriceField.TagId).flatMap(f=>BasisFeaturePriceField.decode(f)),
        myFields.get(ConcessionField.TagId).flatMap(f=>ConcessionField.decode(f)),
        myFields.get(TotalTakedownField.TagId).flatMap(f=>TotalTakedownField.decode(f)),
        myFields.get(NetMoneyField.TagId).flatMap(f=>NetMoneyField.decode(f)),
        myFields.get(SettlCurrAmtField.TagId).flatMap(f=>SettlCurrAmtField.decode(f)),
        myFields.get(SettlCurrencyField.TagId).flatMap(f=>SettlCurrencyField.decode(f)),
        myFields.get(SettlCurrFxRateField.TagId).flatMap(f=>SettlCurrFxRateField.decode(f)),
        myFields.get(SettlCurrFxRateCalcField.TagId).flatMap(f=>SettlCurrFxRateCalcField.decode(f)),
        myFields.get(HandlInstField.TagId).flatMap(f=>HandlInstField.decode(f)),
        myFields.get(MinQtyField.TagId).flatMap(f=>MinQtyField.decode(f)),
        myFields.get(MaxFloorField.TagId).flatMap(f=>MaxFloorField.decode(f)),
        myFields.get(PositionEffectField.TagId).flatMap(f=>PositionEffectField.decode(f)),
        myFields.get(MaxShowField.TagId).flatMap(f=>MaxShowField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(EncodedTextLenField.TagId).flatMap(f=>EncodedTextLenField.decode(f)),
        myFields.get(EncodedTextField.TagId).flatMap(f=>EncodedTextField.decode(f)),
        myFields.get(FutSettDate2Field.TagId).flatMap(f=>FutSettDate2Field.decode(f)),
        myFields.get(OrderQty2Field.TagId).flatMap(f=>OrderQty2Field.decode(f)),
        myFields.get(LastForwardPoints2Field.TagId).flatMap(f=>LastForwardPoints2Field.decode(f)),
        myFields.get(MultiLegReportingTypeField.TagId).flatMap(f=>MultiLegReportingTypeField.decode(f)),
        myFields.get(CancellationRightsField.TagId).flatMap(f=>CancellationRightsField.decode(f)),
        myFields.get(MoneyLaunderingStatusField.TagId).flatMap(f=>MoneyLaunderingStatusField.decode(f)),
        myFields.get(RegistIDField.TagId).flatMap(f=>RegistIDField.decode(f)),
        myFields.get(DesignationField.TagId).flatMap(f=>DesignationField.decode(f)),
        myFields.get(TransBkdTimeField.TagId).flatMap(f=>TransBkdTimeField.decode(f)),
        myFields.get(ExecValuationPointField.TagId).flatMap(f=>ExecValuationPointField.decode(f)),
        myFields.get(ExecPriceTypeField.TagId).flatMap(f=>ExecPriceTypeField.decode(f)),
        myFields.get(ExecPriceAdjustmentField.TagId).flatMap(f=>ExecPriceAdjustmentField.decode(f)),
        myFields.get(PriorityIndicatorField.TagId).flatMap(f=>PriorityIndicatorField.decode(f)),
        myFields.get(PriceImprovementField.TagId).flatMap(f=>PriceImprovementField.decode(f)),
        myFields.get(NoContAmtsField.TagId).flatMap(f=>NoContAmtsField.decode(f)),
        if (nextTagPosLookup.contains(NoContAmtsField.TagId)) ContAmtsGroup.decode(flds, nextTagPosLookup(NoContAmtsField.TagId)) else None,
        myFields.get(NoLegsField.TagId).flatMap(f=>NoLegsField.decode(f)),
        if (nextTagPosLookup.contains(NoLegsField.TagId)) LegsGroup.decode(flds, nextTagPosLookup(NoLegsField.TagId)) else None))
    } else None
  }

    
}
     