package org.sackfix.fix43

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX43.xml
  */
case class MarketDataSnapshotFullRefreshMessage(mDReqIDField:Option[MDReqIDField]=None,
                                                instrumentComponent:InstrumentComponent,
                                                financialStatusField:Option[FinancialStatusField]=None,
                                                corporateActionField:Option[CorporateActionField]=None,
                                                totalVolumeTradedField:Option[TotalVolumeTradedField]=None,
                                                totalVolumeTradedDateField:Option[TotalVolumeTradedDateField]=None,
                                                totalVolumeTradedTimeField:Option[TotalVolumeTradedTimeField]=None,
                                                netChgPrevDayField:Option[NetChgPrevDayField]=None,
                                                noMDEntriesField:NoMDEntriesField,
                                                mDEntriesGroups: List[MDEntriesGroup]) extends SfFixMessageBody("W")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noMDEntriesField.value != mDEntriesGroups.size)
    throw SfRepeatingGroupCountException(NoMDEntriesField.TagId,noMDEntriesField.value, mDEntriesGroups.size)

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    mDReqIDField.foreach(fmt(b,_))
    fmt(b,instrumentComponent)
    financialStatusField.foreach(fmt(b,_))
    corporateActionField.foreach(fmt(b,_))
    totalVolumeTradedField.foreach(fmt(b,_))
    totalVolumeTradedDateField.foreach(fmt(b,_))
    totalVolumeTradedTimeField.foreach(fmt(b,_))
    netChgPrevDayField.foreach(fmt(b,_))
    fmt(b,noMDEntriesField)
    b
  }

}
     
object MarketDataSnapshotFullRefreshMessage extends SfFixMessageDecoder {
  val MsgType="W"
  val MsgName="MarketDataSnapshotFullRefresh"
             
  override val MandatoryFields = HashSet[Int](
    NoMDEntriesField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    InstrumentComponent.isMandatoryField(tagId) || MDEntriesGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    MDReqIDField.TagId, FinancialStatusField.TagId, CorporateActionField.TagId, TotalVolumeTradedField.TagId, TotalVolumeTradedDateField.TagId, 
    TotalVolumeTradedTimeField.TagId, NetChgPrevDayField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    InstrumentComponent.isOptionalField(tagId) || MDEntriesGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    InstrumentComponent.isFieldOf(tagId) || MDEntriesGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoMDEntriesField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==MDReqIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(MarketDataSnapshotFullRefreshMessage(myFields.get(MDReqIDField.TagId).flatMap(f=>MDReqIDField.decode(f)),
        InstrumentComponent.decode(flds, startPos).get,
        myFields.get(FinancialStatusField.TagId).flatMap(f=>FinancialStatusField.decode(f)),
        myFields.get(CorporateActionField.TagId).flatMap(f=>CorporateActionField.decode(f)),
        myFields.get(TotalVolumeTradedField.TagId).flatMap(f=>TotalVolumeTradedField.decode(f)),
        myFields.get(TotalVolumeTradedDateField.TagId).flatMap(f=>TotalVolumeTradedDateField.decode(f)),
        myFields.get(TotalVolumeTradedTimeField.TagId).flatMap(f=>TotalVolumeTradedTimeField.decode(f)),
        myFields.get(NetChgPrevDayField.TagId).flatMap(f=>NetChgPrevDayField.decode(f)),
        NoMDEntriesField.decode(myFields.get(NoMDEntriesField.TagId)).get,
        if (nextTagPosLookup.contains(NoMDEntriesField.TagId)) MDEntriesGroup.decode(flds, nextTagPosLookup(NoMDEntriesField.TagId)).get else List.empty))
    } else None
  }

    
}
     