package org.sackfix.fix44

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX44.xml
  */
case class TradeCaptureReportMessage(tradeReportIDField:TradeReportIDField,
                                     tradeReportTransTypeField:Option[TradeReportTransTypeField]=None,
                                     tradeReportTypeField:Option[TradeReportTypeField]=None,
                                     tradeRequestIDField:Option[TradeRequestIDField]=None,
                                     trdTypeField:Option[TrdTypeField]=None,
                                     trdSubTypeField:Option[TrdSubTypeField]=None,
                                     secondaryTrdTypeField:Option[SecondaryTrdTypeField]=None,
                                     transferReasonField:Option[TransferReasonField]=None,
                                     execTypeField:Option[ExecTypeField]=None,
                                     totNumTradeReportsField:Option[TotNumTradeReportsField]=None,
                                     lastRptRequestedField:Option[LastRptRequestedField]=None,
                                     unsolicitedIndicatorField:Option[UnsolicitedIndicatorField]=None,
                                     subscriptionRequestTypeField:Option[SubscriptionRequestTypeField]=None,
                                     tradeReportRefIDField:Option[TradeReportRefIDField]=None,
                                     secondaryTradeReportRefIDField:Option[SecondaryTradeReportRefIDField]=None,
                                     secondaryTradeReportIDField:Option[SecondaryTradeReportIDField]=None,
                                     tradeLinkIDField:Option[TradeLinkIDField]=None,
                                     trdMatchIDField:Option[TrdMatchIDField]=None,
                                     execIDField:Option[ExecIDField]=None,
                                     ordStatusField:Option[OrdStatusField]=None,
                                     secondaryExecIDField:Option[SecondaryExecIDField]=None,
                                     execRestatementReasonField:Option[ExecRestatementReasonField]=None,
                                     previouslyReportedField:PreviouslyReportedField,
                                     priceTypeField:Option[PriceTypeField]=None,
                                     instrumentComponent:InstrumentComponent,
                                     financingDetailsComponent:Option[FinancingDetailsComponent]=None,
                                     orderQtyDataComponent:Option[OrderQtyDataComponent]=None,
                                     qtyTypeField:Option[QtyTypeField]=None,
                                     yieldDataComponent:Option[YieldDataComponent]=None,
                                     noUnderlyingsField:Option[NoUnderlyingsField]=None,
                                     underlyingsGroups: Option[List[UnderlyingsGroup]]=None,
                                     underlyingTradingSessionIDField:Option[UnderlyingTradingSessionIDField]=None,
                                     underlyingTradingSessionSubIDField:Option[UnderlyingTradingSessionSubIDField]=None,
                                     lastQtyField:LastQtyField,
                                     lastPxField:LastPxField,
                                     lastParPxField:Option[LastParPxField]=None,
                                     lastSpotRateField:Option[LastSpotRateField]=None,
                                     lastForwardPointsField:Option[LastForwardPointsField]=None,
                                     lastMktField:Option[LastMktField]=None,
                                     tradeDateField:TradeDateField,
                                     clearingBusinessDateField:Option[ClearingBusinessDateField]=None,
                                     avgPxField:Option[AvgPxField]=None,
                                     spreadOrBenchmarkCurveDataComponent:Option[SpreadOrBenchmarkCurveDataComponent]=None,
                                     avgPxIndicatorField:Option[AvgPxIndicatorField]=None,
                                     positionAmountDataComponent:Option[PositionAmountDataComponent]=None,
                                     multiLegReportingTypeField:Option[MultiLegReportingTypeField]=None,
                                     tradeLegRefIDField:Option[TradeLegRefIDField]=None,
                                     noLegsField:Option[NoLegsField]=None,
                                     legsGroups: Option[List[LegsGroup]]=None,
                                     transactTimeField:TransactTimeField,
                                     trdRegTimestampsComponent:Option[TrdRegTimestampsComponent]=None,
                                     settlTypeField:Option[SettlTypeField]=None,
                                     settlDateField:Option[SettlDateField]=None,
                                     matchStatusField:Option[MatchStatusField]=None,
                                     matchTypeField:Option[MatchTypeField]=None,
                                     noSidesField:NoSidesField,
                                     sidesGroups: List[SidesGroup],
                                     copyMsgIndicatorField:Option[CopyMsgIndicatorField]=None,
                                     publishTrdIndicatorField:Option[PublishTrdIndicatorField]=None,
                                     shortSaleReasonField:Option[ShortSaleReasonField]=None) extends SfFixMessageBody("AE")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noUnderlyingsField.map(_.value).getOrElse(0) != underlyingsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoUnderlyingsField.TagId,noUnderlyingsField.map(_.value).getOrElse(0), underlyingsGroups.map(_.size).getOrElse(0))
  if (noLegsField.map(_.value).getOrElse(0) != legsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoLegsField.TagId,noLegsField.map(_.value).getOrElse(0), legsGroups.map(_.size).getOrElse(0))
  if (noSidesField.value != sidesGroups.size)
    throw SfRepeatingGroupCountException(NoSidesField.TagId,noSidesField.value, sidesGroups.size)

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,tradeReportIDField)
    tradeReportTransTypeField.foreach(fmt(b,_))
    tradeReportTypeField.foreach(fmt(b,_))
    tradeRequestIDField.foreach(fmt(b,_))
    trdTypeField.foreach(fmt(b,_))
    trdSubTypeField.foreach(fmt(b,_))
    secondaryTrdTypeField.foreach(fmt(b,_))
    transferReasonField.foreach(fmt(b,_))
    execTypeField.foreach(fmt(b,_))
    totNumTradeReportsField.foreach(fmt(b,_))
    lastRptRequestedField.foreach(fmt(b,_))
    unsolicitedIndicatorField.foreach(fmt(b,_))
    subscriptionRequestTypeField.foreach(fmt(b,_))
    tradeReportRefIDField.foreach(fmt(b,_))
    secondaryTradeReportRefIDField.foreach(fmt(b,_))
    secondaryTradeReportIDField.foreach(fmt(b,_))
    tradeLinkIDField.foreach(fmt(b,_))
    trdMatchIDField.foreach(fmt(b,_))
    execIDField.foreach(fmt(b,_))
    ordStatusField.foreach(fmt(b,_))
    secondaryExecIDField.foreach(fmt(b,_))
    execRestatementReasonField.foreach(fmt(b,_))
    fmt(b,previouslyReportedField)
    priceTypeField.foreach(fmt(b,_))
    fmt(b,instrumentComponent)
    financingDetailsComponent.foreach(fmt(b,_))
    orderQtyDataComponent.foreach(fmt(b,_))
    qtyTypeField.foreach(fmt(b,_))
    yieldDataComponent.foreach(fmt(b,_))
    noUnderlyingsField.foreach(fmt(b,_))
    underlyingsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    underlyingTradingSessionIDField.foreach(fmt(b,_))
    underlyingTradingSessionSubIDField.foreach(fmt(b,_))
    fmt(b,lastQtyField)
    fmt(b,lastPxField)
    lastParPxField.foreach(fmt(b,_))
    lastSpotRateField.foreach(fmt(b,_))
    lastForwardPointsField.foreach(fmt(b,_))
    lastMktField.foreach(fmt(b,_))
    fmt(b,tradeDateField)
    clearingBusinessDateField.foreach(fmt(b,_))
    avgPxField.foreach(fmt(b,_))
    spreadOrBenchmarkCurveDataComponent.foreach(fmt(b,_))
    avgPxIndicatorField.foreach(fmt(b,_))
    positionAmountDataComponent.foreach(fmt(b,_))
    multiLegReportingTypeField.foreach(fmt(b,_))
    tradeLegRefIDField.foreach(fmt(b,_))
    noLegsField.foreach(fmt(b,_))
    legsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    fmt(b,transactTimeField)
    trdRegTimestampsComponent.foreach(fmt(b,_))
    settlTypeField.foreach(fmt(b,_))
    settlDateField.foreach(fmt(b,_))
    matchStatusField.foreach(fmt(b,_))
    matchTypeField.foreach(fmt(b,_))
    fmt(b,noSidesField)
    copyMsgIndicatorField.foreach(fmt(b,_))
    publishTrdIndicatorField.foreach(fmt(b,_))
    shortSaleReasonField.foreach(fmt(b,_))
    b
  }

}
     
object TradeCaptureReportMessage extends SfFixMessageDecoder {
  val MsgType="AE"
  val MsgName="TradeCaptureReport"
             
  override val MandatoryFields = HashSet[Int](
    TradeReportIDField.TagId, PreviouslyReportedField.TagId, LastQtyField.TagId, LastPxField.TagId, TradeDateField.TagId, 
    TransactTimeField.TagId, NoSidesField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    InstrumentComponent.isMandatoryField(tagId) || FinancingDetailsComponent.isMandatoryField(tagId) || OrderQtyDataComponent.isMandatoryField(tagId) || YieldDataComponent.isMandatoryField(tagId) || 
    UnderlyingsGroup.isMandatoryField(tagId) || SpreadOrBenchmarkCurveDataComponent.isMandatoryField(tagId) || PositionAmountDataComponent.isMandatoryField(tagId) || LegsGroup.isMandatoryField(tagId) || 
    TrdRegTimestampsComponent.isMandatoryField(tagId) || SidesGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    TradeReportTransTypeField.TagId, TradeReportTypeField.TagId, TradeRequestIDField.TagId, TrdTypeField.TagId, TrdSubTypeField.TagId, 
    SecondaryTrdTypeField.TagId, TransferReasonField.TagId, ExecTypeField.TagId, TotNumTradeReportsField.TagId, LastRptRequestedField.TagId, 
    UnsolicitedIndicatorField.TagId, SubscriptionRequestTypeField.TagId, TradeReportRefIDField.TagId, SecondaryTradeReportRefIDField.TagId, SecondaryTradeReportIDField.TagId, 
    TradeLinkIDField.TagId, TrdMatchIDField.TagId, ExecIDField.TagId, OrdStatusField.TagId, SecondaryExecIDField.TagId, 
    ExecRestatementReasonField.TagId, PriceTypeField.TagId, QtyTypeField.TagId, NoUnderlyingsField.TagId, UnderlyingTradingSessionIDField.TagId, 
    UnderlyingTradingSessionSubIDField.TagId, LastParPxField.TagId, LastSpotRateField.TagId, LastForwardPointsField.TagId, LastMktField.TagId, 
    ClearingBusinessDateField.TagId, AvgPxField.TagId, AvgPxIndicatorField.TagId, MultiLegReportingTypeField.TagId, TradeLegRefIDField.TagId, 
    NoLegsField.TagId, SettlTypeField.TagId, SettlDateField.TagId, MatchStatusField.TagId, MatchTypeField.TagId, 
    CopyMsgIndicatorField.TagId, PublishTrdIndicatorField.TagId, ShortSaleReasonField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    InstrumentComponent.isOptionalField(tagId) || FinancingDetailsComponent.isOptionalField(tagId) || OrderQtyDataComponent.isOptionalField(tagId) || YieldDataComponent.isOptionalField(tagId) || 
    UnderlyingsGroup.isOptionalField(tagId) || SpreadOrBenchmarkCurveDataComponent.isOptionalField(tagId) || PositionAmountDataComponent.isOptionalField(tagId) || LegsGroup.isOptionalField(tagId) || 
    TrdRegTimestampsComponent.isOptionalField(tagId) || SidesGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    InstrumentComponent.isFieldOf(tagId) || FinancingDetailsComponent.isFieldOf(tagId) || OrderQtyDataComponent.isFieldOf(tagId) || 
    YieldDataComponent.isFieldOf(tagId) || UnderlyingsGroup.isFieldOf(tagId) || SpreadOrBenchmarkCurveDataComponent.isFieldOf(tagId) || 
    PositionAmountDataComponent.isFieldOf(tagId) || LegsGroup.isFieldOf(tagId) || TrdRegTimestampsComponent.isFieldOf(tagId) || 
    SidesGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoUnderlyingsField.TagId, NoLegsField.TagId, NoSidesField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==TradeReportIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(TradeCaptureReportMessage(TradeReportIDField.decode(myFields.get(TradeReportIDField.TagId)).get,
        myFields.get(TradeReportTransTypeField.TagId).flatMap(f=>TradeReportTransTypeField.decode(f)),
        myFields.get(TradeReportTypeField.TagId).flatMap(f=>TradeReportTypeField.decode(f)),
        myFields.get(TradeRequestIDField.TagId).flatMap(f=>TradeRequestIDField.decode(f)),
        myFields.get(TrdTypeField.TagId).flatMap(f=>TrdTypeField.decode(f)),
        myFields.get(TrdSubTypeField.TagId).flatMap(f=>TrdSubTypeField.decode(f)),
        myFields.get(SecondaryTrdTypeField.TagId).flatMap(f=>SecondaryTrdTypeField.decode(f)),
        myFields.get(TransferReasonField.TagId).flatMap(f=>TransferReasonField.decode(f)),
        myFields.get(ExecTypeField.TagId).flatMap(f=>ExecTypeField.decode(f)),
        myFields.get(TotNumTradeReportsField.TagId).flatMap(f=>TotNumTradeReportsField.decode(f)),
        myFields.get(LastRptRequestedField.TagId).flatMap(f=>LastRptRequestedField.decode(f)),
        myFields.get(UnsolicitedIndicatorField.TagId).flatMap(f=>UnsolicitedIndicatorField.decode(f)),
        myFields.get(SubscriptionRequestTypeField.TagId).flatMap(f=>SubscriptionRequestTypeField.decode(f)),
        myFields.get(TradeReportRefIDField.TagId).flatMap(f=>TradeReportRefIDField.decode(f)),
        myFields.get(SecondaryTradeReportRefIDField.TagId).flatMap(f=>SecondaryTradeReportRefIDField.decode(f)),
        myFields.get(SecondaryTradeReportIDField.TagId).flatMap(f=>SecondaryTradeReportIDField.decode(f)),
        myFields.get(TradeLinkIDField.TagId).flatMap(f=>TradeLinkIDField.decode(f)),
        myFields.get(TrdMatchIDField.TagId).flatMap(f=>TrdMatchIDField.decode(f)),
        myFields.get(ExecIDField.TagId).flatMap(f=>ExecIDField.decode(f)),
        myFields.get(OrdStatusField.TagId).flatMap(f=>OrdStatusField.decode(f)),
        myFields.get(SecondaryExecIDField.TagId).flatMap(f=>SecondaryExecIDField.decode(f)),
        myFields.get(ExecRestatementReasonField.TagId).flatMap(f=>ExecRestatementReasonField.decode(f)),
        PreviouslyReportedField.decode(myFields.get(PreviouslyReportedField.TagId)).get,
        myFields.get(PriceTypeField.TagId).flatMap(f=>PriceTypeField.decode(f)),
        InstrumentComponent.decode(flds, startPos).get,
        FinancingDetailsComponent.decode(flds, startPos),
        OrderQtyDataComponent.decode(flds, startPos),
        myFields.get(QtyTypeField.TagId).flatMap(f=>QtyTypeField.decode(f)),
        YieldDataComponent.decode(flds, startPos),
        myFields.get(NoUnderlyingsField.TagId).flatMap(f=>NoUnderlyingsField.decode(f)),
        if (nextTagPosLookup.contains(NoUnderlyingsField.TagId)) UnderlyingsGroup.decode(flds, nextTagPosLookup(NoUnderlyingsField.TagId)) else None,
        myFields.get(UnderlyingTradingSessionIDField.TagId).flatMap(f=>UnderlyingTradingSessionIDField.decode(f)),
        myFields.get(UnderlyingTradingSessionSubIDField.TagId).flatMap(f=>UnderlyingTradingSessionSubIDField.decode(f)),
        LastQtyField.decode(myFields.get(LastQtyField.TagId)).get,
        LastPxField.decode(myFields.get(LastPxField.TagId)).get,
        myFields.get(LastParPxField.TagId).flatMap(f=>LastParPxField.decode(f)),
        myFields.get(LastSpotRateField.TagId).flatMap(f=>LastSpotRateField.decode(f)),
        myFields.get(LastForwardPointsField.TagId).flatMap(f=>LastForwardPointsField.decode(f)),
        myFields.get(LastMktField.TagId).flatMap(f=>LastMktField.decode(f)),
        TradeDateField.decode(myFields.get(TradeDateField.TagId)).get,
        myFields.get(ClearingBusinessDateField.TagId).flatMap(f=>ClearingBusinessDateField.decode(f)),
        myFields.get(AvgPxField.TagId).flatMap(f=>AvgPxField.decode(f)),
        SpreadOrBenchmarkCurveDataComponent.decode(flds, startPos),
        myFields.get(AvgPxIndicatorField.TagId).flatMap(f=>AvgPxIndicatorField.decode(f)),
        PositionAmountDataComponent.decode(flds, startPos),
        myFields.get(MultiLegReportingTypeField.TagId).flatMap(f=>MultiLegReportingTypeField.decode(f)),
        myFields.get(TradeLegRefIDField.TagId).flatMap(f=>TradeLegRefIDField.decode(f)),
        myFields.get(NoLegsField.TagId).flatMap(f=>NoLegsField.decode(f)),
        if (nextTagPosLookup.contains(NoLegsField.TagId)) LegsGroup.decode(flds, nextTagPosLookup(NoLegsField.TagId)) else None,
        TransactTimeField.decode(myFields.get(TransactTimeField.TagId)).get,
        TrdRegTimestampsComponent.decode(flds, startPos),
        myFields.get(SettlTypeField.TagId).flatMap(f=>SettlTypeField.decode(f)),
        myFields.get(SettlDateField.TagId).flatMap(f=>SettlDateField.decode(f)),
        myFields.get(MatchStatusField.TagId).flatMap(f=>MatchStatusField.decode(f)),
        myFields.get(MatchTypeField.TagId).flatMap(f=>MatchTypeField.decode(f)),
        NoSidesField.decode(myFields.get(NoSidesField.TagId)).get,
        if (nextTagPosLookup.contains(NoSidesField.TagId)) SidesGroup.decode(flds, nextTagPosLookup(NoSidesField.TagId)).get else List.empty,
        myFields.get(CopyMsgIndicatorField.TagId).flatMap(f=>CopyMsgIndicatorField.decode(f)),
        myFields.get(PublishTrdIndicatorField.TagId).flatMap(f=>PublishTrdIndicatorField.decode(f)),
        myFields.get(ShortSaleReasonField.TagId).flatMap(f=>ShortSaleReasonField.decode(f))))
    } else None
  }

    
}
     