package org.sackfix.fix44

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX44.xml
  */
case class NetworkStatusResponseMessage(networkStatusResponseTypeField:NetworkStatusResponseTypeField,
                                        networkRequestIDField:Option[NetworkRequestIDField]=None,
                                        networkResponseIDField:Option[NetworkResponseIDField]=None,
                                        lastNetworkResponseIDField:Option[LastNetworkResponseIDField]=None,
                                        noCompIDsField:NoCompIDsField,
                                        compIDsGroups: List[CompIDsGroup]) extends SfFixMessageBody("BD")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noCompIDsField.value != compIDsGroups.size)
    throw SfRepeatingGroupCountException(NoCompIDsField.TagId,noCompIDsField.value, compIDsGroups.size)

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,networkStatusResponseTypeField)
    networkRequestIDField.foreach(fmt(b,_))
    networkResponseIDField.foreach(fmt(b,_))
    lastNetworkResponseIDField.foreach(fmt(b,_))
    fmt(b,noCompIDsField)
    b
  }

}
     
object NetworkStatusResponseMessage extends SfFixMessageDecoder {
  val MsgType="BD"
  val MsgName="NetworkStatusResponse"
             
  override val MandatoryFields = HashSet[Int](
    NetworkStatusResponseTypeField.TagId, NoCompIDsField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    CompIDsGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    NetworkRequestIDField.TagId, NetworkResponseIDField.TagId, LastNetworkResponseIDField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    CompIDsGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    CompIDsGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoCompIDsField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==NetworkStatusResponseTypeField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(NetworkStatusResponseMessage(NetworkStatusResponseTypeField.decode(myFields.get(NetworkStatusResponseTypeField.TagId)).get,
        myFields.get(NetworkRequestIDField.TagId).flatMap(f=>NetworkRequestIDField.decode(f)),
        myFields.get(NetworkResponseIDField.TagId).flatMap(f=>NetworkResponseIDField.decode(f)),
        myFields.get(LastNetworkResponseIDField.TagId).flatMap(f=>LastNetworkResponseIDField.decode(f)),
        NoCompIDsField.decode(myFields.get(NoCompIDsField.TagId)).get,
        if (nextTagPosLookup.contains(NoCompIDsField.TagId)) CompIDsGroup.decode(flds, nextTagPosLookup(NoCompIDsField.TagId)).get else List.empty))
    } else None
  }

    
}
     