package org.sackfix.fix44

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX44.xml
  */
case class RequestForPositionsAckMessage(posMaintRptIDField:PosMaintRptIDField,
                                         posReqIDField:Option[PosReqIDField]=None,
                                         totalNumPosReportsField:Option[TotalNumPosReportsField]=None,
                                         unsolicitedIndicatorField:Option[UnsolicitedIndicatorField]=None,
                                         posReqResultField:PosReqResultField,
                                         posReqStatusField:PosReqStatusField,
                                         partiesComponent:PartiesComponent,
                                         accountField:AccountField,
                                         acctIDSourceField:Option[AcctIDSourceField]=None,
                                         accountTypeField:AccountTypeField,
                                         instrumentComponent:Option[InstrumentComponent]=None,
                                         currencyField:Option[CurrencyField]=None,
                                         noLegsField:Option[NoLegsField]=None,
                                         legsGroups: Option[List[LegsGroup]]=None,
                                         noUnderlyingsField:Option[NoUnderlyingsField]=None,
                                         underlyingsGroups: Option[List[UnderlyingsGroup]]=None,
                                         responseTransportTypeField:Option[ResponseTransportTypeField]=None,
                                         responseDestinationField:Option[ResponseDestinationField]=None,
                                         textField:Option[TextField]=None,
                                         encodedTextLenField:Option[EncodedTextLenField]=None,
                                         encodedTextField:Option[EncodedTextField]=None) extends SfFixMessageBody("AO")  with SfFixRenderable with SfFixFieldsToAscii {
  if (noLegsField.map(_.value).getOrElse(0) != legsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoLegsField.TagId,noLegsField.map(_.value).getOrElse(0), legsGroups.map(_.size).getOrElse(0))
  if (noUnderlyingsField.map(_.value).getOrElse(0) != underlyingsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoUnderlyingsField.TagId,noUnderlyingsField.map(_.value).getOrElse(0), underlyingsGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,posMaintRptIDField)
    posReqIDField.foreach(fmt(b,_))
    totalNumPosReportsField.foreach(fmt(b,_))
    unsolicitedIndicatorField.foreach(fmt(b,_))
    fmt(b,posReqResultField)
    fmt(b,posReqStatusField)
    fmt(b,partiesComponent)
    fmt(b,accountField)
    acctIDSourceField.foreach(fmt(b,_))
    fmt(b,accountTypeField)
    instrumentComponent.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    noLegsField.foreach(fmt(b,_))
    legsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    noUnderlyingsField.foreach(fmt(b,_))
    underlyingsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    responseTransportTypeField.foreach(fmt(b,_))
    responseDestinationField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    encodedTextLenField.foreach(fmt(b,_))
    encodedTextField.foreach(fmt(b,_))
    b
  }

}
     
object RequestForPositionsAckMessage extends SfFixMessageDecoder {
  val MsgType="AO"
  val MsgName="RequestForPositionsAck"
             
  override val MandatoryFields = HashSet[Int](
    PosMaintRptIDField.TagId, PosReqResultField.TagId, PosReqStatusField.TagId, AccountField.TagId, AccountTypeField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    PartiesComponent.isMandatoryField(tagId) || InstrumentComponent.isMandatoryField(tagId) || LegsGroup.isMandatoryField(tagId) || UnderlyingsGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    PosReqIDField.TagId, TotalNumPosReportsField.TagId, UnsolicitedIndicatorField.TagId, AcctIDSourceField.TagId, CurrencyField.TagId, 
    NoLegsField.TagId, NoUnderlyingsField.TagId, ResponseTransportTypeField.TagId, ResponseDestinationField.TagId, TextField.TagId, 
    EncodedTextLenField.TagId, EncodedTextField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    PartiesComponent.isOptionalField(tagId) || InstrumentComponent.isOptionalField(tagId) || LegsGroup.isOptionalField(tagId) || UnderlyingsGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    PartiesComponent.isFieldOf(tagId) || InstrumentComponent.isFieldOf(tagId) || LegsGroup.isFieldOf(tagId) || 
    UnderlyingsGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoLegsField.TagId, NoUnderlyingsField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==PosMaintRptIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(RequestForPositionsAckMessage(PosMaintRptIDField.decode(myFields.get(PosMaintRptIDField.TagId)).get,
        myFields.get(PosReqIDField.TagId).flatMap(f=>PosReqIDField.decode(f)),
        myFields.get(TotalNumPosReportsField.TagId).flatMap(f=>TotalNumPosReportsField.decode(f)),
        myFields.get(UnsolicitedIndicatorField.TagId).flatMap(f=>UnsolicitedIndicatorField.decode(f)),
        PosReqResultField.decode(myFields.get(PosReqResultField.TagId)).get,
        PosReqStatusField.decode(myFields.get(PosReqStatusField.TagId)).get,
        PartiesComponent.decode(flds, startPos).get,
        AccountField.decode(myFields.get(AccountField.TagId)).get,
        myFields.get(AcctIDSourceField.TagId).flatMap(f=>AcctIDSourceField.decode(f)),
        AccountTypeField.decode(myFields.get(AccountTypeField.TagId)).get,
        InstrumentComponent.decode(flds, startPos),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(NoLegsField.TagId).flatMap(f=>NoLegsField.decode(f)),
        if (nextTagPosLookup.contains(NoLegsField.TagId)) LegsGroup.decode(flds, nextTagPosLookup(NoLegsField.TagId)) else None,
        myFields.get(NoUnderlyingsField.TagId).flatMap(f=>NoUnderlyingsField.decode(f)),
        if (nextTagPosLookup.contains(NoUnderlyingsField.TagId)) UnderlyingsGroup.decode(flds, nextTagPosLookup(NoUnderlyingsField.TagId)) else None,
        myFields.get(ResponseTransportTypeField.TagId).flatMap(f=>ResponseTransportTypeField.decode(f)),
        myFields.get(ResponseDestinationField.TagId).flatMap(f=>ResponseDestinationField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(EncodedTextLenField.TagId).flatMap(f=>EncodedTextLenField.decode(f)),
        myFields.get(EncodedTextField.TagId).flatMap(f=>EncodedTextField.decode(f))))
    } else None
  }

    
}
     