package org.sackfix.fix50

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50.xml
  */
case class MassQuoteAcknowledgementMessage(quoteReqIDField:Option[QuoteReqIDField]=None,
                                           quoteIDField:Option[QuoteIDField]=None,
                                           quoteStatusField:QuoteStatusField,
                                           quoteRejectReasonField:Option[QuoteRejectReasonField]=None,
                                           quoteResponseLevelField:Option[QuoteResponseLevelField]=None,
                                           quoteTypeField:Option[QuoteTypeField]=None,
                                           partiesComponent:Option[PartiesComponent]=None,
                                           accountField:Option[AccountField]=None,
                                           acctIDSourceField:Option[AcctIDSourceField]=None,
                                           accountTypeField:Option[AccountTypeField]=None,
                                           textField:Option[TextField]=None,
                                           encodedTextLenField:Option[EncodedTextLenField]=None,
                                           encodedTextField:Option[EncodedTextField]=None,
                                           quotSetAckGrpComponent:Option[QuotSetAckGrpComponent]=None) extends SfFixMessageBody("b")  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    quoteReqIDField.foreach(fmt(b,_))
    quoteIDField.foreach(fmt(b,_))
    fmt(b,quoteStatusField)
    quoteRejectReasonField.foreach(fmt(b,_))
    quoteResponseLevelField.foreach(fmt(b,_))
    quoteTypeField.foreach(fmt(b,_))
    partiesComponent.foreach(fmt(b,_))
    accountField.foreach(fmt(b,_))
    acctIDSourceField.foreach(fmt(b,_))
    accountTypeField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    encodedTextLenField.foreach(fmt(b,_))
    encodedTextField.foreach(fmt(b,_))
    quotSetAckGrpComponent.foreach(fmt(b,_))
    b
  }

}
     
object MassQuoteAcknowledgementMessage extends SfFixMessageDecoder {
  val MsgType="b"
  val MsgName="MassQuoteAcknowledgement"
             
  override val MandatoryFields = HashSet[Int](
    QuoteStatusField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    PartiesComponent.isMandatoryField(tagId) || QuotSetAckGrpComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    QuoteReqIDField.TagId, QuoteIDField.TagId, QuoteRejectReasonField.TagId, QuoteResponseLevelField.TagId, QuoteTypeField.TagId, 
    AccountField.TagId, AcctIDSourceField.TagId, AccountTypeField.TagId, TextField.TagId, EncodedTextLenField.TagId, 
    EncodedTextField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    PartiesComponent.isOptionalField(tagId) || QuotSetAckGrpComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    PartiesComponent.isFieldOf(tagId) || QuotSetAckGrpComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==QuoteReqIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(MassQuoteAcknowledgementMessage(myFields.get(QuoteReqIDField.TagId).flatMap(f=>QuoteReqIDField.decode(f)),
        myFields.get(QuoteIDField.TagId).flatMap(f=>QuoteIDField.decode(f)),
        QuoteStatusField.decode(myFields.get(QuoteStatusField.TagId)).get,
        myFields.get(QuoteRejectReasonField.TagId).flatMap(f=>QuoteRejectReasonField.decode(f)),
        myFields.get(QuoteResponseLevelField.TagId).flatMap(f=>QuoteResponseLevelField.decode(f)),
        myFields.get(QuoteTypeField.TagId).flatMap(f=>QuoteTypeField.decode(f)),
        PartiesComponent.decode(flds, startPos),
        myFields.get(AccountField.TagId).flatMap(f=>AccountField.decode(f)),
        myFields.get(AcctIDSourceField.TagId).flatMap(f=>AcctIDSourceField.decode(f)),
        myFields.get(AccountTypeField.TagId).flatMap(f=>AccountTypeField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(EncodedTextLenField.TagId).flatMap(f=>EncodedTextLenField.decode(f)),
        myFields.get(EncodedTextField.TagId).flatMap(f=>EncodedTextField.decode(f)),
        QuotSetAckGrpComponent.decode(flds, startPos)))
    } else None
  }

    
}
     