package org.sackfix.fix50

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixGroup, SfGroupDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50.xml
  */
case class RelatedSymGroup(instrumentComponent:Option[InstrumentComponent]=None,
                           instrumentExtensionComponent:Option[InstrumentExtensionComponent]=None,
                           financingDetailsComponent:Option[FinancingDetailsComponent]=None,
                           secLstUpdRelSymsLegGrpComponent:Option[SecLstUpdRelSymsLegGrpComponent]=None,
                           spreadOrBenchmarkCurveDataComponent:Option[SpreadOrBenchmarkCurveDataComponent]=None,
                           yieldDataComponent:Option[YieldDataComponent]=None,
                           roundLotField:Option[RoundLotField]=None,
                           minTradeVolField:Option[MinTradeVolField]=None,
                           tradingSessionIDField:Option[TradingSessionIDField]=None,
                           tradingSessionSubIDField:Option[TradingSessionSubIDField]=None,
                           expirationCycleField:Option[ExpirationCycleField]=None,
                           textField:Option[TextField]=None,
                           encodedTextLenField:Option[EncodedTextLenField]=None,
                           encodedTextField:Option[EncodedTextField]=None,
                           underlyingInstrumentComponent:Option[UnderlyingInstrumentComponent]=None,
                           currencyField:Option[CurrencyField]=None,
                           stipulationsComponent:Option[StipulationsComponent]=None) extends SfFixGroup  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    instrumentComponent.foreach(fmt(b,_))
    instrumentExtensionComponent.foreach(fmt(b,_))
    financingDetailsComponent.foreach(fmt(b,_))
    secLstUpdRelSymsLegGrpComponent.foreach(fmt(b,_))
    spreadOrBenchmarkCurveDataComponent.foreach(fmt(b,_))
    yieldDataComponent.foreach(fmt(b,_))
    roundLotField.foreach(fmt(b,_))
    minTradeVolField.foreach(fmt(b,_))
    tradingSessionIDField.foreach(fmt(b,_))
    tradingSessionSubIDField.foreach(fmt(b,_))
    expirationCycleField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    encodedTextLenField.foreach(fmt(b,_))
    encodedTextField.foreach(fmt(b,_))
    underlyingInstrumentComponent.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    stipulationsComponent.foreach(fmt(b,_))
    b
  }

}
     
object RelatedSymGroup extends SfGroupDecoder {

  override val MandatoryFields = HashSet[Int]()

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    InstrumentComponent.isMandatoryField(tagId) || InstrumentExtensionComponent.isMandatoryField(tagId) || FinancingDetailsComponent.isMandatoryField(tagId) || SecLstUpdRelSymsLegGrpComponent.isMandatoryField(tagId) || 
    SpreadOrBenchmarkCurveDataComponent.isMandatoryField(tagId) || YieldDataComponent.isMandatoryField(tagId) || UnderlyingInstrumentComponent.isMandatoryField(tagId) || StipulationsComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    RoundLotField.TagId, MinTradeVolField.TagId, TradingSessionIDField.TagId, TradingSessionSubIDField.TagId, ExpirationCycleField.TagId, 
    TextField.TagId, EncodedTextLenField.TagId, EncodedTextField.TagId, CurrencyField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    InstrumentComponent.isOptionalField(tagId) || InstrumentExtensionComponent.isOptionalField(tagId) || FinancingDetailsComponent.isOptionalField(tagId) || SecLstUpdRelSymsLegGrpComponent.isOptionalField(tagId) || 
    SpreadOrBenchmarkCurveDataComponent.isOptionalField(tagId) || YieldDataComponent.isOptionalField(tagId) || UnderlyingInstrumentComponent.isOptionalField(tagId) || StipulationsComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    InstrumentComponent.isFieldOf(tagId) || InstrumentExtensionComponent.isFieldOf(tagId) || FinancingDetailsComponent.isFieldOf(tagId) || 
    SecLstUpdRelSymsLegGrpComponent.isFieldOf(tagId) || SpreadOrBenchmarkCurveDataComponent.isFieldOf(tagId) || YieldDataComponent.isFieldOf(tagId) || 
    UnderlyingInstrumentComponent.isFieldOf(tagId) || StipulationsComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = InstrumentComponent.isFirstField(tagId) 

  // Group version, startPos is the index to the first element of the first repeating group
  @tailrec
  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0, groups:ArrayBuffer[RelatedSymGroup]=ArrayBuffer.empty[RelatedSymGroup]):Option[List[RelatedSymGroup]] = {
    decodeSingle(flds, startPos) match {
      case (pos: Int, None) => if (groups.nonEmpty) Some(groups.toList) else None
      case (pos: Int, grp: Some[RelatedSymGroup]) => decode(flds, pos, groups += grp.get)
    }
  }

  /**
    * @param flds For groups in Fix ordering is VITAL.
    * @param startPos This index into the ordered fields. It HAS to contain the first field of the group
    * @return A Tuple2 holding the next position to read from the fields, and the newly created group
    */
  def decodeSingle(flds: Seq[Tuple2[Int, Any]], startPos:Int):Tuple2[Int,Option[RelatedSymGroup]] = {
    if (!isFirstField(flds(startPos)._1)) (startPos, None)
    else {
      val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(true, flds, startPos)
      validateMandatoryFieldsPresent(myFields)

      if (myFields.nonEmpty) {
        (pos,Some(RelatedSymGroup(InstrumentComponent.decode(flds, startPos),
          InstrumentExtensionComponent.decode(flds, startPos),
          FinancingDetailsComponent.decode(flds, startPos),
          SecLstUpdRelSymsLegGrpComponent.decode(flds, startPos),
          SpreadOrBenchmarkCurveDataComponent.decode(flds, startPos),
          YieldDataComponent.decode(flds, startPos),
          myFields.get(RoundLotField.TagId).flatMap(f=>RoundLotField.decode(f)),
          myFields.get(MinTradeVolField.TagId).flatMap(f=>MinTradeVolField.decode(f)),
          myFields.get(TradingSessionIDField.TagId).flatMap(f=>TradingSessionIDField.decode(f)),
          myFields.get(TradingSessionSubIDField.TagId).flatMap(f=>TradingSessionSubIDField.decode(f)),
          myFields.get(ExpirationCycleField.TagId).flatMap(f=>ExpirationCycleField.decode(f)),
          myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
          myFields.get(EncodedTextLenField.TagId).flatMap(f=>EncodedTextLenField.decode(f)),
          myFields.get(EncodedTextField.TagId).flatMap(f=>EncodedTextField.decode(f)),
          UnderlyingInstrumentComponent.decode(flds, startPos),
          myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
          StipulationsComponent.decode(flds, startPos))))
      } else (startPos, None)
    }
  }
    
}
     