package org.sackfix.fix50

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixGroup, SfGroupDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20210314
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50.xml
  */
case class SidesGroup(sideField:SideField,
                      orderIDField:Option[OrderIDField]=None,
                      secondaryOrderIDField:Option[SecondaryOrderIDField]=None,
                      clOrdIDField:Option[ClOrdIDField]=None,
                      secondaryClOrdIDField:Option[SecondaryClOrdIDField]=None,
                      listIDField:Option[ListIDField]=None,
                      partiesComponent:Option[PartiesComponent]=None,
                      accountField:Option[AccountField]=None,
                      acctIDSourceField:Option[AcctIDSourceField]=None,
                      accountTypeField:Option[AccountTypeField]=None,
                      processCodeField:Option[ProcessCodeField]=None,
                      oddLotField:Option[OddLotField]=None,
                      clrInstGrpComponent:Option[ClrInstGrpComponent]=None,
                      tradeInputSourceField:Option[TradeInputSourceField]=None,
                      tradeInputDeviceField:Option[TradeInputDeviceField]=None,
                      orderInputDeviceField:Option[OrderInputDeviceField]=None,
                      currencyField:Option[CurrencyField]=None,
                      complianceIDField:Option[ComplianceIDField]=None,
                      solicitedFlagField:Option[SolicitedFlagField]=None,
                      orderCapacityField:Option[OrderCapacityField]=None,
                      orderRestrictionsField:Option[OrderRestrictionsField]=None,
                      custOrderCapacityField:Option[CustOrderCapacityField]=None,
                      ordTypeField:Option[OrdTypeField]=None,
                      execInstField:Option[ExecInstField]=None,
                      transBkdTimeField:Option[TransBkdTimeField]=None,
                      tradingSessionIDField:Option[TradingSessionIDField]=None,
                      tradingSessionSubIDField:Option[TradingSessionSubIDField]=None,
                      timeBracketField:Option[TimeBracketField]=None,
                      commissionDataComponent:Option[CommissionDataComponent]=None,
                      numDaysInterestField:Option[NumDaysInterestField]=None,
                      exDateField:Option[ExDateField]=None,
                      accruedInterestRateField:Option[AccruedInterestRateField]=None,
                      accruedInterestAmtField:Option[AccruedInterestAmtField]=None,
                      interestAtMaturityField:Option[InterestAtMaturityField]=None,
                      endAccruedInterestAmtField:Option[EndAccruedInterestAmtField]=None,
                      startCashField:Option[StartCashField]=None,
                      endCashField:Option[EndCashField]=None,
                      concessionField:Option[ConcessionField]=None,
                      totalTakedownField:Option[TotalTakedownField]=None,
                      netMoneyField:Option[NetMoneyField]=None,
                      settlCurrAmtField:Option[SettlCurrAmtField]=None,
                      settlCurrencyField:Option[SettlCurrencyField]=None,
                      settlCurrFxRateField:Option[SettlCurrFxRateField]=None,
                      settlCurrFxRateCalcField:Option[SettlCurrFxRateCalcField]=None,
                      positionEffectField:Option[PositionEffectField]=None,
                      sideMultiLegReportingTypeField:Option[SideMultiLegReportingTypeField]=None,
                      contAmtGrpComponent:Option[ContAmtGrpComponent]=None,
                      stipulationsComponent:Option[StipulationsComponent]=None,
                      miscFeesGrpComponent:Option[MiscFeesGrpComponent]=None,
                      exchangeRuleField:Option[ExchangeRuleField]=None,
                      tradeAllocIndicatorField:Option[TradeAllocIndicatorField]=None,
                      preallocMethodField:Option[PreallocMethodField]=None,
                      allocIDField:Option[AllocIDField]=None,
                      trdAllocGrpComponent:Option[TrdAllocGrpComponent]=None,
                      lotTypeField:Option[LotTypeField]=None,
                      sideGrossTradeAmtField:Option[SideGrossTradeAmtField]=None,
                      aggressorIndicatorField:Option[AggressorIndicatorField]=None,
                      sideQtyField:Option[SideQtyField]=None,
                      sideTradeReportIDField:Option[SideTradeReportIDField]=None,
                      sideFillStationCdField:Option[SideFillStationCdField]=None,
                      sideReasonCdField:Option[SideReasonCdField]=None,
                      rptSeqField:Option[RptSeqField]=None,
                      sideTrdSubTypField:Option[SideTrdSubTypField]=None,
                      sideTrdRegTSComponent:Option[SideTrdRegTSComponent]=None) extends SfFixGroup  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,sideField)
    orderIDField.foreach(fmt(b,_))
    secondaryOrderIDField.foreach(fmt(b,_))
    clOrdIDField.foreach(fmt(b,_))
    secondaryClOrdIDField.foreach(fmt(b,_))
    listIDField.foreach(fmt(b,_))
    partiesComponent.foreach(fmt(b,_))
    accountField.foreach(fmt(b,_))
    acctIDSourceField.foreach(fmt(b,_))
    accountTypeField.foreach(fmt(b,_))
    processCodeField.foreach(fmt(b,_))
    oddLotField.foreach(fmt(b,_))
    clrInstGrpComponent.foreach(fmt(b,_))
    tradeInputSourceField.foreach(fmt(b,_))
    tradeInputDeviceField.foreach(fmt(b,_))
    orderInputDeviceField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    complianceIDField.foreach(fmt(b,_))
    solicitedFlagField.foreach(fmt(b,_))
    orderCapacityField.foreach(fmt(b,_))
    orderRestrictionsField.foreach(fmt(b,_))
    custOrderCapacityField.foreach(fmt(b,_))
    ordTypeField.foreach(fmt(b,_))
    execInstField.foreach(fmt(b,_))
    transBkdTimeField.foreach(fmt(b,_))
    tradingSessionIDField.foreach(fmt(b,_))
    tradingSessionSubIDField.foreach(fmt(b,_))
    timeBracketField.foreach(fmt(b,_))
    commissionDataComponent.foreach(fmt(b,_))
    numDaysInterestField.foreach(fmt(b,_))
    exDateField.foreach(fmt(b,_))
    accruedInterestRateField.foreach(fmt(b,_))
    accruedInterestAmtField.foreach(fmt(b,_))
    interestAtMaturityField.foreach(fmt(b,_))
    endAccruedInterestAmtField.foreach(fmt(b,_))
    startCashField.foreach(fmt(b,_))
    endCashField.foreach(fmt(b,_))
    concessionField.foreach(fmt(b,_))
    totalTakedownField.foreach(fmt(b,_))
    netMoneyField.foreach(fmt(b,_))
    settlCurrAmtField.foreach(fmt(b,_))
    settlCurrencyField.foreach(fmt(b,_))
    settlCurrFxRateField.foreach(fmt(b,_))
    settlCurrFxRateCalcField.foreach(fmt(b,_))
    positionEffectField.foreach(fmt(b,_))
    sideMultiLegReportingTypeField.foreach(fmt(b,_))
    contAmtGrpComponent.foreach(fmt(b,_))
    stipulationsComponent.foreach(fmt(b,_))
    miscFeesGrpComponent.foreach(fmt(b,_))
    exchangeRuleField.foreach(fmt(b,_))
    tradeAllocIndicatorField.foreach(fmt(b,_))
    preallocMethodField.foreach(fmt(b,_))
    allocIDField.foreach(fmt(b,_))
    trdAllocGrpComponent.foreach(fmt(b,_))
    lotTypeField.foreach(fmt(b,_))
    sideGrossTradeAmtField.foreach(fmt(b,_))
    aggressorIndicatorField.foreach(fmt(b,_))
    sideQtyField.foreach(fmt(b,_))
    sideTradeReportIDField.foreach(fmt(b,_))
    sideFillStationCdField.foreach(fmt(b,_))
    sideReasonCdField.foreach(fmt(b,_))
    rptSeqField.foreach(fmt(b,_))
    sideTrdSubTypField.foreach(fmt(b,_))
    sideTrdRegTSComponent.foreach(fmt(b,_))
    b
  }

}
     
object SidesGroup extends SfGroupDecoder {

  override val MandatoryFields = HashSet[Int](
    SideField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    PartiesComponent.isMandatoryField(tagId) || ClrInstGrpComponent.isMandatoryField(tagId) || CommissionDataComponent.isMandatoryField(tagId) || ContAmtGrpComponent.isMandatoryField(tagId) || 
    StipulationsComponent.isMandatoryField(tagId) || MiscFeesGrpComponent.isMandatoryField(tagId) || TrdAllocGrpComponent.isMandatoryField(tagId) || SideTrdRegTSComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    OrderIDField.TagId, SecondaryOrderIDField.TagId, ClOrdIDField.TagId, SecondaryClOrdIDField.TagId, ListIDField.TagId, 
    AccountField.TagId, AcctIDSourceField.TagId, AccountTypeField.TagId, ProcessCodeField.TagId, OddLotField.TagId, 
    TradeInputSourceField.TagId, TradeInputDeviceField.TagId, OrderInputDeviceField.TagId, CurrencyField.TagId, ComplianceIDField.TagId, 
    SolicitedFlagField.TagId, OrderCapacityField.TagId, OrderRestrictionsField.TagId, CustOrderCapacityField.TagId, OrdTypeField.TagId, 
    ExecInstField.TagId, TransBkdTimeField.TagId, TradingSessionIDField.TagId, TradingSessionSubIDField.TagId, TimeBracketField.TagId, 
    NumDaysInterestField.TagId, ExDateField.TagId, AccruedInterestRateField.TagId, AccruedInterestAmtField.TagId, InterestAtMaturityField.TagId, 
    EndAccruedInterestAmtField.TagId, StartCashField.TagId, EndCashField.TagId, ConcessionField.TagId, TotalTakedownField.TagId, 
    NetMoneyField.TagId, SettlCurrAmtField.TagId, SettlCurrencyField.TagId, SettlCurrFxRateField.TagId, SettlCurrFxRateCalcField.TagId, 
    PositionEffectField.TagId, SideMultiLegReportingTypeField.TagId, ExchangeRuleField.TagId, TradeAllocIndicatorField.TagId, PreallocMethodField.TagId, 
    AllocIDField.TagId, LotTypeField.TagId, SideGrossTradeAmtField.TagId, AggressorIndicatorField.TagId, SideQtyField.TagId, 
    SideTradeReportIDField.TagId, SideFillStationCdField.TagId, SideReasonCdField.TagId, RptSeqField.TagId, SideTrdSubTypField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    PartiesComponent.isOptionalField(tagId) || ClrInstGrpComponent.isOptionalField(tagId) || CommissionDataComponent.isOptionalField(tagId) || ContAmtGrpComponent.isOptionalField(tagId) || 
    StipulationsComponent.isOptionalField(tagId) || MiscFeesGrpComponent.isOptionalField(tagId) || TrdAllocGrpComponent.isOptionalField(tagId) || SideTrdRegTSComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    PartiesComponent.isFieldOf(tagId) || ClrInstGrpComponent.isFieldOf(tagId) || CommissionDataComponent.isFieldOf(tagId) || 
    ContAmtGrpComponent.isFieldOf(tagId) || StipulationsComponent.isFieldOf(tagId) || MiscFeesGrpComponent.isFieldOf(tagId) || 
    TrdAllocGrpComponent.isFieldOf(tagId) || SideTrdRegTSComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==SideField.TagId 

  // Group version, startPos is the index to the first element of the first repeating group
  @tailrec
  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0, groups:ArrayBuffer[SidesGroup]=ArrayBuffer.empty[SidesGroup]):Option[List[SidesGroup]] = {
    decodeSingle(flds, startPos) match {
      case (pos: Int, None) => if (groups.nonEmpty) Some(groups.toList) else None
      case (pos: Int, grp: Some[SidesGroup]) => decode(flds, pos, groups += grp.get)
    }
  }

  /**
    * @param flds For groups in Fix ordering is VITAL.
    * @param startPos This index into the ordered fields. It HAS to contain the first field of the group
    * @return A Tuple2 holding the next position to read from the fields, and the newly created group
    */
  def decodeSingle(flds: Seq[Tuple2[Int, Any]], startPos:Int):Tuple2[Int,Option[SidesGroup]] = {
    if (!isFirstField(flds(startPos)._1)) (startPos, None)
    else {
      val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(true, flds, startPos)
      validateMandatoryFieldsPresent(myFields)

      if (myFields.nonEmpty) {
        (pos,Some(SidesGroup(SideField.decode(myFields.get(SideField.TagId)).get,
          myFields.get(OrderIDField.TagId).flatMap(f=>OrderIDField.decode(f)),
          myFields.get(SecondaryOrderIDField.TagId).flatMap(f=>SecondaryOrderIDField.decode(f)),
          myFields.get(ClOrdIDField.TagId).flatMap(f=>ClOrdIDField.decode(f)),
          myFields.get(SecondaryClOrdIDField.TagId).flatMap(f=>SecondaryClOrdIDField.decode(f)),
          myFields.get(ListIDField.TagId).flatMap(f=>ListIDField.decode(f)),
          PartiesComponent.decode(flds, startPos),
          myFields.get(AccountField.TagId).flatMap(f=>AccountField.decode(f)),
          myFields.get(AcctIDSourceField.TagId).flatMap(f=>AcctIDSourceField.decode(f)),
          myFields.get(AccountTypeField.TagId).flatMap(f=>AccountTypeField.decode(f)),
          myFields.get(ProcessCodeField.TagId).flatMap(f=>ProcessCodeField.decode(f)),
          myFields.get(OddLotField.TagId).flatMap(f=>OddLotField.decode(f)),
          ClrInstGrpComponent.decode(flds, startPos),
          myFields.get(TradeInputSourceField.TagId).flatMap(f=>TradeInputSourceField.decode(f)),
          myFields.get(TradeInputDeviceField.TagId).flatMap(f=>TradeInputDeviceField.decode(f)),
          myFields.get(OrderInputDeviceField.TagId).flatMap(f=>OrderInputDeviceField.decode(f)),
          myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
          myFields.get(ComplianceIDField.TagId).flatMap(f=>ComplianceIDField.decode(f)),
          myFields.get(SolicitedFlagField.TagId).flatMap(f=>SolicitedFlagField.decode(f)),
          myFields.get(OrderCapacityField.TagId).flatMap(f=>OrderCapacityField.decode(f)),
          myFields.get(OrderRestrictionsField.TagId).flatMap(f=>OrderRestrictionsField.decode(f)),
          myFields.get(CustOrderCapacityField.TagId).flatMap(f=>CustOrderCapacityField.decode(f)),
          myFields.get(OrdTypeField.TagId).flatMap(f=>OrdTypeField.decode(f)),
          myFields.get(ExecInstField.TagId).flatMap(f=>ExecInstField.decode(f)),
          myFields.get(TransBkdTimeField.TagId).flatMap(f=>TransBkdTimeField.decode(f)),
          myFields.get(TradingSessionIDField.TagId).flatMap(f=>TradingSessionIDField.decode(f)),
          myFields.get(TradingSessionSubIDField.TagId).flatMap(f=>TradingSessionSubIDField.decode(f)),
          myFields.get(TimeBracketField.TagId).flatMap(f=>TimeBracketField.decode(f)),
          CommissionDataComponent.decode(flds, startPos),
          myFields.get(NumDaysInterestField.TagId).flatMap(f=>NumDaysInterestField.decode(f)),
          myFields.get(ExDateField.TagId).flatMap(f=>ExDateField.decode(f)),
          myFields.get(AccruedInterestRateField.TagId).flatMap(f=>AccruedInterestRateField.decode(f)),
          myFields.get(AccruedInterestAmtField.TagId).flatMap(f=>AccruedInterestAmtField.decode(f)),
          myFields.get(InterestAtMaturityField.TagId).flatMap(f=>InterestAtMaturityField.decode(f)),
          myFields.get(EndAccruedInterestAmtField.TagId).flatMap(f=>EndAccruedInterestAmtField.decode(f)),
          myFields.get(StartCashField.TagId).flatMap(f=>StartCashField.decode(f)),
          myFields.get(EndCashField.TagId).flatMap(f=>EndCashField.decode(f)),
          myFields.get(ConcessionField.TagId).flatMap(f=>ConcessionField.decode(f)),
          myFields.get(TotalTakedownField.TagId).flatMap(f=>TotalTakedownField.decode(f)),
          myFields.get(NetMoneyField.TagId).flatMap(f=>NetMoneyField.decode(f)),
          myFields.get(SettlCurrAmtField.TagId).flatMap(f=>SettlCurrAmtField.decode(f)),
          myFields.get(SettlCurrencyField.TagId).flatMap(f=>SettlCurrencyField.decode(f)),
          myFields.get(SettlCurrFxRateField.TagId).flatMap(f=>SettlCurrFxRateField.decode(f)),
          myFields.get(SettlCurrFxRateCalcField.TagId).flatMap(f=>SettlCurrFxRateCalcField.decode(f)),
          myFields.get(PositionEffectField.TagId).flatMap(f=>PositionEffectField.decode(f)),
          myFields.get(SideMultiLegReportingTypeField.TagId).flatMap(f=>SideMultiLegReportingTypeField.decode(f)),
          ContAmtGrpComponent.decode(flds, startPos),
          StipulationsComponent.decode(flds, startPos),
          MiscFeesGrpComponent.decode(flds, startPos),
          myFields.get(ExchangeRuleField.TagId).flatMap(f=>ExchangeRuleField.decode(f)),
          myFields.get(TradeAllocIndicatorField.TagId).flatMap(f=>TradeAllocIndicatorField.decode(f)),
          myFields.get(PreallocMethodField.TagId).flatMap(f=>PreallocMethodField.decode(f)),
          myFields.get(AllocIDField.TagId).flatMap(f=>AllocIDField.decode(f)),
          TrdAllocGrpComponent.decode(flds, startPos),
          myFields.get(LotTypeField.TagId).flatMap(f=>LotTypeField.decode(f)),
          myFields.get(SideGrossTradeAmtField.TagId).flatMap(f=>SideGrossTradeAmtField.decode(f)),
          myFields.get(AggressorIndicatorField.TagId).flatMap(f=>AggressorIndicatorField.decode(f)),
          myFields.get(SideQtyField.TagId).flatMap(f=>SideQtyField.decode(f)),
          myFields.get(SideTradeReportIDField.TagId).flatMap(f=>SideTradeReportIDField.decode(f)),
          myFields.get(SideFillStationCdField.TagId).flatMap(f=>SideFillStationCdField.decode(f)),
          myFields.get(SideReasonCdField.TagId).flatMap(f=>SideReasonCdField.decode(f)),
          myFields.get(RptSeqField.TagId).flatMap(f=>RptSeqField.decode(f)),
          myFields.get(SideTrdSubTypField.TagId).flatMap(f=>SideTrdSubTypField.decode(f)),
          SideTrdRegTSComponent.decode(flds, startPos))))
      } else (startPos, None)
    }
  }
    
}
     