/*
 * Decompiled with CFR 0.152.
 */
package org.sackfix.session;

import akka.actor.ActorRef;
import java.time.LocalDateTime;
import org.sackfix.codec.DecodingFailedData;
import org.sackfix.codec.SfDecodeTuplesToMsg$;
import org.sackfix.common.message.SfMessage;
import org.sackfix.common.message.SfMessage$;
import org.sackfix.common.message.SfMessageHeader;
import org.sackfix.common.message.SfMessageHeader$;
import org.sackfix.common.validated.fields.SfFixMessageBody;
import org.sackfix.field.BeginStringField;
import org.sackfix.field.GapFillFlagField$;
import org.sackfix.field.MsgSeqNumField;
import org.sackfix.field.MsgTypeField;
import org.sackfix.field.NewSeqNoField;
import org.sackfix.field.OrigSendingTimeField;
import org.sackfix.field.PossDupFlagField;
import org.sackfix.field.PossDupFlagField$;
import org.sackfix.field.RefSeqNumField;
import org.sackfix.field.SenderCompIDField;
import org.sackfix.field.SendingTimeField;
import org.sackfix.field.SessionRejectReasonField;
import org.sackfix.field.SessionRejectReasonField$;
import org.sackfix.field.TargetCompIDField;
import org.sackfix.field.TextField;
import org.sackfix.fix44.RejectMessage;
import org.sackfix.fix44.RejectMessage$;
import org.sackfix.fix44.SequenceResetMessage;
import org.sackfix.session.SfAcceptor$;
import org.sackfix.session.SfAction;
import org.sackfix.session.SfActionBusinessMessage;
import org.sackfix.session.SfActionBusinessSessionClosedForSending$;
import org.sackfix.session.SfActionBusinessSessionOpenForSending$;
import org.sackfix.session.SfActionCloseSocket;
import org.sackfix.session.SfActionCounterpartyHeartbeat;
import org.sackfix.session.SfActionResendMessages;
import org.sackfix.session.SfActionSendMessageToFix;
import org.sackfix.session.SfActionStartTimeout;
import org.sackfix.session.SfControlForceLogoutAndClose;
import org.sackfix.session.SfMessageStore;
import org.sackfix.session.SfSequencePair;
import org.sackfix.session.SfSession;
import org.sackfix.session.SfSessionActorOutActions;
import org.sackfix.session.SfSessionEvent;
import org.sackfix.session.SfSessionFixMessageEvent;
import org.sackfix.session.SfSessionId;
import org.sackfix.session.SfSessionId$;
import org.sackfix.session.SfSessionImpl$;
import org.sackfix.session.SfSessionType;
import org.sackfix.session.fixstate.DisconnectedNoConnectionToday$;
import org.sackfix.session.fixstate.SfSessState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t%h\u0001B\u0001\u0003\u0001%\u0011Qb\u00154TKN\u001c\u0018n\u001c8J[Bd'BA\u0002\u0005\u0003\u001d\u0019Xm]:j_:T!!\u0002\u0004\u0002\u000fM\f7m\u001b4jq*\tq!A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111\u0002D\u0007\u0002\u0005%\u0011QB\u0001\u0002\n'\u001a\u001cVm]:j_:D\u0011b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\n\u0002\u0017M,7o]5p]RK\b/\u001a\t\u0003\u0017EI!A\u0005\u0002\u0003\u001bM37+Z:tS>tG+\u001f9f\u0013\tyA\u0002\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003MiWm]:bO\u0016\u001cFo\u001c:f\t\u0016$\u0018-\u001b7t!\r9\"\u0004H\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1q\n\u001d;j_:\u0004\"aC\u000f\n\u0005y\u0011!AD*g\u001b\u0016\u001c8/Y4f'R|'/\u001a\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u0005a1/Z:tS>t\u0017i\u0019;peB\u00111BI\u0005\u0003G\t\u0011\u0001d\u00154TKN\u001c\u0018n\u001c8BGR|'oT;u\u0003\u000e$\u0018n\u001c8t\u0011%)\u0003A!A!\u0002\u00131\u0013&A\u0005tKN\u001c\u0018n\u001c8JIB\u00111bJ\u0005\u0003Q\t\u00111b\u00154TKN\u001c\u0018n\u001c8JI&\u0011Q\u0005\u0004\u0005\nW\u0001\u0011\t\u0011)A\u0005Y=\nQ\u0003[3beR\u0014W-\u0019;J]R,'O^1m'\u0016\u001c7\u000f\u0005\u0002\u0018[%\u0011a\u0006\u0007\u0002\u0004\u0013:$\u0018BA\u0016\r\u0011!\t\u0004A!b\u0001\n\u0003\u0011\u0014a\u00047bi\u0016t7-\u001f*fG>\u0014H-\u001a:\u0016\u0003M\u00022a\u0006\u000e5!\t)$(D\u00017\u0015\t9\u0004(A\u0003bGR|'OC\u0001:\u0003\u0011\t7n[1\n\u0005m2$\u0001C!di>\u0014(+\u001a4\t\u0011u\u0002!\u0011!Q\u0001\nM\n\u0001\u0003\\1uK:\u001c\u0017PU3d_J$WM\u001d\u0011\t\u0011}\u0002!Q1A\u0005B\u0001\u000b1c]3tg&|g.T3tg\u0006<W\rV=qKN,\u0012!\u0011\t\u0004\u0005\u001eKU\"A\"\u000b\u0005\u0011+\u0015!C5n[V$\u0018M\u00197f\u0015\t1\u0005$\u0001\u0006d_2dWm\u0019;j_:L!\u0001S\"\u0003\u000f!\u000b7\u000f[*fiB\u0011!*\u0014\b\u0003/-K!\u0001\u0014\r\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019bA\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u0015g\u0016\u001c8/[8o\u001b\u0016\u001c8/Y4f)f\u0004Xm\u001d\u0011\t\u000bM\u0003A\u0011\u0001+\u0002\rqJg.\u001b;?)!)fk\u0016-Z5nc\u0006CA\u0006\u0001\u0011\u0015y!\u000b1\u0001\u0011\u0011\u0015)\"\u000b1\u0001\u0017\u0011\u0015\u0001#\u000b1\u0001\"\u0011\u0015)#\u000b1\u0001'\u0011\u0015Y#\u000b1\u0001-\u0011\u001d\t$\u000b%AA\u0002MBqa\u0010*\u0011\u0002\u0003\u0007\u0011\tC\u0004_\u0001\t\u0007I\u0011B0\u0002\u00071|w-F\u0001a!\t\tG-D\u0001c\u0015\t\u0019g!A\u0003tY\u001a$$.\u0003\u0002fE\n1Aj\\4hKJDaa\u001a\u0001!\u0002\u0013\u0001\u0017\u0001\u00027pO\u0002Bq!\u001b\u0001C\u0002\u0013%q,A\u0007gSb4VM\u001d2pg\u0016dun\u001a\u0005\u0007W\u0002\u0001\u000b\u0011\u00021\u0002\u001d\u0019L\u0007PV3sE>\u001cX\rT8hA!AQ\u000e\u0001a\u0001\n\u0003\u0011a.A\u0007mCN$8\t\\8tKRKW.Z\u000b\u0002_B\u0019qC\u00079\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001\u0002;j[\u0016T\u0011!^\u0001\u0005U\u00064\u0018-\u0003\u0002xe\niAj\\2bY\u0012\u000bG/\u001a+j[\u0016D\u0001\"\u001f\u0001A\u0002\u0013\u0005!A_\u0001\u0012Y\u0006\u001cHo\u00117pg\u0016$\u0016.\\3`I\u0015\fHCA>\u007f!\t9B0\u0003\u0002~1\t!QK\\5u\u0011\u001dy\b0!AA\u0002=\f1\u0001\u001f\u00132\u0011\u001d\t\u0019\u0001\u0001Q!\n=\fa\u0002\\1ti\u000ecwn]3US6,\u0007\u0005\u0003\u0006\u0002\b\u0001\u0001\r\u0011\"\u0001\u0003\u0003\u0013\tAb]3tg&|gn\u0015;bi\u0016,\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\u0003\u0003!1\u0017\u000e_:uCR,\u0017\u0002BA\u000b\u0003\u001f\u00111b\u00154TKN\u001c8\u000b^1uK\"Q\u0011\u0011\u0004\u0001A\u0002\u0013\u0005!!a\u0007\u0002!M,7o]5p]N#\u0018\r^3`I\u0015\fHcA>\u0002\u001e!Iq0a\u0006\u0002\u0002\u0003\u0007\u00111\u0002\u0005\t\u0003C\u0001\u0001\u0015)\u0003\u0002\f\u0005i1/Z:tS>t7\u000b^1uK\u0002B\u0011\"!\n\u0001\u0001\u0004%\t!a\n\u0002\u001fA,'o]5ti\u0016tGo\u0015;pe\u0016,\u0012A\u0006\u0005\n\u0003W\u0001\u0001\u0019!C\u0001\u0003[\t1\u0003]3sg&\u001cH/\u001a8u'R|'/Z0%KF$2a_A\u0018\u0011!y\u0018\u0011FA\u0001\u0002\u00041\u0002bBA\u001a\u0001\u0001\u0006KAF\u0001\u0011a\u0016\u00148/[:uK:$8\u000b^8sK\u0002B!\"a\u000e\u0001\u0001\u0004%\tAAA\u001d\u0003\u0005\u001aw.\u001e8uKJ\u0004\u0018M\u001d;z\u0011\u0016\f'\u000f\u001e2fCRLe\u000e^3sm\u0006d7+Z2t+\u0005a\u0003BCA\u001f\u0001\u0001\u0007I\u0011\u0001\u0002\u0002@\u0005)3m\\;oi\u0016\u0014\b/\u0019:us\"+\u0017M\u001d;cK\u0006$\u0018J\u001c;feZ\fGnU3dg~#S-\u001d\u000b\u0004w\u0006\u0005\u0003\u0002C@\u0002<\u0005\u0005\t\u0019\u0001\u0017\t\u000f\u0005\u0015\u0003\u0001)Q\u0005Y\u0005\u00113m\\;oi\u0016\u0014\b/\u0019:us\"+\u0017M\u001d;cK\u0006$\u0018J\u001c;feZ\fGnU3dg\u0002Bq!!\u0013\u0001\t\u0003\tY%\u0001\u0007sKN,GoU3r\u001dVl7/F\u0001|\u0011\u001d\ty\u0005\u0001C!\u0003#\n1b]3u)\",\u0017N]*fcR\u0019A&a\u0015\t\u000f\u0005U\u0013Q\na\u0001Y\u00059!/Z:fiR{\u0007bBA-\u0001\u0011\u0005\u00131L\u0001\tg\u0016$X*_*fcR\u0019A&!\u0018\t\u000f\u0005U\u0013q\u000ba\u0001Y!9\u0011\u0011\r\u0001\u0005\u0002\u0005e\u0012AD5oGJ,W.\u001a8u\u001bf\u001cV-\u001d\u0005\b\u0003K\u0002A\u0011AA\u001d\u0003EIgn\u0019:f[\u0016tG\u000f\u00165fSJ\u001cV-\u001d\u0005\t\u0003S\u0002A\u0011\u0001\u0002\u0002l\u0005i1M]3bi\u0016lUm]:bO\u0016$b!!\u001c\u0002~\u0005\u0005\u0005\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\b[\u0016\u001c8/Y4f\u0015\r\t9\bB\u0001\u0007G>lWn\u001c8\n\t\u0005m\u0014\u0011\u000f\u0002\n'\u001alUm]:bO\u0016Dq!a \u0002h\u0001\u0007\u0011*A\u0004ng\u001e$\u0016\u0010]3\t\u0011\u0005\r\u0015q\ra\u0001\u0003\u000b\u000bqb\\;uO>LgnZ'tO\n{G-\u001f\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u00191\u0017.\u001a7eg*!\u0011qRA;\u0003%1\u0018\r\\5eCR,G-\u0003\u0003\u0002\u0014\u0006%%\u0001E*g\r&DX*Z:tC\u001e,'i\u001c3z\u0011!\tI\u0007\u0001C\u0001\u0005\u0005]E\u0003CA7\u00033\u000bi*a(\t\u000f\u0005m\u0015Q\u0013a\u0001Y\u000511/Z9Ok6Dq!a \u0002\u0016\u0002\u0007\u0011\n\u0003\u0005\u0002\u0004\u0006U\u0005\u0019AAC\u0011!\tI\u0007\u0001C\u0001\u0005\u0005\rF\u0003DA7\u0003K\u000b9+!+\u0002<\u0006\u001d\u0007bBAN\u0003C\u0003\r\u0001\f\u0005\b\u0003\u007f\n\t\u000b1\u0001J\u0011!\tY+!)A\u0002\u00055\u0016\u0001\u00059pgN$U\u000f\u001d$mC\u001e4\u0015.\u001a7e!\u00119\"$a,\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.\u0005\u0003\u00151\u0017.\u001a7e\u0013\u0011\tI,a-\u0003!A{7o\u001d#va\u001ac\u0017m\u001a$jK2$\u0007\u0002CA_\u0003C\u0003\r!a0\u0002)=\u0014\u0018nZ*f]\u0012Lgn\u001a+j[\u00164\u0015.\u001a7e!\u00119\"$!1\u0011\t\u0005E\u00161Y\u0005\u0005\u0003\u000b\f\u0019L\u0001\u000bPe&<7+\u001a8eS:<G+[7f\r&,G\u000e\u001a\u0005\t\u0003\u0007\u000b\t\u000b1\u0001\u0002\u0006\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0017\u0001D:f]\u0012\fU*Z:tC\u001e,G#B>\u0002P\u0006M\u0007\u0002CAi\u0003\u0013\u0004\r!!\"\u0002\u000f5\u001cxMQ8es\"I\u0011Q[Ae!\u0003\u0005\r!S\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\t\u000f\u0005e\u0007\u0001\"\u0001\u0002L\u0005)1\r\\8tK\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0017!C8qK:\u001cFo\u001c:f)\rY\u0018\u0011\u001d\u0005\t\u0003G\fY\u000e1\u0001\u0002f\u0006Q\"/Z1e\u0013:LG/[1m'\u0016\fX/\u001a8dK:+XNY3sgB\u0019q#a:\n\u0007\u0005%\bDA\u0004C_>dW-\u00198\t\u000f\u00055\b\u0001\"\u0001\u0002p\u0006i\u0001.\u00198eY\u0016lUm]:bO\u0016$2a_Ay\u0011!\t\u00190a;A\u0002\u00055\u0014aD5oG>l\u0017N\\4NKN\u001c\u0018mZ3\t\u000f\u0005]\b\u0001\"\u0001\u0002z\u0006q1m\\7q\u0013\u0012\u001c8i\u001c:sK\u000e$H\u0003BAs\u0003wD\u0001\"!@\u0002v\u0002\u0007\u0011q`\u0001\u0007Q\u0016\fG-\u001a:\u0011\t\u0005=$\u0011A\u0005\u0005\u0005\u0007\t\tHA\bTM6+7o]1hK\"+\u0017\rZ3s\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013\tqCZ5sK\u00163XM\u001c;U_N#\u0018\r^3NC\u000eD\u0017N\\3\u0015\u0007m\u0014Y\u0001\u0003\u0005\u0003\u000e\t\u0015\u0001\u0019\u0001B\b\u0003\t)g\u000fE\u0002\f\u0005#I1Aa\u0005\u0003\u00059\u0019fmU3tg&|g.\u0012<f]RDqAa\u0006\u0001\t\u0003\u0011I\"A\u0007jgN+7o]5p]>\u0003XM\\\u000b\u0003\u0003KDqA!\b\u0001\t\u0003\u0011y\"\u0001\u0007iC:$G.Z!di&|g\u000eF\u0002|\u0005CA\u0001Ba\t\u0003\u001c\u0001\u0007!QE\u0001\u0007C\u000e$\u0018n\u001c8\u0011\u0007-\u00119#C\u0002\u0003*\t\u0011\u0001b\u00154BGRLwN\u001c\u0005\b\u0005[\u0001A\u0011\u0002B\u0018\u0003u\u0019X\r^*fgNLwN\u001c%fCJ$(-Z1u)>\u0014U\r\u00165fSJ\u001cHcA>\u00032!9!1\u0007B\u0016\u0001\u0004a\u0013!\u00045fCJ$(-Z1u'\u0016\u001c7\u000fC\u0004\u00038\u0001!\tA!\u000f\u0002+I,\u0007\u000f\\1dK\"+\u0017\rZ3s\u001f:\u0014Vm]3oIR!!1\bB\u001f!\u00119\"$!\u001c\t\u000f\t}\"Q\u0007a\u0001\u0013\u00061a-\u001b=TiJDqAa\u0011\u0001\t\u0003\u0011)%\u0001\bsKBd\u0017-_'fgN\fw-Z:\u0015\u000bm\u00149Ea\u0013\t\u000f\t%#\u0011\ta\u0001Y\u0005Y!-Z4j]N+\u0017OT;n\u0011\u001d\u0011iE!\u0011A\u00021\n\u0011\"\u001a8e'\u0016\fh*^7\t\u0011\tE\u0003\u0001\"\u0001\u0003\u0005'\n1b]3oI\u001e\u000b\u0007OR5mYR)1P!\u0016\u0003Z!9!q\u000bB(\u0001\u0004a\u0013!C7tON+\u0017OT;n\u0011\u001d\u0011YFa\u0014A\u00021\n!B\\3yiN+\u0017OT;n\u0011\u001d\u0011y\u0006\u0001C\u0001\u0005C\n\u0011dZ3u\u001b\u0016\u001c8/Y4f\r&D8\u000b\u001e:Ge>l7\u000b^8sKR!!1\rB3!\r9\"$\u0013\u0005\b\u0005O\u0012i\u00061\u0001-\u0003\u0015\u0019X-\u001d(p\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005[\n\u0011c]3oIJ+'.Z2u\u001b\u0016\u001c8/Y4f)%Y(q\u000eB:\u0005o\u0012\t\tC\u0004\u0003r\t%\u0004\u0019\u0001\u0017\u0002\u0013I,gmU3r\u001dVl\u0007\u0002\u0003B;\u0005S\u0002\r!!:\u0002\u0013%t7mU3r\u001dVl\u0007\u0002\u0003B=\u0005S\u0002\rAa\u001f\u0002\rI,\u0017m]8o!\u0011\t\tL! \n\t\t}\u00141\u0017\u0002\u0019'\u0016\u001c8/[8o%\u0016TWm\u0019;SK\u0006\u001cxN\u001c$jK2$\u0007\u0002\u0003BB\u0005S\u0002\rA!\"\u0002\u0017\u0015D\b\u000f\\1oCRLwN\u001c\t\u0005\u0003c\u00139)\u0003\u0003\u0003\n\u0006M&!\u0003+fqR4\u0015.\u001a7e\u0011\u001d\u0011i\t\u0001C\u0001\u0003s\tacZ3u\u000bb\u0004Xm\u0019;fIRCW-\u001b:TKFtU/\u001c\u0005\n\u0005#\u0003\u0011\u0013!C\u0001\u0005'\u000bac]3oI\u0006kUm]:bO\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005+S3!\u0013BLW\t\u0011I\n\u0005\u0003\u0003\u001c\n\u0015VB\u0001BO\u0015\u0011\u0011yJ!)\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BR1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d&Q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0004BV\u0001A\u0005\u0019\u0011!A\u0005\n\t5\u0016&A\btkB,'\u000fJ:fgNLwN\\%e+\u00051sa\u0002BY\u0005!\u0005!1W\u0001\u000e'\u001a\u001cVm]:j_:LU\u000e\u001d7\u0011\u0007-\u0011)L\u0002\u0004\u0002\u0005!\u0005!qW\n\u0005\u0005k\u0013I\fE\u0002\u0018\u0005wK1A!0\u0019\u0005\u0019\te.\u001f*fM\"91K!.\u0005\u0002\t\u0005GC\u0001BZ\u0011!\u0011)M!.\u0005\u0002\t\u001d\u0017!B1qa2LH#D+\u0003J\n-'Q\u001aBh\u0005#\u0014\u0019\u000e\u0003\u0004\u0010\u0005\u0007\u0004\r\u0001\u0005\u0005\u0007+\t\r\u0007\u0019\u0001\f\t\r\u0001\u0012\u0019\r1\u0001\"\u0011\u0019)#1\u0019a\u0001M!11Fa1A\u00021B\u0001\"\rBb!\u0003\u0005\ra\r\u0005\u000b\u0005/\u0014),%A\u0005\u0002\te\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tm'fA\u001a\u0003\u0018\"Q!q\u001cB[#\u0003%\tA!7\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0011)\u0011\u0019O!.\u0012\u0002\u0013\u0005!Q]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t\u001d(fA!\u0003\u0018\u0002")
public class SfSessionImpl
extends SfSession {
    public final SfSessionActorOutActions org$sackfix$session$SfSessionImpl$$sessionActor;
    private final Option<ActorRef> latencyRecorder;
    private final HashSet<String> sessionMessageTypes;
    private final Logger org$sackfix$session$SfSessionImpl$$log;
    private final Logger org$sackfix$session$SfSessionImpl$$fixVerboseLog;
    private Option<LocalDateTime> lastCloseTime;
    private SfSessState sessionState;
    private Option<SfMessageStore> persistentStore;
    private int counterpartyHeartbeatIntervalSecs;

    public static HashSet<String> $lessinit$greater$default$7() {
        return SfSessionImpl$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<ActorRef> $lessinit$greater$default$6() {
        return SfSessionImpl$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<ActorRef> apply$default$6() {
        return SfSessionImpl$.MODULE$.apply$default$6();
    }

    public static SfSessionImpl apply(SfSessionType sfSessionType, Option<SfMessageStore> option, SfSessionActorOutActions sfSessionActorOutActions, SfSessionId sfSessionId, int n, Option<ActorRef> option2) {
        return SfSessionImpl$.MODULE$.apply(sfSessionType, option, sfSessionActorOutActions, sfSessionId, n, option2);
    }

    public /* synthetic */ SfSessionId org$sackfix$session$SfSessionImpl$$super$sessionId() {
        return super.sessionId();
    }

    public Option<ActorRef> latencyRecorder() {
        return this.latencyRecorder;
    }

    @Override
    public HashSet<String> sessionMessageTypes() {
        return this.sessionMessageTypes;
    }

    public Logger org$sackfix$session$SfSessionImpl$$log() {
        return this.org$sackfix$session$SfSessionImpl$$log;
    }

    public Logger org$sackfix$session$SfSessionImpl$$fixVerboseLog() {
        return this.org$sackfix$session$SfSessionImpl$$fixVerboseLog;
    }

    public Option<LocalDateTime> lastCloseTime() {
        return this.lastCloseTime;
    }

    public void lastCloseTime_$eq(Option<LocalDateTime> x$1) {
        this.lastCloseTime = x$1;
    }

    public SfSessState sessionState() {
        return this.sessionState;
    }

    public void sessionState_$eq(SfSessState x$1) {
        this.sessionState = x$1;
    }

    public Option<SfMessageStore> persistentStore() {
        return this.persistentStore;
    }

    public void persistentStore_$eq(Option<SfMessageStore> x$1) {
        this.persistentStore = x$1;
    }

    public int counterpartyHeartbeatIntervalSecs() {
        return this.counterpartyHeartbeatIntervalSecs;
    }

    public void counterpartyHeartbeatIntervalSecs_$eq(int x$1) {
        this.counterpartyHeartbeatIntervalSecs = x$1;
    }

    @Override
    public void resetSeqNums() {
        if (this.nextMySeqNum() != 1 && this.nextTheirSeqNum() != 1) {
            this.org$sackfix$session$SfSessionImpl$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " resetSeqNums called, setting seq numbers to 1 (the old vals were myNextSeqNum=", " theirNextSeqNum=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.idStr(), BoxesRunTime.boxToInteger((int)this.nextMySeqNum()), BoxesRunTime.boxToInteger((int)this.nextTheirSeqNum())})));
            this.nextMySeqNum_$eq(1);
            this.nextTheirSeqNum_$eq(1);
            this.persistentStore().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SfSessionImpl $outer;

                public final void apply(SfMessageStore store) {
                    store.storeMySequenceNumber(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId(), this.$outer.nextMySeqNum());
                    store.storeTheirSequenceNumber(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId(), this.$outer.nextTheirSeqNum());
                    store.archiveTodaysReplay(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    @Override
    public int setTheirSeq(int resetTo) {
        int origTheirSeqNum = this.nextTheirSeqNum();
        this.nextTheirSeqNum_$eq(resetTo);
        this.persistentStore().foreach((Function1)new Serializable(this, origTheirSeqNum){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSessionImpl $outer;
            private final int origTheirSeqNum$1;

            public final void apply(SfMessageStore store) {
                store.storeTheirSequenceNumber(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId(), this.$outer.nextTheirSeqNum());
                if (this.$outer.nextTheirSeqNum() < this.origTheirSeqNum$1) {
                    store.archiveTodaysReplay(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.origTheirSeqNum$1 = origTheirSeqNum$1;
            }
        });
        return this.nextTheirSeqNum();
    }

    @Override
    public int setMySeq(int resetTo) {
        int origMySeqNum = this.nextMySeqNum();
        this.nextMySeqNum_$eq(resetTo);
        this.persistentStore().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSessionImpl $outer;

            public final void apply(SfMessageStore store) {
                store.storeMySequenceNumber(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId(), this.$outer.nextMySeqNum());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.nextMySeqNum();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int incrementMySeq() {
        void var1_1;
        int ret = this.nextMySeqNum();
        this.nextMySeqNum_$eq(this.nextMySeqNum() + 1);
        this.persistentStore().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSessionImpl $outer;

            public final void apply(SfMessageStore x$1) {
                x$1.storeMySequenceNumber(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId(), this.$outer.nextMySeqNum());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int incrementTheirSeq() {
        void var1_1;
        int ret = this.nextTheirSeqNum();
        this.nextTheirSeqNum_$eq(this.nextTheirSeqNum() + 1);
        this.persistentStore().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSessionImpl $outer;

            public final void apply(SfMessageStore x$2) {
                x$2.storeTheirSequenceNumber(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId(), this.$outer.nextTheirSeqNum());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (int)var1_1;
    }

    public SfMessage createMessage(String msgType, SfFixMessageBody outgoingMsgBody) {
        int seqNum = this.incrementMySeq();
        return this.createMessage(seqNum, msgType, (Option<PossDupFlagField>)None$.MODULE$, (Option<OrigSendingTimeField>)None$.MODULE$, outgoingMsgBody);
    }

    public SfMessage createMessage(int seqNum, String msgType, SfFixMessageBody outgoingMsgBody) {
        return this.createMessage(seqNum, msgType, (Option<PossDupFlagField>)None$.MODULE$, (Option<OrigSendingTimeField>)None$.MODULE$, outgoingMsgBody);
    }

    public SfMessage createMessage(int seqNum, String msgType, Option<PossDupFlagField> possDupFlagField, Option<OrigSendingTimeField> origSendingTimeField, SfFixMessageBody outgoingMsgBody) {
        BeginStringField x$13 = new BeginStringField(super.sessionId().beginString());
        MsgTypeField x$14 = new MsgTypeField(msgType);
        SenderCompIDField x$15 = new SenderCompIDField(super.sessionId().senderCompId());
        TargetCompIDField x$16 = new TargetCompIDField(super.sessionId().targetCompId());
        MsgSeqNumField x$17 = new MsgSeqNumField(seqNum);
        Option<PossDupFlagField> x$18 = possDupFlagField;
        SendingTimeField x$19 = new SendingTimeField(LocalDateTime.now());
        Option<OrigSendingTimeField> x$20 = origSendingTimeField;
        Option x$21 = SfMessageHeader$.MODULE$.apply$default$2();
        Option x$22 = SfMessageHeader$.MODULE$.apply$default$4();
        Option x$23 = SfMessageHeader$.MODULE$.apply$default$5();
        Option x$24 = SfMessageHeader$.MODULE$.apply$default$6();
        Option x$25 = SfMessageHeader$.MODULE$.apply$default$9();
        Option x$26 = SfMessageHeader$.MODULE$.apply$default$10();
        Option x$27 = SfMessageHeader$.MODULE$.apply$default$11();
        Option x$28 = SfMessageHeader$.MODULE$.apply$default$12();
        Option x$29 = SfMessageHeader$.MODULE$.apply$default$14();
        Option x$30 = SfMessageHeader$.MODULE$.apply$default$15();
        Option x$31 = SfMessageHeader$.MODULE$.apply$default$16();
        Option x$32 = SfMessageHeader$.MODULE$.apply$default$17();
        Option x$33 = SfMessageHeader$.MODULE$.apply$default$18();
        Option x$34 = SfMessageHeader$.MODULE$.apply$default$19();
        Option x$35 = SfMessageHeader$.MODULE$.apply$default$20();
        Option x$36 = SfMessageHeader$.MODULE$.apply$default$21();
        Option x$37 = SfMessageHeader$.MODULE$.apply$default$23();
        Option x$38 = SfMessageHeader$.MODULE$.apply$default$26();
        Option x$39 = SfMessageHeader$.MODULE$.apply$default$27();
        Option x$40 = SfMessageHeader$.MODULE$.apply$default$28();
        Option x$41 = SfMessageHeader$.MODULE$.apply$default$29();
        Option x$42 = SfMessageHeader$.MODULE$.apply$default$30();
        Option x$43 = SfMessageHeader$.MODULE$.apply$default$31();
        SfMessageHeader header = new SfMessageHeader(x$13, x$21, x$14, x$22, x$23, x$24, x$15, x$16, x$25, x$26, x$27, x$28, x$17, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$18, x$37, x$19, x$20, x$38, x$39, x$40, x$41, x$42, x$43);
        return new SfMessage(header, outgoingMsgBody, SfMessage$.MODULE$.$lessinit$greater$default$3(), SfMessage$.MODULE$.$lessinit$greater$default$4());
    }

    @Override
    public void sendAMessage(SfFixMessageBody msgBody, String correlationId) {
        SfMessage msg = this.createMessage(msgBody.msgType(), msgBody);
        String msgFixStr = msg.fixStr();
        if (!this.isMessageFixSessionMessage(msg.body().msgType())) {
            this.persistentStore().foreach((Function1)new Serializable(this, msg, msgFixStr){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SfSessionImpl $outer;
                private final SfMessage msg$1;
                private final String msgFixStr$1;

                public final void apply(SfMessageStore x$3) {
                    x$3.storeOutgoingMessage(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId(), this.msg$1.header().msgSeqNumField().value(), this.msgFixStr$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.msg$1 = msg$1;
                    this.msgFixStr$1 = msgFixStr$1;
                }
            });
        }
        this.org$sackfix$session$SfSessionImpl$$sessionActor.sendFixMsgOut(msgFixStr, correlationId);
        if (this.org$sackfix$session$SfSessionImpl$$fixVerboseLog().isInfoEnabled()) {
            this.org$sackfix$session$SfSessionImpl$$fixVerboseLog().info("OUT {}", new Object[]{msg.toString()});
        }
    }

    public String sendAMessage$default$2() {
        return "";
    }

    @Override
    public void close() {
        this.persistentStore().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSessionImpl $outer;

            public final void apply(SfMessageStore x$4) {
                x$4.close(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.lastCloseTime_$eq((Option<LocalDateTime>)new Some((Object)LocalDateTime.now()));
    }

    public void openStore(boolean readInitialSequenceNumbers) {
        this.persistentStore().foreach((Function1)new Serializable(this, readInitialSequenceNumbers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSessionImpl $outer;
            private final boolean readInitialSequenceNumbers$1;

            public final void apply(SfMessageStore messageStore) {
                SfSequencePair sfSequencePair = messageStore.initialiseSession(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId(), this.readInitialSequenceNumbers$1);
                if (sfSequencePair != null) {
                    int ourSeqNum = sfSequencePair.ourSeqNum();
                    int theirSeqNum = sfSequencePair.theirSeqNum();
                    int n = ourSeqNum;
                    int n2 = theirSeqNum;
                    this.$outer.nextMySeqNum_$eq(n);
                    this.$outer.nextTheirSeqNum_$eq(n2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)sfSequencePair);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.readInitialSequenceNumbers$1 = readInitialSequenceNumbers$1;
            }
        });
    }

    @Override
    public void handleMessage(SfMessage incomingMessage) {
        if (this.org$sackfix$session$SfSessionImpl$$fixVerboseLog().isInfoEnabled()) {
            this.org$sackfix$session$SfSessionImpl$$fixVerboseLog().info("IN  {}", new Object[]{incomingMessage});
        }
        this.lastTheirSeqNum_$eq(incomingMessage.header().msgSeqNumField().value());
        if (this.compIdsCorrect(incomingMessage.header())) {
            this.fireEventToStateMachine(new SfSessionFixMessageEvent(incomingMessage));
        }
    }

    public boolean compIdsCorrect(SfMessageHeader header) {
        boolean bl;
        SfSessionId sessId;
        SfSessionId sfSessionId = sessId = SfSessionId$.MODULE$.apply(header);
        SfSessionId sfSessionId2 = super.sessionId();
        if (!(sfSessionId != null ? !((Object)sfSessionId).equals(sfSessionId2) : sfSessionId2 != null)) {
            bl = true;
        } else {
            String msg;
            String string = sessId.beginString();
            String string2 = super.sessionId().beginString();
            boolean beginStrWrong = string != null ? !string.equals(string2) : string2 != null;
            String string3 = msg = beginStrWrong ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fix version [", "] should be [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sessId.beginString(), super.sessionId().beginString()})) : "Message contains invalid CompId fields";
            if (this.sessionState().isSessionOpen()) {
                if (beginStrWrong) {
                    this.org$sackfix$session$SfSessionImpl$$log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Message has wrong beginStr [", "],  expected [", "] logout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.idStr(), sessId.toString(), super.sessionId()})));
                    this.fireEventToStateMachine(new SfControlForceLogoutAndClose(msg, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)2000L))));
                } else {
                    this.org$sackfix$session$SfSessionImpl$$log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Message has wrong header fields [", "],  expected [", "] inc their seq num, reject message and logout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.idStr(), sessId.toString(), super.sessionId()})));
                    this.sendRejectMessage(header.msgSeqNumField().value(), false, new SessionRejectReasonField(SessionRejectReasonField$.MODULE$.CompidProblem()), new TextField(msg));
                    this.fireEventToStateMachine(new SfControlForceLogoutAndClose(msg, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)2000L))));
                }
            } else {
                this.org$sackfix$session$SfSessionImpl$$log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Message has wrong header fields [", "],  expected [", "] reject message"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.idStr(), sessId.toString(), super.sessionId()})));
                this.sendRejectMessage(header.msgSeqNumField().value(), false, new SessionRejectReasonField(SessionRejectReasonField$.MODULE$.CompidProblem()), new TextField(msg));
            }
            bl = false;
        }
        return bl;
    }

    public void fireEventToStateMachine(SfSessionEvent ev) {
        this.sessionState_$eq(this.sessionState().receiveEvent(this, ev, (Function1<SfAction, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSessionImpl $outer;

            public final void apply(SfAction action) {
                this.$outer.handleAction(action);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public boolean isSessionOpen() {
        return this.sessionState().isSessionOpen();
    }

    @Override
    public void handleAction(SfAction action) {
        SfAction sfAction;
        block10: {
            block3: {
                block9: {
                    block8: {
                        block7: {
                            int heartbeatSecs;
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            sfAction = action;
                                            if (!(sfAction instanceof SfActionStartTimeout)) break block2;
                                            SfActionStartTimeout sfActionStartTimeout = (SfActionStartTimeout)sfAction;
                                            String id = sfActionStartTimeout.id();
                                            long durationMs = sfActionStartTimeout.durationMs();
                                            this.org$sackfix$session$SfSessionImpl$$sessionActor.addControlTimeout(id, durationMs);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(sfAction instanceof SfActionCloseSocket)) break block4;
                                        this.org$sackfix$session$SfSessionImpl$$sessionActor.closeSessionSocket();
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(sfAction instanceof SfActionSendMessageToFix)) break block5;
                                    SfActionSendMessageToFix sfActionSendMessageToFix = (SfActionSendMessageToFix)sfAction;
                                    SfFixMessageBody msgBody = sfActionSendMessageToFix.msg();
                                    this.sendAMessage(msgBody, "");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(sfAction instanceof SfActionResendMessages)) break block6;
                                SfActionResendMessages sfActionResendMessages = (SfActionResendMessages)sfAction;
                                int beginSeqNum = sfActionResendMessages.beginSeqNo();
                                int endSeqNum = sfActionResendMessages.endSeqNo();
                                int n = beginSeqNum;
                                int n2 = endSeqNum;
                                this.replayMessages(n, n2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(sfAction instanceof SfActionCounterpartyHeartbeat)) break block7;
                            SfActionCounterpartyHeartbeat sfActionCounterpartyHeartbeat = (SfActionCounterpartyHeartbeat)sfAction;
                            int n = heartbeatSecs = sfActionCounterpartyHeartbeat.heartbeatSecs();
                            this.setSessionHeartbeatToBeTheirs(n);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(sfAction instanceof SfActionBusinessMessage)) break block8;
                        SfActionBusinessMessage sfActionBusinessMessage = (SfActionBusinessMessage)sfAction;
                        SfMessage msg = sfActionBusinessMessage.msg();
                        this.org$sackfix$session$SfSessionImpl$$sessionActor.forwardBusinessMessageFromSocket(msg);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!SfActionBusinessSessionOpenForSending$.MODULE$.equals(sfAction)) break block9;
                    this.org$sackfix$session$SfSessionImpl$$sessionActor.forwardBusinessSessionIsOpen();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!SfActionBusinessSessionClosedForSending$.MODULE$.equals(sfAction)) break block10;
                this.org$sackfix$session$SfSessionImpl$$sessionActor.forwardBusinessSessionIsClosed();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)sfAction);
    }

    private void setSessionHeartbeatToBeTheirs(int heartbeatSecs) {
        if (heartbeatSecs != this.counterpartyHeartbeatIntervalSecs()) {
            SfSessionType sfSessionType = super.sessionType();
            SfAcceptor$ sfAcceptor$ = SfAcceptor$.MODULE$;
            if (!(sfSessionType != null ? !sfSessionType.equals(sfAcceptor$) : sfAcceptor$ != null)) {
                this.org$sackfix$session$SfSessionImpl$$log().info("Initiator heartbeat is {}, changing session to use this value instead of {}", (Object)BoxesRunTime.boxToInteger((int)heartbeatSecs), (Object)BoxesRunTime.boxToInteger((int)super.heartbeatIntervalSecs()));
                this.counterpartyHeartbeatIntervalSecs_$eq(heartbeatSecs);
                this.org$sackfix$session$SfSessionImpl$$sessionActor.changeHeartbeatInterval(this.counterpartyHeartbeatIntervalSecs());
            }
        }
    }

    public Option<SfMessage> replaceHeaderOnResend(String fixStr) {
        Option<SfMessage> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = SfDecodeTuplesToMsg$.MODULE$.decodeFromStr(fixStr, (Function1<DecodingFailedData, BoxedUnit>)new Serializable(this, fixStr){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SfSessionImpl $outer;
                        private final String fixStr$1;

                        public final void apply(DecodingFailedData failData) {
                            this.$outer.org$sackfix$session$SfSessionImpl$$log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Trying to replace header fields on replay of message failed to decode it, which is impossible, msg was [", "] - cause [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.idStr(), this.fixStr$1, failData.description().value()})));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.fixStr$1 = fixStr$1;
                        }
                    }, SfDecodeTuplesToMsg$.MODULE$.decodeFromStr$default$3());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    SfMessage msg = (SfMessage)some.x();
                    SfMessage replayMsg = this.createMessage(msg.header().msgSeqNumField().value(), msg.header().msgTypeField().value(), (Option<PossDupFlagField>)new Some((Object)PossDupFlagField$.MODULE$.apply("Y")), (Option<OrigSendingTimeField>)new Some((Object)new OrigSendingTimeField(msg.header().sendingTimeField().value())), msg.body());
                    none$ = new Some((Object)replayMsg);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    @Override
    public void replayMessages(int beginSeqNum, int endSeqNum) {
        IntRef lastGapStart = IntRef.create((int)-1);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(beginSeqNum), endSeqNum).foreach$mVc$sp((Function1)new Serializable(this, lastGapStart){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSessionImpl $outer;
            private final IntRef lastGapStart$1;

            public final void apply(int seq) {
                this.apply$mcVI$sp(seq);
            }

            public void apply$mcVI$sp(int seq) {
                Option<String> option;
                block15: {
                    block14: {
                        BoxedUnit boxedUnit;
                        block10: {
                            Option<SfMessage> option2;
                            block13: {
                                block12: {
                                    block11: {
                                        BoxedUnit boxedUnit2;
                                        Option<String> msg = this.$outer.getMessageFixStrFromStore(seq);
                                        option = msg;
                                        if (!(option instanceof Some)) break block10;
                                        Some some = (Some)option;
                                        String msgFixStr = (String)some.x();
                                        if (this.lastGapStart$1.elem >= 0) {
                                            this.$outer.sendGapFill(this.lastGapStart$1.elem, seq);
                                            this.lastGapStart$1.elem = -1;
                                        }
                                        if (!None$.MODULE$.equals(option2 = this.$outer.replaceHeaderOnResend(msgFixStr))) break block11;
                                        if (this.lastGapStart$1.elem == -1) {
                                            this.lastGapStart$1.elem = seq;
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        } else {
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit3 = boxedUnit2;
                                        break block12;
                                    }
                                    if (!(option2 instanceof Some)) break block13;
                                    Some some = (Some)option2;
                                    SfMessage msg = (SfMessage)some.x();
                                    if (this.$outer.org$sackfix$session$SfSessionImpl$$fixVerboseLog().isInfoEnabled()) {
                                        this.$outer.org$sackfix$session$SfSessionImpl$$fixVerboseLog().info("OUT RESEND{}", new Object[]{msg.toString()});
                                    }
                                    if (this.$outer.org$sackfix$session$SfSessionImpl$$log().isTraceEnabled()) {
                                        this.$outer.org$sackfix$session$SfSessionImpl$$log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Resending msgSeqNum={}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId().id()})), (Object)BoxesRunTime.boxToInteger((int)msg.header().msgSeqNumField().value()));
                                    }
                                    this.$outer.org$sackfix$session$SfSessionImpl$$sessionActor.sendFixMsgOut(msg.fixStr(), "");
                                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                                break block14;
                            }
                            throw new MatchError(option2);
                        }
                        if (!None$.MODULE$.equals(option)) break block15;
                        if (this.lastGapStart$1.elem == -1) {
                            this.lastGapStart$1.elem = seq;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit6 = boxedUnit;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastGapStart$1 = lastGapStart$1;
            }
        });
        if (lastGapStart.elem >= 0) {
            if (this.org$sackfix$session$SfSessionImpl$$log().isTraceEnabled()) {
                this.org$sackfix$session$SfSessionImpl$$log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Resending GapFill start={}, end={}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{super.sessionId().id()})), (Object)BoxesRunTime.boxToInteger((int)lastGapStart.elem), (Object)BoxesRunTime.boxToInteger((int)(endSeqNum + 1)));
            }
            this.sendGapFill(lastGapStart.elem, endSeqNum + 1);
        }
    }

    public void sendGapFill(int msgSeqNum, int nextSeqNum) {
        SequenceResetMessage outgoingMsgBody = new SequenceResetMessage((Option)new Some((Object)GapFillFlagField$.MODULE$.apply("Y")), new NewSeqNoField(nextSeqNum));
        SfMessage msg = this.createMessage(msgSeqNum, outgoingMsgBody.msgType(), (SfFixMessageBody)outgoingMsgBody);
        if (this.org$sackfix$session$SfSessionImpl$$fixVerboseLog().isInfoEnabled()) {
            this.org$sackfix$session$SfSessionImpl$$fixVerboseLog().info("OUT RESEND{}", new Object[]{msg.toString()});
        }
        this.org$sackfix$session$SfSessionImpl$$sessionActor.sendFixMsgOut(msg.fixStr(), "");
    }

    public Option<String> getMessageFixStrFromStore(int seqNo) {
        return this.persistentStore().map((Function1)new Serializable(this, seqNo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSessionImpl $outer;
            private final int seqNo$1;

            public final Option<String> apply(SfMessageStore x$5) {
                return x$5.readMessage(this.$outer.org$sackfix$session$SfSessionImpl$$super$sessionId(), this.seqNo$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seqNo$1 = seqNo$1;
            }
        }).flatten(Predef$.MODULE$.$conforms());
    }

    @Override
    public void sendRejectMessage(int refSeqNum, boolean incSeqNum, SessionRejectReasonField reason, TextField explanation) {
        Object object;
        if (this.sessionState().isSessionOpen() && refSeqNum == this.nextTheirSeqNum() && incSeqNum) {
            if (this.org$sackfix$session$SfSessionImpl$$log().isInfoEnabled()) {
                this.org$sackfix$session$SfSessionImpl$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Msg with seq num {} failed to decode due to {}, still increment msgNum"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{super.sessionId().id()})), (Object)BoxesRunTime.boxToInteger((int)refSeqNum), (Object)explanation.value());
            }
            object = BoxesRunTime.boxToInteger((int)this.incrementTheirSeq());
        } else {
            if (this.org$sackfix$session$SfSessionImpl$$log().isInfoEnabled()) {
                this.org$sackfix$session$SfSessionImpl$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Msg with seq num {} failed to decode due to {}, not incrementing seq num, so next expected seq num= [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{super.sessionId().id(), BoxesRunTime.boxToInteger((int)this.nextTheirSeqNum())})), (Object)BoxesRunTime.boxToInteger((int)refSeqNum), (Object)explanation.value());
            }
            object = BoxedUnit.UNIT;
        }
        RefSeqNumField x$6 = new RefSeqNumField(refSeqNum);
        Some x$7 = new Some((Object)reason);
        Some x$8 = new Some((Object)explanation);
        Option x$9 = RejectMessage$.MODULE$.apply$default$2();
        Option x$10 = RejectMessage$.MODULE$.apply$default$3();
        Option x$11 = RejectMessage$.MODULE$.apply$default$6();
        Option x$12 = RejectMessage$.MODULE$.apply$default$7();
        RejectMessage outgoingMsgBody = new RejectMessage(x$6, x$9, x$10, (Option)x$7, (Option)x$8, x$11, x$12);
        this.sendAMessage((SfFixMessageBody)outgoingMsgBody, "");
    }

    @Override
    public int getExpectedTheirSeqNum() {
        Option<LocalDateTime> option;
        block6: {
            int n;
            block5: {
                block4: {
                    option = this.lastCloseTime();
                    if (!None$.MODULE$.equals(option)) break block4;
                    n = this.nextTheirSeqNum();
                    break block5;
                }
                if (!(option instanceof Some)) break block6;
                Some some = (Some)option;
                LocalDateTime localLastClose = (LocalDateTime)some.x();
                if (LocalDateTime.now().getDayOfYear() != localLastClose.getDayOfYear()) {
                    this.resetSeqNums();
                    this.lastCloseTime_$eq((Option<LocalDateTime>)None$.MODULE$);
                }
                n = this.nextTheirSeqNum();
            }
            return n;
        }
        throw new MatchError(option);
    }

    public SfSessionImpl(SfSessionType sessionType, Option<SfMessageStore> messageStoreDetails, SfSessionActorOutActions sessionActor, SfSessionId sessionId, int heartbeatIntervalSecs, Option<ActorRef> latencyRecorder, HashSet<String> sessionMessageTypes) {
        Option<SfMessageStore> option;
        block4: {
            block3: {
                block2: {
                    Some some;
                    SfMessageStore messageStore;
                    this.org$sackfix$session$SfSessionImpl$$sessionActor = sessionActor;
                    this.latencyRecorder = latencyRecorder;
                    this.sessionMessageTypes = sessionMessageTypes;
                    super(sessionType, sessionId, heartbeatIntervalSecs);
                    this.org$sackfix$session$SfSessionImpl$$log = LoggerFactory.getLogger(SfSessionImpl$.MODULE$.getClass());
                    this.org$sackfix$session$SfSessionImpl$$fixVerboseLog = LoggerFactory.getLogger((String)"fixVerboseMessages");
                    this.lastCloseTime = None$.MODULE$;
                    this.sessionState = DisconnectedNoConnectionToday$.MODULE$;
                    this.persistentStore = None$.MODULE$;
                    option = messageStoreDetails;
                    if (!(option instanceof Some) || (messageStore = (SfMessageStore)(some = (Some)option).x()) == null) break block2;
                    SfMessageStore sfMessageStore = messageStore;
                    this.persistentStore_$eq((Option<SfMessageStore>)new Some((Object)sfMessageStore));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.counterpartyHeartbeatIntervalSecs = super.heartbeatIntervalSecs();
            return;
        }
        throw new MatchError(option);
    }
}

