/*
 * Decompiled with CFR 0.152.
 */
package org.sackfix.session.filebasedstore;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SfFileUtils$ {
    public static final SfFileUtils$ MODULE$;
    private final Logger logger;

    static {
        new SfFileUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    public Option<RandomAccessFile> openFile(String filename) {
        Some some;
        try {
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Opening file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})));
            some = new Some((Object)new RandomAccessFile(filename, "rw"));
        }
        catch (IOException iOException) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to open file [", "], ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename, iOException.getClass().getName(), iOException.getMessage()})));
            some = None$.MODULE$;
        }
        return some;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeFile(String filename, Option<RandomAccessFile> f) {
        BoxedUnit boxedUnit;
        Option<RandomAccessFile> option = f;
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            return;
        }
        if (!(option instanceof Some)) throw new MatchError(option);
        Some some = (Some)option;
        RandomAccessFile raf = (RandomAccessFile)some.x();
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})));
        try {
            raf.close();
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (IOException iOException) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to close file [", "], ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename, iOException.getClass().getName(), iOException.getMessage()})));
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object renameFile(String fileName, String newFileName) {
        Object object;
        File f = new File(fileName);
        if (!f.exists()) {
            object = BoxedUnit.UNIT;
            return object;
        }
        this.deleteFile(newFileName);
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Renaming file ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName, newFileName})));
        try {
            File newFile = new File(newFileName);
            object = BoxesRunTime.boxToBoolean((boolean)f.renameTo(newFile));
            return object;
        }
        catch (IOException iOException) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to rename file [", "], ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName, iOException.getClass().getName(), iOException.getMessage()})));
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deleteFile(String filename) {
        Object object;
        File f = new File(filename);
        if (!f.exists()) {
            object = BoxedUnit.UNIT;
            return object;
        }
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})));
        try {
            object = BoxesRunTime.boxToBoolean((boolean)f.delete());
            return object;
        }
        catch (IOException iOException) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete file [", "], ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename, iOException.getClass().getName(), iOException.getMessage()})));
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private SfFileUtils$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

