/*
 * Decompiled with CFR 0.152.
 */
package org.sackfix.session.fixstate;

import org.sackfix.common.message.SfMessage;
import org.sackfix.common.validated.fields.SfFixMessageBody;
import org.sackfix.field.ResetSeqNumFlagField;
import org.sackfix.field.ResetSeqNumFlagField$;
import org.sackfix.fix44.LogonMessage;
import org.sackfix.session.SfAction;
import org.sackfix.session.SfActionCounterpartyHeartbeat;
import org.sackfix.session.SfControlNoReceivedHeartbeatTimeout;
import org.sackfix.session.SfSession;
import org.sackfix.session.SfSessionControlEvent;
import org.sackfix.session.fixstate.DisconnectSocketNow$;
import org.sackfix.session.fixstate.InitiateLogoutProcess;
import org.sackfix.session.fixstate.InitiateLogoutProcess$;
import org.sackfix.session.fixstate.InitiationLogonResponse$;
import org.sackfix.session.fixstate.SfSessState;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class WaitingForLogonAck$
extends SfSessState {
    public static final WaitingForLogonAck$ MODULE$;

    static {
        new WaitingForLogonAck$();
    }

    public Option<SfSessState> handleLogonAckMessage(SfSession fixSession, SfMessage msgIn, LogonMessage logonMessage, Function1<SfAction, BoxedUnit> actionCallback) {
        Option option;
        if (((ResetSeqNumFlagField)logonMessage.resetSeqNumFlagField().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ResetSeqNumFlagField apply() {
                return ResetSeqNumFlagField$.MODULE$.apply("N");
            }
        })).value()) {
            int logonSeqNum = msgIn.header().msgSeqNumField().value();
            if (logonSeqNum != 1) {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] LogonMessage asks for Sequence reset to 1 (ie for this message), but the message did not have a sequence number of 1 - logout reply."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fixSession.idStr()})));
                fixSession.incrementTheirSeq();
                option = new Some((Object)new InitiateLogoutProcess(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logon ResetSeqNumFlag=Y, but sequence num was [", "] and should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)logonSeqNum)})), InitiateLogoutProcess$.MODULE$.apply$default$2(), InitiateLogoutProcess$.MODULE$.apply$default$3()));
            } else {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] LogonMessage asks for Sequence reset to 1, resetting now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fixSession.idStr()})));
                fixSession.setTheirSeq(1);
                actionCallback.apply((Object)new SfActionCounterpartyHeartbeat(logonMessage.heartBtIntField().value()));
                option = new Some((Object)InitiationLogonResponse$.MODULE$);
            }
        } else {
            option = this.handleSequenceNumberTooLow(fixSession).orElse((Function0)new Serializable(logonMessage, actionCallback){
                public static final long serialVersionUID = 0L;
                private final LogonMessage logonMessage$1;
                private final Function1 actionCallback$1;

                public final Some<InitiationLogonResponse$> apply() {
                    this.actionCallback$1.apply((Object)new SfActionCounterpartyHeartbeat(this.logonMessage$1.heartBtIntField().value()));
                    return new Some((Object)InitiationLogonResponse$.MODULE$);
                }
                {
                    this.logonMessage$1 = logonMessage$1;
                    this.actionCallback$1 = actionCallback$1;
                }
            });
        }
        return option;
    }

    @Override
    public Option<SfSessState> receiveFixMsg(SfSession fixSession, SfMessage msgIn, Function1<SfAction, BoxedUnit> actionCallback) {
        Some some;
        if (this.isResentDuplicate(fixSession, msgIn)) {
            some = None$.MODULE$;
        } else {
            Some some2;
            SfFixMessageBody sfFixMessageBody = msgIn.body();
            if (sfFixMessageBody instanceof LogonMessage) {
                LogonMessage logonMessage = (LogonMessage)sfFixMessageBody;
                some2 = this.handleLogonAckMessage(fixSession, msgIn, logonMessage, actionCallback);
            } else {
                String msgType = msgIn.header().msgTypeField().value();
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] First message not a logon.  Received unexpected FIX message [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fixSession.idStr(), msgType})));
                some2 = new Some((Object)DisconnectSocketNow$.MODULE$);
            }
            some = some2;
        }
        return some;
    }

    @Override
    public Option<SfSessState> receiveControlEvent(SfSession fixSession, SfSessionControlEvent event) {
        Some some;
        SfSessionControlEvent sfSessionControlEvent = event;
        if (sfSessionControlEvent instanceof SfControlNoReceivedHeartbeatTimeout) {
            SfControlNoReceivedHeartbeatTimeout sfControlNoReceivedHeartbeatTimeout = (SfControlNoReceivedHeartbeatTimeout)sfSessionControlEvent;
            this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] No reply to Logon for at least "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fixSession.idStr()}))).append((Object)BoxesRunTime.boxToInteger((int)sfControlNoReceivedHeartbeatTimeout.noBeatsMissedPlus20Percent())).append((Object)" heartbeats + 20%, disconnecting socket").toString());
            some = new Some((Object)DisconnectSocketNow$.MODULE$);
        } else {
            some = super.receiveControlEvent(fixSession, event);
        }
        return some;
    }

    private WaitingForLogonAck$() {
        super(18, "Waiting For Logon Ack", true, false, true, true);
        MODULE$ = this;
    }
}

