/*
 * Decompiled with CFR 0.152.
 */
package org.sackfix.socket;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.actor.package$;
import akka.event.LoggingAdapter;
import akka.io.Tcp;
import akka.util.ByteString;
import java.time.LocalDateTime;
import org.sackfix.boostrap.BusinessCommsHandler;
import org.sackfix.codec.DecoderTimestamps;
import org.sackfix.codec.DecodingFailedData;
import org.sackfix.codec.FixStrDecodeRejectDetails;
import org.sackfix.codec.SfDecodeBytesToTuples;
import org.sackfix.codec.SfDecodeTuplesToMsg$;
import org.sackfix.common.message.SfMessage;
import org.sackfix.common.message.SfMessage$;
import org.sackfix.common.message.SfMessageHeader;
import org.sackfix.common.message.SfMessageHeader$;
import org.sackfix.common.validated.fields.SfFixMessageBody;
import org.sackfix.field.BeginStringField;
import org.sackfix.field.MsgSeqNumField;
import org.sackfix.field.MsgTypeField;
import org.sackfix.field.SenderCompIDField;
import org.sackfix.field.SendingTimeField;
import org.sackfix.field.TargetCompIDField;
import org.sackfix.latency.LatencyActor;
import org.sackfix.latency.LatencyActor$RecordMsgLatencyMsgIn$;
import org.sackfix.session.SfSessOutEventRouter;
import org.sackfix.session.SfSessOutEventRouterImpl;
import org.sackfix.session.SfSessionActor;
import org.sackfix.session.SfSessionId;
import org.sackfix.session.SfSessionId$;
import org.sackfix.session.SfSessionLookup;
import org.sackfix.session.SfSessionType;
import org.sackfix.socket.SfSocketHandlerActor$;
import org.sackfix.socket.SfSocketHandlerActor$CloseSocketMsgIn$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rUs!B\u0001\u0003\u0011\u0003I\u0011\u0001F*g'>\u001c7.\u001a;IC:$G.\u001a:BGR|'O\u0003\u0002\u0004\t\u000511o\\2lKRT!!\u0002\u0004\u0002\u000fM\f7m\u001b4jq*\tq!A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000b\u00175\t!AB\u0003\r\u0005!\u0005QB\u0001\u000bTMN{7m[3u\u0011\u0006tG\r\\3s\u0003\u000e$xN]\n\u0003\u00179\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\f\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u0015A2\u0002\"\u0001\u001a\u0003\u0015\u0001(o\u001c9t)\u001dQ\"EK\u00185{\u0015\u0003\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003}\tA!Y6lC&\u0011\u0011\u0005\b\u0002\u0006!J|\u0007o\u001d\u0005\u0006G]\u0001\r\u0001J\u0001\fg\u0016\u001c8/[8o)f\u0004X\r\u0005\u0002&Q5\taE\u0003\u0002(\t\u000591/Z:tS>t\u0017BA\u0015'\u00055\u0019fmU3tg&|g\u000eV=qK\")1f\u0006a\u0001Y\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\u0011\u0005mi\u0013B\u0001\u0018\u001d\u0005!\t5\r^8s%\u00164\u0007\"\u0002\u0019\u0018\u0001\u0004\t\u0014!D:fgNLwN\u001c'p_.,\b\u000f\u0005\u0002&e%\u00111G\n\u0002\u0010'\u001a\u001cVm]:j_:dun\\6va\")Qg\u0006a\u0001m\u0005q!/Z7pi\u0016Dun\u001d;OC6,\u0007CA\u001c;\u001d\ty\u0001(\u0003\u0002:!\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\rM#(/\u001b8h\u0015\tI\u0004\u0003C\u0003?/\u0001\u0007q(A\u0007ckNLg.Z:t\u0007>lWn\u001d\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u0012\t\u0001BY8pgR\u0014\u0018\r]\u0005\u0003\t\u0006\u0013ACQ;tS:,7o]\"p[6\u001c\b*\u00198eY\u0016\u0014\b\"\u0002$\u0018\u0001\u00049\u0015a\u00047bi\u0016t7-\u001f*fG>\u0014H-\u001a:\u0011\u0007=AE&\u0003\u0002J!\t1q\n\u001d;j_:4AaS\u0006A\u0019\nA\u0012J\\5uS\u0006$xN]*pG.,Go\u00149f]6\u001bx-\u00138\u0014\t)sQ\n\u0015\t\u0003\u001f9K!a\u0014\t\u0003\u000fA\u0013x\u000eZ;diB\u0011q\"U\u0005\u0003%B\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u0016&\u0003\u0016\u0004%\t!V\u0001\ng\u0016\u001c8/[8o\u0013\u0012,\u0012A\u0016\t\u0003K]K!\u0001\u0017\u0014\u0003\u0017M37+Z:tS>t\u0017\n\u001a\u0005\t5*\u0013\t\u0012)A\u0005-\u0006Q1/Z:tS>t\u0017\n\u001a\u0011\t\u0011qS%Q3A\u0005\u0002u\u000bAb]3tg&|g.Q2u_J,\u0012\u0001\f\u0005\t?*\u0013\t\u0012)A\u0005Y\u0005i1/Z:tS>t\u0017i\u0019;pe\u0002BQ!\u0006&\u0005\u0002\u0005$2A\u00193f!\t\u0019'*D\u0001\f\u0011\u0015!\u0006\r1\u0001W\u0011\u0015a\u0006\r1\u0001-\u0011\u001d9'*!A\u0005\u0002!\fAaY8qsR\u0019!-\u001b6\t\u000fQ3\u0007\u0013!a\u0001-\"9AL\u001aI\u0001\u0002\u0004a\u0003b\u00027K#\u0003%\t!\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005q'F\u0001,pW\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003%)hn\u00195fG.,GM\u0003\u0002v!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]\u0014(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9\u0011PSI\u0001\n\u0003Q\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0002w*\u0012Af\u001c\u0005\b{*\u000b\t\u0011\"\u0011\u007f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\tAA[1wC&\u00191(a\u0001\t\u0013\u0005=!*!A\u0005\u0002\u0005E\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\n!\ry\u0011QC\u0005\u0004\u0003/\u0001\"aA%oi\"I\u00111\u0004&\u0002\u0002\u0013\u0005\u0011QD\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty\"!\n\u0011\u0007=\t\t#C\u0002\u0002$A\u00111!\u00118z\u0011)\t9#!\u0007\u0002\u0002\u0003\u0007\u00111C\u0001\u0004q\u0012\n\u0004\"CA\u0016\u0015\u0006\u0005I\u0011IA\u0017\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0018!\u0019\t\t$a\u000e\u0002 5\u0011\u00111\u0007\u0006\u0004\u0003k\u0001\u0012AC2pY2,7\r^5p]&!\u0011\u0011HA\u001a\u0005!IE/\u001a:bi>\u0014\b\"CA\u001f\u0015\u0006\u0005I\u0011AA \u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA!\u0003\u000f\u00022aDA\"\u0013\r\t)\u0005\u0005\u0002\b\u0005>|G.Z1o\u0011)\t9#a\u000f\u0002\u0002\u0003\u0007\u0011q\u0004\u0005\n\u0003\u0017R\u0015\u0011!C!\u0003\u001b\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003'A\u0011\"!\u0015K\u0003\u0003%\t%a\u0015\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a \u0005\n\u0003/R\u0015\u0011!C!\u00033\na!Z9vC2\u001cH\u0003BA!\u00037B!\"a\n\u0002V\u0005\u0005\t\u0019AA\u0010\u000f%\tyfCA\u0001\u0012\u0003\t\t'\u0001\rJ]&$\u0018.\u0019;peN{7m[3u\u001fB,g.T:h\u0013:\u00042aYA2\r!Y5\"!A\t\u0002\u0005\u00154#BA2\u0003O\u0002\u0006cBA5\u0003_2FFY\u0007\u0003\u0003WR1!!\u001c\u0011\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u001d\u0002l\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000fU\t\u0019\u0007\"\u0001\u0002vQ\u0011\u0011\u0011\r\u0005\u000b\u0003#\n\u0019'!A\u0005F\u0005M\u0003BCA>\u0003G\n\t\u0011\"!\u0002~\u0005)\u0011\r\u001d9msR)!-a \u0002\u0002\"1A+!\u001fA\u0002YCa\u0001XA=\u0001\u0004a\u0003BCAC\u0003G\n\t\u0011\"!\u0002\b\u00069QO\\1qa2LH\u0003BAE\u0003#\u0003Ba\u0004%\u0002\fB)q\"!$WY%\u0019\u0011q\u0012\t\u0003\rQ+\b\u000f\\33\u0011%\t\u0019*a!\u0002\u0002\u0003\u0007!-A\u0002yIAB!\"a&\u0002d\u0005\u0005I\u0011BAM\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0005\u0003BA\u0001\u0003;KA!a(\u0002\u0004\t1qJ\u00196fGR<q!a)\f\u0011\u0003\u000b)+\u0001\tDY>\u001cXmU8dW\u0016$Xj]4J]B\u00191-a*\u0007\u000f\u0005%6\u0002#!\u0002,\n\u00012\t\\8tKN{7m[3u\u001bN<\u0017J\\\n\u0006\u0003OsQ\n\u0015\u0005\b+\u0005\u001dF\u0011AAX)\t\t)\u000b\u0003\u0005~\u0003O\u000b\t\u0011\"\u0011\u007f\u0011)\ty!a*\u0002\u0002\u0013\u0005\u0011\u0011\u0003\u0005\u000b\u00037\t9+!A\u0005\u0002\u0005]F\u0003BA\u0010\u0003sC!\"a\n\u00026\u0006\u0005\t\u0019AA\n\u0011)\tY#a*\u0002\u0002\u0013\u0005\u0013Q\u0006\u0005\u000b\u0003{\t9+!A\u0005\u0002\u0005}F\u0003BA!\u0003\u0003D!\"a\n\u0002>\u0006\u0005\t\u0019AA\u0010\u0011)\tY%a*\u0002\u0002\u0013\u0005\u0013Q\n\u0005\u000b\u0003#\n9+!A\u0005B\u0005M\u0003BCAL\u0003O\u000b\t\u0011\"\u0003\u0002\u001a\u001a)AB\u0001\u0001\u0002LN9\u0011\u0011\u001a\b\u0002N\u0006M\u0007cA\u000e\u0002P&\u0019\u0011\u0011\u001b\u000f\u0003\u000b\u0005\u001bGo\u001c:\u0011\u0007m\t).C\u0002\u0002Xr\u0011A\"Q2u_JdunZ4j]\u001eD!bIAe\u0005\u000b\u0007I\u0011AAn+\u0005!\u0003BCAp\u0003\u0013\u0014\t\u0011)A\u0005I\u0005a1/Z:tS>tG+\u001f9fA!I1&!3\u0003\u0006\u0004%\t!\u0018\u0005\u000b\u0003K\fIM!A!\u0002\u0013a\u0013aC2p]:,7\r^5p]\u0002B!\u0002MAe\u0005\u000b\u0007I\u0011AAu+\u0005\t\u0004BCAw\u0003\u0013\u0014\t\u0011)A\u0005c\u0005q1/Z:tS>tGj\\8lkB\u0004\u0003BC\u001b\u0002J\n\u0015\r\u0011\"\u0001\u0002rV\ta\u0007\u0003\u0006\u0002v\u0006%'\u0011!Q\u0001\nY\nqB]3n_R,\u0007j\\:u\u001d\u0006lW\r\t\u0005\u000b}\u0005%'Q1A\u0005\u0002\u0005eX#A \t\u0015\u0005u\u0018\u0011\u001aB\u0001B\u0003%q(\u0001\bckNLg.Z:t\u0007>lWn\u001d\u0011\t\u0015\u0019\u000bIM!b\u0001\n\u0003\u0011\t!F\u0001H\u0011)\u0011)!!3\u0003\u0002\u0003\u0006IaR\u0001\u0011Y\u0006$XM\\2z%\u0016\u001cwN\u001d3fe\u0002Bq!FAe\t\u0003\u0011I\u0001\u0006\b\u0003\f\t5!q\u0002B\t\u0005'\u0011)Ba\u0006\u0011\u0007)\tI\r\u0003\u0004$\u0005\u000f\u0001\r\u0001\n\u0005\u0007W\t\u001d\u0001\u0019\u0001\u0017\t\rA\u00129\u00011\u00012\u0011\u0019)$q\u0001a\u0001m!1aHa\u0002A\u0002}BaA\u0012B\u0004\u0001\u00049\u0005B\u0003B\u000e\u0003\u0013\u0014\r\u0011\"\u0003\u0003\u001e\u00051a-\u001b=m_\u001e,\"Aa\b\u0011\t\t\u0005\"qE\u0007\u0003\u0005GQ1A!\n\u0007\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\u0011ICa\t\u0003\r1{wmZ3s\u0011%\u0011i#!3!\u0002\u0013\u0011y\"A\u0004gSbdwn\u001a\u0011\t\u0015\tE\u0012\u0011\u001ab\u0001\n\u0013\u0011\u0019$\u0001\u0006gSb$UmY8eKJ,\"A!\u000e\u0011\t\t]\"QH\u0007\u0003\u0005sQ1Aa\u000f\u0005\u0003\u0015\u0019w\u000eZ3d\u0013\u0011\u0011yD!\u000f\u0003+M3G)Z2pI\u0016\u0014\u0015\u0010^3t)>$V\u000f\u001d7fg\"I!1IAeA\u0003%!QG\u0001\fM&DH)Z2pI\u0016\u0014\b\u0005\u0003\u0006\u0003H\u0005%'\u0019!C\u0005\u0005\u0013\n1CZ5y\t\u0016\u001cw\u000eZ3CsR,7\u000b\u001e:j]\u001e,\"Aa\u0013\u0011\u000f=\u0011iE!\u0015\u0003^%\u0019!q\n\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003\u0002B*\u00053j!A!\u0016\u000b\u0007\t]c$\u0001\u0003vi&d\u0017\u0002\u0002B.\u0005+\u0012!BQ=uKN#(/\u001b8h!\ry!qL\u0005\u0004\u0005C\u0002\"\u0001B+oSRD\u0011B!\u001a\u0002J\u0002\u0006IAa\u0013\u0002)\u0019L\u0007\u0010R3d_\u0012,')\u001f;f'R\u0014\u0018N\\4!\u0011)\u0011I'!3A\u0002\u0013%!1N\u0001\u000f_V$XI^3oiJ{W\u000f^3s+\t\u0011i\u0007\u0005\u0003\u0010\u0011\n=\u0004cA\u0013\u0003r%\u0019!1\u000f\u0014\u0003)M37+Z:t\u001fV$XI^3oiJ{W\u000f^3s\u0011)\u00119(!3A\u0002\u0013%!\u0011P\u0001\u0013_V$XI^3oiJ{W\u000f^3s?\u0012*\u0017\u000f\u0006\u0003\u0003^\tm\u0004BCA\u0014\u0005k\n\t\u00111\u0001\u0003n!I!qPAeA\u0003&!QN\u0001\u0010_V$XI^3oiJ{W\u000f^3sA!A!1QAe\t\u0003\u0011))A\u0004sK\u000e,\u0017N^3\u0016\u0005\t\u001d\u0005cB\b\u0003\n\u0006}!QL\u0005\u0004\u0005\u0017\u0003\"a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\t\u0011\t=\u0015\u0011\u001aC\u0005\u0005#\u000bQ\u0004^3mYN+7o]5p]\u0006\u0013w.\u001e;UQ\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u000b\u0005;\u0012\u0019Ja&\u0003\u001c\nE\u0006b\u0002BK\u0005\u001b\u0003\r\u0001L\u0001\u000fg\u001a\u001cXm]:j_:\f5\r^8s\u0011\u001d\u0011IJ!$A\u0002Y\u000baa]3tg&#\u0007\u0002\u0003BO\u0005\u001b\u0003\rAa(\u0002\r\u0019L\u00070T:h!\u0011y\u0001J!)\u0011\t\t\r&QV\u0007\u0003\u0005KSAAa*\u0003*\u00069Q.Z:tC\u001e,'b\u0001BV\t\u000511m\\7n_:LAAa,\u0003&\nI1KZ'fgN\fw-\u001a\u0005\t\u0005g\u0013i\t1\u0001\u00036\u0006\u0011B-Z2pI&twMR1jY\u0016$G)\u0019;b!\u0011y\u0001Ja.\u0011\t\t]\"\u0011X\u0005\u0005\u0005w\u0013ID\u0001\nEK\u000e|G-\u001b8h\r\u0006LG.\u001a3ECR\f\u0007\u0002\u0003B`\u0003\u0013$IA!1\u00027Q,G\u000e\\*fgNLwN\\!di>\u00148i\\7ng&\u001bHi\\<o+\t\u0011i\u0006\u0003\u0005\u0003F\u0006%G\u0011\u0001Bd\u0003QA\u0017M\u001c3mK\u001e\u000b'O\u00197fI6+7o]1hKR1!Q\fBe\u0005\u001bDqAa3\u0003D\u0002\u0007a'\u0001\u0004sK\u0006\u001cxN\u001c\u0005\t\u0005\u001f\u0014\u0019\r1\u0001\u0003R\u0006\u0001B-Z2pI\u0016\u0014H+[7fgR\fW\u000e\u001d\t\u0005\u0005o\u0011\u0019.\u0003\u0003\u0003V\ne\"!\u0005#fG>$WM\u001d+j[\u0016\u001cH/Y7qg\"A!\u0011\\Ae\t\u0003\u0011\t-A\u0006dY>\u001cXmU8dW\u0016$\b\u0002\u0003Bo\u0003\u0013$IAa8\u0002\u001fI,7m\u001c:e\u0019\u0006$XM\\2jKN$BA!\u0018\u0003b\"A!1\u001dBn\u0001\u0004\u0011\t.\u0001\u0002ug\"A!q]Ae\t\u0003\u0011I/\u0001\rsK\u000e,\u0017N^3e\u00036+7o]1hK\u000e\u000bG\u000e\u001c2bG.$\u0002B!\u0018\u0003l\n]81\u0001\u0005\t\u0005[\u0014)\u000f1\u0001\u0003p\u0006IQn]4UkBdWm\u001d\t\u0006\u001f\tE(Q_\u0005\u0004\u0005g\u0004\"!B!se\u0006L\bCB\b\u0002\u000e\u0006Ma\u0007\u0003\u0005\u0003z\n\u0015\b\u0019\u0001B~\u00035\u0011XM[3di\u0012+G/Y5mgB!q\u0002\u0013B\u007f!\u0011\u00119Da@\n\t\r\u0005!\u0011\b\u0002\u001a\r&D8\u000b\u001e:EK\u000e|G-\u001a*fU\u0016\u001cG\u000fR3uC&d7\u000f\u0003\u0005\u0004\u0006\t\u0015\b\u0019\u0001Bi\u0003E!WmY8eKJ$\u0016.\\3ti\u0006l\u0007o\u001d\u0005\t\u0007\u0013\tI\r\"\u0003\u0004\f\u0005\u0001\u0002.\u00198eY\u0016$UmY8eK\u0012l5o\u001a\u000b\t\u0005;\u001aiaa\u0004\u0004\u0014!11ea\u0002A\u0002\u0011B\u0001b!\u0005\u0004\b\u0001\u0007!\u0011U\u0001\u0004[N<\u0007\u0002CB\u000b\u0007\u000f\u0001\raa\u0006\u0002\u001dA\u0014X\rR3d_\u0012,g*\u00198pgB\u0019qb!\u0007\n\u0007\rm\u0001C\u0001\u0003M_:<\u0007\u0002CB\u0010\u0003\u0013$Ia!\t\u00021!\fg\u000e\u001a7f\r\u0006LG.\u001e:f)>$UmY8eK6\u001bx\r\u0006\u0003\u0004$\r\u001dB\u0003\u0002B/\u0007KA\u0001Ba-\u0004\u001e\u0001\u0007!q\u0017\u0005\u0007G\ru\u0001\u0019\u0001\u0013\t\u0011\r-\u0012\u0011\u001aC\u0001\u0007[\tad\u0019:fCR,'+\u001a9ms6+7o]1hK\u001a{'OT8TKN\u001c\u0018n\u001c8\u0015\u0011\t\u00056qFB\u001a\u0007oA\u0001b!\r\u0004*\u0001\u0007!\u0011U\u0001\fS:\u001cw.\\5oO6\u001bx\rC\u0004\u00046\r%\u0002\u0019\u0001\u001c\u0002\u000f5\u001cx\rV=qK\"A1\u0011HB\u0015\u0001\u0004\u0019Y$A\bpkR<w.\u001b8h\u001bN<'i\u001c3z!\u0011\u0019ida\u0012\u000e\u0005\r}\"\u0002BB!\u0007\u0007\naAZ5fY\u0012\u001c(\u0002BB#\u0005S\u000b\u0011B^1mS\u0012\fG/\u001a3\n\t\r%3q\b\u0002\u0011'\u001a4\u0015\u000e_'fgN\fw-\u001a\"pIfD\u0001ba\u000b\u0002J\u0012\u00051Q\n\u000b\t\u0005C\u001bye!\u0015\u0004T!9!\u0011TB&\u0001\u00041\u0006bBB\u001b\u0007\u0017\u0002\rA\u000e\u0005\t\u0007s\u0019Y\u00051\u0001\u0004<\u0001")
public class SfSocketHandlerActor
implements Actor,
ActorLogging {
    private final SfSessionType sessionType;
    private final ActorRef connection;
    private final SfSessionLookup sessionLookup;
    private final String remoteHostName;
    private final BusinessCommsHandler businessComms;
    private final Option<ActorRef> latencyRecorder;
    private final Logger fixlog;
    private final SfDecodeBytesToTuples org$sackfix$socket$SfSocketHandlerActor$$fixDecoder;
    private final Function1<ByteString, BoxedUnit> org$sackfix$socket$SfSocketHandlerActor$$fixDecodeByteString;
    private Option<SfSessOutEventRouter> outEventRouter;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public static Props props(SfSessionType sfSessionType, ActorRef actorRef, SfSessionLookup sfSessionLookup, String string, BusinessCommsHandler businessCommsHandler, Option<ActorRef> option) {
        return SfSocketHandlerActor$.MODULE$.props(sfSessionType, actorRef, sfSessionLookup, string, businessCommsHandler, option);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public LoggingAdapter log() {
        return ActorLogging.class.log((ActorLogging)this);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public final ActorRef sender() {
        return Actor.class.sender((Actor)this);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
    }

    public void aroundPreStart() {
        Actor.class.aroundPreStart((Actor)this);
    }

    public void aroundPostStop() {
        Actor.class.aroundPostStop((Actor)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
    }

    public void aroundPostRestart(Throwable reason) {
        Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.class.supervisorStrategy((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.class.preStart((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.class.postStop((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.class.preRestart((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.class.postRestart((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.class.unhandled((Actor)this, (Object)message);
    }

    public SfSessionType sessionType() {
        return this.sessionType;
    }

    public ActorRef connection() {
        return this.connection;
    }

    public SfSessionLookup sessionLookup() {
        return this.sessionLookup;
    }

    public String remoteHostName() {
        return this.remoteHostName;
    }

    public BusinessCommsHandler businessComms() {
        return this.businessComms;
    }

    public Option<ActorRef> latencyRecorder() {
        return this.latencyRecorder;
    }

    private Logger fixlog() {
        return this.fixlog;
    }

    public SfDecodeBytesToTuples org$sackfix$socket$SfSocketHandlerActor$$fixDecoder() {
        return this.org$sackfix$socket$SfSocketHandlerActor$$fixDecoder;
    }

    public Function1<ByteString, BoxedUnit> org$sackfix$socket$SfSocketHandlerActor$$fixDecodeByteString() {
        return this.org$sackfix$socket$SfSocketHandlerActor$$fixDecodeByteString;
    }

    private Option<SfSessOutEventRouter> outEventRouter() {
        return this.outEventRouter;
    }

    private void outEventRouter_$eq(Option<SfSessOutEventRouter> x$1) {
        this.outEventRouter = x$1;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSocketHandlerActor $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InitiatorSocketOpenMsgIn) {
                    InitiatorSocketOpenMsgIn initiatorSocketOpenMsgIn = (InitiatorSocketOpenMsgIn)A1;
                    SfSessionId sessionId = initiatorSocketOpenMsgIn.sessionId();
                    ActorRef sessionActor = initiatorSocketOpenMsgIn.sessionActor();
                    if (sessionId != null) {
                        SfSessionId sfSessionId = sessionId;
                        if (sessionActor != null) {
                            ActorRef actorRef = sessionActor;
                            this.$outer.org$sackfix$socket$SfSocketHandlerActor$$tellSessionAboutTheConnection(actorRef, sfSessionId, (Option<SfMessage>)None$.MODULE$, (Option<DecodingFailedData>)None$.MODULE$);
                            object = BoxedUnit.UNIT;
                            return (B1)object;
                        }
                    }
                }
                if (A1 instanceof Tcp.Received) {
                    Tcp.Received received = (Tcp.Received)A1;
                    ByteString data = received.data();
                    object = this.$outer.org$sackfix$socket$SfSocketHandlerActor$$fixDecodeByteString().apply((Object)data);
                    return (B1)object;
                }
                if (Tcp.PeerClosed$.MODULE$.equals(A1)) {
                    this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected PeerClosed to [", "], closing myself down"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.remoteHostName()})));
                    this.$outer.org$sackfix$socket$SfSocketHandlerActor$$tellSessionActorCommsIsDown();
                    this.$outer.context().stop(this.$outer.self());
                    object = BoxedUnit.UNIT;
                    return (B1)object;
                }
                if (Tcp.Unbound$.MODULE$.equals(A1)) {
                    this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Socket closed to [", "], closing myself down"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.remoteHostName()})));
                    this.$outer.org$sackfix$socket$SfSocketHandlerActor$$tellSessionActorCommsIsDown();
                    this.$outer.context().stop(this.$outer.self());
                    object = BoxedUnit.UNIT;
                    return (B1)object;
                }
                if (A1 instanceof Terminated) {
                    this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected death of actor connection to [", "], closing myself down"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.remoteHostName()})));
                    this.$outer.org$sackfix$socket$SfSocketHandlerActor$$tellSessionActorCommsIsDown();
                    this.$outer.context().stop(this.$outer.self());
                    object = BoxedUnit.UNIT;
                    return (B1)object;
                }
                if (SfSocketHandlerActor$CloseSocketMsgIn$.MODULE$.equals(A1)) {
                    this.$outer.closeSocket();
                    object = BoxedUnit.UNIT;
                    return (B1)object;
                }
                if (A1 instanceof Tcp.ConnectionClosed) {
                    this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection closed to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.remoteHostName()})));
                    this.$outer.org$sackfix$socket$SfSocketHandlerActor$$tellSessionActorCommsIsDown();
                    this.$outer.context().stop(this.$outer.self());
                    object = BoxedUnit.UNIT;
                    return (B1)object;
                }
                this.$outer.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Match error: unexpected message received by Actor :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A1.getClass().getName()})));
                object = BoxedUnit.UNIT;
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof InitiatorSocketOpenMsgIn) {
                    InitiatorSocketOpenMsgIn initiatorSocketOpenMsgIn = (InitiatorSocketOpenMsgIn)object;
                    SfSessionId sessionId = initiatorSocketOpenMsgIn.sessionId();
                    ActorRef sessionActor = initiatorSocketOpenMsgIn.sessionActor();
                    if (sessionId != null && sessionActor != null) {
                        return true;
                    }
                }
                if (object instanceof Tcp.Received) {
                    return true;
                }
                if (Tcp.PeerClosed$.MODULE$.equals(object)) {
                    return true;
                }
                if (Tcp.Unbound$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Terminated) {
                    return true;
                }
                if (SfSocketHandlerActor$CloseSocketMsgIn$.MODULE$.equals(object)) {
                    return true;
                }
                if (!(object instanceof Tcp.ConnectionClosed)) return true;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void org$sackfix$socket$SfSocketHandlerActor$$tellSessionAboutTheConnection(ActorRef sfsessionActor, SfSessionId sessId, Option<SfMessage> fixMsg, Option<DecodingFailedData> decodingFailedData) {
        if (this.outEventRouter().isEmpty()) {
            this.outEventRouter_$eq((Option<SfSessOutEventRouter>)new Some((Object)new SfSessOutEventRouterImpl(this.businessComms(), sfsessionActor, sessId, this.connection(), this.remoteHostName())));
            package$.MODULE$.actorRef2Scala(sfsessionActor).$bang((Object)new SfSessionActor.ConnectionEstablishedMsgIn((SfSessOutEventRouter)this.outEventRouter().get(), fixMsg, decodingFailedData), this.self());
        }
    }

    public void org$sackfix$socket$SfSocketHandlerActor$$tellSessionActorCommsIsDown() {
        this.outEventRouter().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSocketHandlerActor $outer;

            public final void apply(SfSessOutEventRouter x$1) {
                package$.MODULE$.actorRef2Scala(x$1.sfSessionActor()).$bang((Object)new SfSessionActor.TcpSaysSocketIsClosedMsgIn(this.$outer.connection()), this.$outer.self());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.outEventRouter_$eq((Option<SfSessOutEventRouter>)None$.MODULE$);
    }

    public void handleGarbledMessage(String reason, DecoderTimestamps decoderTimestamp) {
        this.recordLatencies(decoderTimestamp);
        this.log().warning(reason);
    }

    public void closeSocket() {
        this.log().info("Sending close to socket actor");
        package$.MODULE$.actorRef2Scala(this.connection()).$bang((Object)Tcp.Close$.MODULE$, this.self());
    }

    private void recordLatencies(DecoderTimestamps ts) {
        this.latencyRecorder().foreach((Function1)new Serializable(this, ts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSocketHandlerActor $outer;
            private final DecoderTimestamps ts$1;

            public final void apply(ActorRef rec) {
                int seqNum = new StringOps(Predef$.MODULE$.augmentString(this.ts$1.msgSeqNum())).toInt();
                package$.MODULE$.actorRef2Scala(rec).$bang((Object)new LatencyActor.RecordMsgLatenciesMsgIn((List<LatencyActor.RecordMsgLatencyMsgIn>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LatencyActor.RecordMsgLatencyMsgIn[]{new LatencyActor.RecordMsgLatencyMsgIn(seqNum, "00.FirstByte", this.ts$1.firstByteTstampNanos(), true), new LatencyActor.RecordMsgLatencyMsgIn(seqNum, "01.LastByte", this.ts$1.lastByteTstampNanos(), LatencyActor$RecordMsgLatencyMsgIn$.MODULE$.apply$default$4())}))), this.$outer.self());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ts$1 = ts$1;
            }
        });
        if (this.fixlog().isInfoEnabled()) {
            this.fixlog().info("IN  {}", new Object[]{ts.rawMsg().slice(0, ts.msgEndPos()).utf8String()});
        }
    }

    public void receivedAMessageCallback(Tuple2<Object, String>[] msgTuples, Option<FixStrDecodeRejectDetails> rejectDetails, DecoderTimestamps decoderTimestamps) {
        Option<SfMessage> option;
        block4: {
            block3: {
                block2: {
                    Some some;
                    SfMessage msg;
                    this.recordLatencies(decoderTimestamps);
                    long preDecodeNanos = System.nanoTime();
                    option = SfDecodeTuplesToMsg$.MODULE$.decode(msgTuples, rejectDetails, (Function1<DecodingFailedData, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SfSocketHandlerActor $outer;

                        public final void apply(DecodingFailedData decodingFailedData) {
                            this.$outer.org$sackfix$socket$SfSocketHandlerActor$$handleFailureToDecodeMsg(this.$outer.sessionType(), decodingFailedData);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, this.latencyRecorder());
                    if (!(option instanceof Some) || (msg = (SfMessage)(some = (Some)option).x()) == null) break block2;
                    SfMessage sfMessage = msg;
                    this.handleDecodedMsg(this.sessionType(), sfMessage, preDecodeNanos);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleDecodedMsg(SfSessionType sessionType, SfMessage msg, long preDecodeNanos) {
        int seqNum = msg.header().msgSeqNumField().value();
        if (this.latencyRecorder().isDefined()) {
            this.latencyRecorder().foreach((Function1)new Serializable(this, preDecodeNanos, seqNum){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SfSocketHandlerActor $outer;
                private final long preDecodeNanos$1;
                private final int seqNum$1;

                public final void apply(ActorRef x$2) {
                    package$.MODULE$.actorRef2Scala(x$2).$bang((Object)new LatencyActor.RecordMsgLatencyMsgIn(this.seqNum$1, "10.ToTuples", this.preDecodeNanos$1, LatencyActor$RecordMsgLatencyMsgIn$.MODULE$.apply$default$4()), this.$outer.self());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.preDecodeNanos$1 = preDecodeNanos$1;
                    this.seqNum$1 = seqNum$1;
                }
            });
            this.latencyRecorder().foreach((Function1)new Serializable(this, seqNum){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SfSocketHandlerActor $outer;
                private final int seqNum$1;

                public final void apply(ActorRef x$3) {
                    package$.MODULE$.actorRef2Scala(x$3).$bang((Object)new LatencyActor.RecordMsgLatencyMsgIn(this.seqNum$1, "20.ToMsg", System.nanoTime(), LatencyActor$RecordMsgLatencyMsgIn$.MODULE$.apply$default$4()), this.$outer.self());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.seqNum$1 = seqNum$1;
                }
            });
        }
        if (this.outEventRouter().isEmpty()) {
            SfSessionId sessId = SfSessionId$.MODULE$.apply(msg.header());
            Option<ActorRef> option = this.sessionLookup().findSession(sessId);
            if (option instanceof Some) {
                Some some = (Some)option;
                ActorRef session = (ActorRef)some.x();
                this.org$sackfix$socket$SfSocketHandlerActor$$tellSessionAboutTheConnection(session, sessId, (Option<SfMessage>)new Some((Object)msg), (Option<DecodingFailedData>)None$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                this.log().warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to locate session in session cache using [", "], closing socket"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sessId.toString()})));
                this.closeSocket();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.latencyRecorder().foreach((Function1)new Serializable(this, seqNum){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SfSocketHandlerActor $outer;
                private final int seqNum$1;

                public final void apply(ActorRef x$4) {
                    package$.MODULE$.actorRef2Scala(x$4).$bang((Object)new LatencyActor.RecordMsgLatencyMsgIn(this.seqNum$1, "21.! FixMsgIn", System.nanoTime(), LatencyActor$RecordMsgLatencyMsgIn$.MODULE$.apply$default$4()), this.$outer.self());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.seqNum$1 = seqNum$1;
                }
            });
            this.outEventRouter().foreach((Function1)new Serializable(this, msg){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SfSocketHandlerActor $outer;
                private final SfMessage msg$1;

                public final void apply(SfSessOutEventRouter x$5) {
                    package$.MODULE$.actorRef2Scala(x$5.sfSessionActor()).$bang((Object)new SfSessionActor.FixMsgIn(this.msg$1), this.$outer.self());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.msg$1 = msg$1;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void org$sackfix$socket$SfSocketHandlerActor$$handleFailureToDecodeMsg(SfSessionType sessionType, DecodingFailedData decodingFailedData) {
        if (this.outEventRouter().isEmpty()) {
            Option<SfSessionId> option = decodingFailedData.sessionId();
            if (option instanceof Some) {
                Some some = (Some)option;
                SfSessionId sessId = (SfSessionId)some.x();
                Option<ActorRef> option2 = this.sessionLookup().findSession(sessId);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    ActorRef session = (ActorRef)some2.x();
                    this.org$sackfix$socket$SfSocketHandlerActor$$tellSessionAboutTheConnection(session, sessId, (Option<SfMessage>)None$.MODULE$, (Option<DecodingFailedData>)new Some((Object)decodingFailedData));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    this.log().warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replacing other failure, with socket close - they sent invalid session details (", ") original error was: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sessId.toString(), decodingFailedData.description().value()})));
                    this.closeSocket();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                this.log().warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find mandatory session id fields, so closing socket,", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decodingFailedData.description().value()})));
                this.closeSocket();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.outEventRouter().foreach((Function1)new Serializable(this, decodingFailedData){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SfSocketHandlerActor $outer;
                private final DecodingFailedData decodingFailedData$1;

                public final void apply(SfSessOutEventRouter x$6) {
                    package$.MODULE$.actorRef2Scala(x$6.sfSessionActor()).$bang((Object)new SfSessionActor.SendRejectMessageOut(this.decodingFailedData$1.referenceSeqNum(), this.decodingFailedData$1.rejectReason(), this.decodingFailedData$1.description()), this.$outer.self());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.decodingFailedData$1 = decodingFailedData$1;
                }
            });
        }
    }

    public SfMessage createReplyMessageForNoSession(SfMessage incomingMsg, String msgType, SfFixMessageBody outgoingMsgBody) {
        return this.createReplyMessageForNoSession(SfSessionId$.MODULE$.apply(incomingMsg.header()), msgType, outgoingMsgBody);
    }

    public SfMessage createReplyMessageForNoSession(SfSessionId sessId, String msgType, SfFixMessageBody outgoingMsgBody) {
        BeginStringField x$7 = new BeginStringField(sessId.beginString());
        MsgTypeField x$8 = new MsgTypeField(msgType);
        SenderCompIDField x$9 = new SenderCompIDField(sessId.targetCompId());
        TargetCompIDField x$10 = new TargetCompIDField(sessId.senderCompId());
        MsgSeqNumField x$11 = new MsgSeqNumField(0);
        SendingTimeField x$12 = new SendingTimeField(LocalDateTime.now());
        Option x$13 = SfMessageHeader$.MODULE$.apply$default$2();
        Option x$14 = SfMessageHeader$.MODULE$.apply$default$4();
        Option x$15 = SfMessageHeader$.MODULE$.apply$default$5();
        Option x$16 = SfMessageHeader$.MODULE$.apply$default$6();
        Option x$17 = SfMessageHeader$.MODULE$.apply$default$9();
        Option x$18 = SfMessageHeader$.MODULE$.apply$default$10();
        Option x$19 = SfMessageHeader$.MODULE$.apply$default$11();
        Option x$20 = SfMessageHeader$.MODULE$.apply$default$12();
        Option x$21 = SfMessageHeader$.MODULE$.apply$default$14();
        Option x$22 = SfMessageHeader$.MODULE$.apply$default$15();
        Option x$23 = SfMessageHeader$.MODULE$.apply$default$16();
        Option x$24 = SfMessageHeader$.MODULE$.apply$default$17();
        Option x$25 = SfMessageHeader$.MODULE$.apply$default$18();
        Option x$26 = SfMessageHeader$.MODULE$.apply$default$19();
        Option x$27 = SfMessageHeader$.MODULE$.apply$default$20();
        Option x$28 = SfMessageHeader$.MODULE$.apply$default$21();
        Option x$29 = SfMessageHeader$.MODULE$.apply$default$22();
        Option x$30 = SfMessageHeader$.MODULE$.apply$default$23();
        Option x$31 = SfMessageHeader$.MODULE$.apply$default$25();
        Option x$32 = SfMessageHeader$.MODULE$.apply$default$26();
        Option x$33 = SfMessageHeader$.MODULE$.apply$default$27();
        Option x$34 = SfMessageHeader$.MODULE$.apply$default$28();
        Option x$35 = SfMessageHeader$.MODULE$.apply$default$29();
        Option x$36 = SfMessageHeader$.MODULE$.apply$default$30();
        Option x$37 = SfMessageHeader$.MODULE$.apply$default$31();
        SfMessageHeader header = new SfMessageHeader(x$7, x$13, x$8, x$14, x$15, x$16, x$9, x$10, x$17, x$18, x$19, x$20, x$11, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$12, x$31, x$32, x$33, x$34, x$35, x$36, x$37);
        return new SfMessage(header, outgoingMsgBody, SfMessage$.MODULE$.$lessinit$greater$default$3(), SfMessage$.MODULE$.$lessinit$greater$default$4());
    }

    public SfSocketHandlerActor(SfSessionType sessionType, ActorRef connection, SfSessionLookup sessionLookup, String remoteHostName, BusinessCommsHandler businessComms, Option<ActorRef> latencyRecorder) {
        this.sessionType = sessionType;
        this.connection = connection;
        this.sessionLookup = sessionLookup;
        this.remoteHostName = remoteHostName;
        this.businessComms = businessComms;
        this.latencyRecorder = latencyRecorder;
        Actor.class.$init$((Actor)this);
        ActorLogging.class.$init$((ActorLogging)this);
        this.fixlog = LoggerFactory.getLogger((String)"fixmessages");
        this.fixlog().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"### Socket handler from ", " opening at ", " ###"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{remoteHostName, LocalDateTime.now()})));
        this.org$sackfix$socket$SfSocketHandlerActor$$fixDecoder = new SfDecodeBytesToTuples(true);
        Serializable serializable = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSocketHandlerActor $outer;

            public final void apply(Tuple2<Object, String>[] msgTuples, Option<FixStrDecodeRejectDetails> rejectDetails, DecoderTimestamps decoderTimestamps) {
                this.$outer.receivedAMessageCallback(msgTuples, rejectDetails, decoderTimestamps);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        Serializable serializable2 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSocketHandlerActor $outer;

            public final void apply(String reason, DecoderTimestamps decoderTimestamp) {
                this.$outer.handleGarbledMessage(reason, decoderTimestamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.org$sackfix$socket$SfSocketHandlerActor$$fixDecodeByteString = new Serializable(this, (Function3)serializable, (Function2)serializable2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SfSocketHandlerActor $outer;
            private final Function3 eta$0$1$1;
            private final Function2 eta$1$1$1;

            public final void apply(ByteString rawInput) {
                this.$outer.org$sackfix$socket$SfSocketHandlerActor$$fixDecoder().decode((Function3<Tuple2<Object, String>[], Option<FixStrDecodeRejectDetails>, DecoderTimestamps, BoxedUnit>)this.eta$0$1$1, (Function2<String, DecoderTimestamps, BoxedUnit>)this.eta$1$1$1, rawInput);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.eta$0$1$1 = eta$0$1$1;
                this.eta$1$1$1 = eta$1$1$1;
            }
        };
        this.outEventRouter = None$.MODULE$;
        this.context().watch(connection);
    }

    public static class InitiatorSocketOpenMsgIn
    implements Product,
    Serializable {
        private final SfSessionId sessionId;
        private final ActorRef sessionActor;

        public SfSessionId sessionId() {
            return this.sessionId;
        }

        public ActorRef sessionActor() {
            return this.sessionActor;
        }

        public InitiatorSocketOpenMsgIn copy(SfSessionId sessionId, ActorRef sessionActor) {
            return new InitiatorSocketOpenMsgIn(sessionId, sessionActor);
        }

        public SfSessionId copy$default$1() {
            return this.sessionId();
        }

        public ActorRef copy$default$2() {
            return this.sessionActor();
        }

        public String productPrefix() {
            return "InitiatorSocketOpenMsgIn";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.sessionActor();
                    break;
                }
                case 0: {
                    object = this.sessionId();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof InitiatorSocketOpenMsgIn;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof InitiatorSocketOpenMsgIn)) return false;
            boolean bl = true;
            if (!bl) return false;
            InitiatorSocketOpenMsgIn initiatorSocketOpenMsgIn = (InitiatorSocketOpenMsgIn)x$1;
            SfSessionId sfSessionId = this.sessionId();
            SfSessionId sfSessionId2 = initiatorSocketOpenMsgIn.sessionId();
            if (sfSessionId == null) {
                if (sfSessionId2 != null) {
                    return false;
                }
            } else if (!((Object)sfSessionId).equals(sfSessionId2)) return false;
            ActorRef actorRef = this.sessionActor();
            ActorRef actorRef2 = initiatorSocketOpenMsgIn.sessionActor();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            if (!initiatorSocketOpenMsgIn.canEqual(this)) return false;
            return true;
        }

        public InitiatorSocketOpenMsgIn(SfSessionId sessionId, ActorRef sessionActor) {
            this.sessionId = sessionId;
            this.sessionActor = sessionActor;
            Product.class.$init$((Product)this);
        }
    }
}

