/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.haiti.core.page;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sadtech.haiti.context.page.Sheet;

public class SheetImpl<T>
implements Sheet<T> {
    private final int number;
    private final int size;
    private final long totalElement;
    private final int totalPage;
    private final List<T> content;

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public <U> Sheet<U> map(Function<? super T, ? extends U> function) {
        return new SheetImpl(this.number, this.size, this.totalElement, this.totalPage, this.content.stream().map(function).collect(Collectors.toList()));
    }

    public static <T> SheetImplBuilder<T> builder() {
        return new SheetImplBuilder();
    }

    public int getNumber() {
        return this.number;
    }

    public int getSize() {
        return this.size;
    }

    public long getTotalElement() {
        return this.totalElement;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public List<T> getContent() {
        return this.content;
    }

    public SheetImpl(int number, int size, long totalElement, int totalPage, List<T> content) {
        this.number = number;
        this.size = size;
        this.totalElement = totalElement;
        this.totalPage = totalPage;
        this.content = content;
    }

    public static class SheetImplBuilder<T> {
        private int number;
        private int size;
        private long totalElement;
        private int totalPage;
        private List<T> content;

        SheetImplBuilder() {
        }

        public SheetImplBuilder<T> number(int number) {
            this.number = number;
            return this;
        }

        public SheetImplBuilder<T> size(int size) {
            this.size = size;
            return this;
        }

        public SheetImplBuilder<T> totalElement(long totalElement) {
            this.totalElement = totalElement;
            return this;
        }

        public SheetImplBuilder<T> totalPage(int totalPage) {
            this.totalPage = totalPage;
            return this;
        }

        public SheetImplBuilder<T> content(List<T> content) {
            this.content = content;
            return this;
        }

        public SheetImpl<T> build() {
            return new SheetImpl<T>(this.number, this.size, this.totalElement, this.totalPage, this.content);
        }

        public String toString() {
            return "SheetImpl.SheetImplBuilder(number=" + this.number + ", size=" + this.size + ", totalElement=" + this.totalElement + ", totalPage=" + this.totalPage + ", content=" + this.content + ")";
        }
    }
}

