/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.haiti.core.service;

import java.util.Optional;
import lombok.NonNull;
import org.sadtech.haiti.context.page.Pagination;
import org.sadtech.haiti.context.page.Sheet;
import org.sadtech.haiti.filter.Filter;
import org.sadtech.haiti.filter.FilterOperation;
import org.sadtech.haiti.filter.FilterService;

public abstract class AbstractFilterService<T, F>
implements FilterService<T, F> {
    private final FilterOperation<T> filterOperation;

    public Sheet<T> getAll(@NonNull F filter, Pagination pagination) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return this.filterOperation.findAll(this.createFilter(filter), pagination);
    }

    public Optional<T> getFirst(@NonNull F filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return this.filterOperation.findFirst(this.createFilter(filter));
    }

    public boolean exists(@NonNull F filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return this.filterOperation.exists(this.createFilter(filter));
    }

    public long count(@NonNull F filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return this.filterOperation.count(this.createFilter(filter));
    }

    protected abstract Filter createFilter(@NonNull F var1);

    public AbstractFilterService(FilterOperation<T> filterOperation) {
        this.filterOperation = filterOperation;
    }
}

